/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.skills.repair;

import com.gmail.nossr50.config.BukkitConfig;
import com.gmail.nossr50.datatypes.skills.ItemType;
import com.gmail.nossr50.datatypes.skills.MaterialType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import com.gmail.nossr50.skills.repair.repairables.RepairableFactory;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.LogUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class RepairConfig
extends BukkitConfig {
    private final HashSet<String> notSupported = new HashSet();
    private List<Repairable> repairables;

    public RepairConfig(String fileName, boolean copyDefaults) {
        super(fileName, copyDefaults);
        this.loadKeys();
    }

    @Override
    protected void loadKeys() {
        this.repairables = new ArrayList<Repairable>();
        if (!this.config.isConfigurationSection("Repairables")) {
            mcMMO.p.getLogger().severe("Could not find Repairables section in " + this.fileName);
            return;
        }
        ConfigurationSection section = this.config.getConfigurationSection("Repairables");
        Set keys = section.getKeys(false);
        for (String key : keys) {
            int minimumQuantity;
            short maximumDurability;
            Material repairMaterial;
            if (this.config.contains("Repairables." + key + ".ItemId")) {
                this.backup();
                return;
            }
            ArrayList<String> reason = new ArrayList<String>();
            Material itemMaterial = Material.matchMaterial((String)key);
            if (itemMaterial == null) {
                this.notSupported.add(key);
                continue;
            }
            MaterialType repairMaterialType = MaterialType.OTHER;
            String repairMaterialTypeString = this.config.getString("Repairables." + key + ".MaterialType", "OTHER");
            if (!this.config.contains("Repairables." + key + ".MaterialType") && itemMaterial != null) {
                ItemStack repairItem = new ItemStack(itemMaterial);
                if (ItemUtils.isWoodTool(repairItem)) {
                    repairMaterialType = MaterialType.WOOD;
                } else if (ItemUtils.isStoneTool(repairItem)) {
                    repairMaterialType = MaterialType.STONE;
                } else if (ItemUtils.isStringTool(repairItem)) {
                    repairMaterialType = MaterialType.STRING;
                } else if (ItemUtils.isLeatherArmor(repairItem)) {
                    repairMaterialType = MaterialType.LEATHER;
                } else if (ItemUtils.isIronArmor(repairItem) || ItemUtils.isIronTool(repairItem)) {
                    repairMaterialType = MaterialType.IRON;
                } else if (ItemUtils.isGoldArmor(repairItem) || ItemUtils.isGoldTool(repairItem)) {
                    repairMaterialType = MaterialType.GOLD;
                } else if (ItemUtils.isDiamondArmor(repairItem) || ItemUtils.isDiamondTool(repairItem)) {
                    repairMaterialType = MaterialType.DIAMOND;
                } else if (ItemUtils.isNetheriteArmor(repairItem) || ItemUtils.isNetheriteTool(repairItem)) {
                    repairMaterialType = MaterialType.NETHERITE;
                }
            } else {
                try {
                    repairMaterialType = MaterialType.valueOf(repairMaterialTypeString);
                }
                catch (IllegalArgumentException ex) {
                    reason.add(key + " has an invalid MaterialType of " + repairMaterialTypeString);
                }
            }
            String repairMaterialName = this.config.getString("Repairables." + key + ".RepairMaterial");
            Material material = repairMaterial = repairMaterialName == null ? repairMaterialType.getDefaultMaterial() : Material.matchMaterial((String)repairMaterialName);
            if (repairMaterial == null) {
                this.notSupported.add(key);
                continue;
            }
            short s = maximumDurability = itemMaterial != null ? itemMaterial.getMaxDurability() : (short)this.config.getInt("Repairables." + key + ".MaximumDurability");
            if (maximumDurability <= 0) {
                maximumDurability = (short)this.config.getInt("Repairables." + key + ".MaximumDurability");
            }
            if (maximumDurability <= 0) {
                reason.add("Maximum durability of " + key + " must be greater than 0!");
            }
            ItemType repairItemType = ItemType.OTHER;
            String repairItemTypeString = this.config.getString("Repairables." + key + ".ItemType", "OTHER");
            if (!this.config.contains("Repairables." + key + ".ItemType") && itemMaterial != null) {
                ItemStack repairItem = new ItemStack(itemMaterial);
                if (ItemUtils.isMinecraftTool(repairItem)) {
                    repairItemType = ItemType.TOOL;
                } else if (ItemUtils.isArmor(repairItem)) {
                    repairItemType = ItemType.ARMOR;
                }
            } else {
                try {
                    repairItemType = ItemType.valueOf(repairItemTypeString);
                }
                catch (IllegalArgumentException ex) {
                    reason.add(key + " has an invalid ItemType of " + repairItemTypeString);
                }
            }
            int minimumLevel = this.config.getInt("Repairables." + key + ".MinimumLevel");
            double xpMultiplier = this.config.getDouble("Repairables." + key + ".XpMultiplier", 1.0);
            if (minimumLevel < 0) {
                reason.add(key + " has an invalid MinimumLevel of " + minimumLevel);
            }
            if ((minimumQuantity = this.config.getInt("Repairables." + key + ".MinimumQuantity")) == 0) {
                minimumQuantity = -1;
            }
            if (!this.noErrorsInRepairable(reason)) continue;
            Repairable repairable = RepairableFactory.getRepairable(itemMaterial, repairMaterial, null, minimumLevel, maximumDurability, repairItemType, repairMaterialType, xpMultiplier, minimumQuantity);
            this.repairables.add(repairable);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.notSupported.size() > 0) {
            stringBuilder.append("mcMMO found the following materials in the Repair config that are not supported by the version of Minecraft running on this server: ");
            Iterator<String> iterator = this.notSupported.iterator();
            while (iterator.hasNext()) {
                String unsupportedMaterial = iterator.next();
                if (!iterator.hasNext()) {
                    stringBuilder.append(unsupportedMaterial);
                    continue;
                }
                stringBuilder.append(unsupportedMaterial).append(", ");
            }
            LogUtils.debug(mcMMO.p.getLogger(), stringBuilder.toString());
            LogUtils.debug(mcMMO.p.getLogger(), "Items using materials that are not supported will simply be skipped.");
        }
    }

    protected List<Repairable> getLoadedRepairables() {
        return this.repairables == null ? new ArrayList() : this.repairables;
    }

    private boolean noErrorsInRepairable(List<String> issues) {
        for (String issue : issues) {
            mcMMO.p.getLogger().warning(issue);
        }
        return issues.isEmpty();
    }
}

