/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.events.skills.fishing;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.events.skills.fishing.McMMOPlayerFishingEvent;
import com.gmail.nossr50.skills.fishing.FishingManager;
import org.jetbrains.annotations.NotNull;

public class McMMOPlayerMasterAnglerEvent
extends McMMOPlayerFishingEvent {
    private int reducedMinWaitTime;
    private int reducedMaxWaitTime;
    private final FishingManager fishingManager;

    public McMMOPlayerMasterAnglerEvent(@NotNull McMMOPlayer mcMMOPlayer, int reducedMinWaitTime, int reducedMaxWaitTime, FishingManager fishingManager) {
        super(mcMMOPlayer);
        this.fishingManager = fishingManager;
        this.reducedMinWaitTime = Math.max(reducedMinWaitTime, this.getReducedMinWaitTimeLowerBound());
        this.reducedMaxWaitTime = Math.max(reducedMaxWaitTime, this.getReducedMaxWaitTimeLowerBound());
    }

    public int getReducedMinWaitTime() {
        return this.reducedMinWaitTime;
    }

    public void setReducedMinWaitTime(int reducedMinWaitTime) {
        if (reducedMinWaitTime < 0 || reducedMinWaitTime > this.reducedMaxWaitTime) {
            throw new IllegalArgumentException("Reduced min wait time must be greater than or equal to 0 and less than reduced max wait time.");
        }
        this.reducedMinWaitTime = Math.max(reducedMinWaitTime, this.getReducedMinWaitTimeLowerBound());
    }

    public int getReducedMaxWaitTime() {
        return this.reducedMaxWaitTime;
    }

    public void setReducedMaxWaitTime(int reducedMaxWaitTime) {
        if (reducedMaxWaitTime < 0 || reducedMaxWaitTime < this.reducedMinWaitTime) {
            throw new IllegalArgumentException("Reduced max wait time must be greater than or equal to 0 and greater than reduced min wait time.");
        }
        this.reducedMaxWaitTime = Math.max(reducedMaxWaitTime, this.getReducedMaxWaitTimeLowerBound());
    }

    public int getReducedMinWaitTimeLowerBound() {
        return this.fishingManager.getMasterAnglerMinWaitLowerBound();
    }

    public int getReducedMaxWaitTimeLowerBound() {
        return this.fishingManager.getMasterAnglerMaxWaitLowerBound();
    }
}

