/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.skills;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.events.skills.alchemy.McMMOPlayerBrewEvent;
import com.gmail.nossr50.events.skills.alchemy.McMMOPlayerCatalysisEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.alchemy.Alchemy;
import com.gmail.nossr50.skills.alchemy.AlchemyPotionBrewer;
import com.gmail.nossr50.util.CancellableRunnable;
import com.gmail.nossr50.util.ContainerMetadataUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class AlchemyBrewTask
extends CancellableRunnable {
    private static final double DEFAULT_BREW_SPEED = 1.0;
    private static final int DEFAULT_BREW_TICKS = 400;
    private final BlockState brewingStand;
    private final OfflinePlayer offlinePlayer;
    private McMMOPlayer mmoPlayer;
    private double brewSpeed;
    private double brewTimer;
    private int fuel;
    private boolean firstRun = true;
    private int ingredientLevel = 1;

    @Deprecated(forRemoval=true, since="2.2.010")
    public AlchemyBrewTask(@NotNull BlockState brewingStand, Player ignored) {
        this(brewingStand);
    }

    public AlchemyBrewTask(@NotNull BlockState brewingStand) {
        this.offlinePlayer = ContainerMetadataUtils.getContainerOwner(brewingStand);
        McMMOPlayer mmoPlayer = null;
        if (this.offlinePlayer != null && this.offlinePlayer.isOnline()) {
            mmoPlayer = UserManager.getPlayer(this.offlinePlayer.getPlayer());
        }
        this.brewingStand = brewingStand;
        this.brewSpeed = 1.0;
        this.brewTimer = 400.0;
        if (mmoPlayer != null && !Misc.isNPCEntityExcludingVillagers((Entity)mmoPlayer.getPlayer()) && Permissions.isSubSkillEnabled((Permissible)mmoPlayer.getPlayer(), SubSkillType.ALCHEMY_CATALYSIS)) {
            this.ingredientLevel = mmoPlayer.getAlchemyManager().getTier();
            double catalysis = mmoPlayer.getAlchemyManager().calculateBrewSpeed(Permissions.lucky((Permissible)mmoPlayer.getPlayer(), PrimarySkillType.ALCHEMY));
            McMMOPlayerCatalysisEvent event = new McMMOPlayerCatalysisEvent(mmoPlayer, catalysis);
            mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.brewSpeed = catalysis;
            }
        }
        if (Alchemy.brewingStandMap.containsKey(brewingStand.getLocation())) {
            Alchemy.brewingStandMap.get(brewingStand.getLocation()).cancel();
        }
        this.fuel = ((BrewingStand)brewingStand).getFuelLevel();
        if (((BrewingStand)brewingStand).getBrewingTime() == -1) {
            --this.fuel;
        }
        Alchemy.brewingStandMap.put(brewingStand.getLocation(), this);
        mcMMO.p.getFoliaLib().getScheduler().runAtLocationTimer(brewingStand.getLocation(), this, 1L, 1L);
    }

    @Override
    public void run() {
        if (this.shouldCancelBrewing()) {
            if (Alchemy.brewingStandMap.containsKey(this.brewingStand.getLocation())) {
                Alchemy.brewingStandMap.remove(this.brewingStand.getLocation());
            }
            this.cancel();
            return;
        }
        this.initializeBrewing();
        this.brewTimer -= this.brewSpeed;
        if (this.isBrewingComplete()) {
            this.cancel();
            this.finish();
        } else {
            this.updateBrewingTime();
        }
    }

    private boolean shouldCancelBrewing() {
        if (this.offlinePlayer == null) {
            return true;
        }
        if (this.brewingStand == null) {
            return true;
        }
        if (this.brewingStand.getType() != Material.BREWING_STAND) {
            return true;
        }
        return !AlchemyPotionBrewer.isValidIngredientByLevel(this.getIngredientLevelUpdated(), ((BrewingStand)this.brewingStand).getInventory().getContents()[3]);
    }

    private int getIngredientLevelUpdated() {
        if (this.mmoPlayer != null) {
            this.ingredientLevel = this.mmoPlayer.getAlchemyManager().getTier();
            return this.ingredientLevel;
        }
        if (this.offlinePlayer.isOnline() && this.mmoPlayer == null) {
            McMMOPlayer fetchedMMOPlayer = UserManager.getPlayer(this.offlinePlayer.getPlayer());
            if (fetchedMMOPlayer != null) {
                this.mmoPlayer = fetchedMMOPlayer;
                this.ingredientLevel = this.mmoPlayer.getAlchemyManager().getTier();
            }
            return this.ingredientLevel;
        }
        return this.ingredientLevel;
    }

    private void initializeBrewing() {
        if (this.firstRun) {
            this.firstRun = false;
            ((BrewingStand)this.brewingStand).setFuelLevel(this.fuel);
        }
    }

    private boolean isBrewingComplete() {
        return this.brewTimer < Math.max(this.brewSpeed, 2.0);
    }

    private void updateBrewingTime() {
        ((BrewingStand)this.brewingStand).setBrewingTime((int)this.brewTimer);
    }

    private void finish() {
        if (this.mmoPlayer == null) {
            AlchemyPotionBrewer.finishBrewing(this.brewingStand, null, false);
        } else {
            McMMOPlayerBrewEvent event = new McMMOPlayerBrewEvent(this.mmoPlayer, this.brewingStand);
            mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                AlchemyPotionBrewer.finishBrewing(this.brewingStand, this.mmoPlayer, false);
            }
        }
        Alchemy.brewingStandMap.remove(this.brewingStand.getLocation());
    }

    public void finishImmediately() {
        this.cancel();
        AlchemyPotionBrewer.finishBrewing(this.brewingStand, this.mmoPlayer, true);
        Alchemy.brewingStandMap.remove(this.brewingStand.getLocation());
    }

    public void cancelBrew() {
        this.cancel();
        ((BrewingStand)this.brewingStand).setBrewingTime(-1);
        Alchemy.brewingStandMap.remove(this.brewingStand.getLocation());
    }
}

