/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.alchemy;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.alchemy.AlchemyPotion;
import com.gmail.nossr50.datatypes.skills.alchemy.PotionStage;
import com.gmail.nossr50.events.fake.FakeBrewEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.player.PlayerUpdateInventoryTask;
import com.gmail.nossr50.runnables.skills.AlchemyBrewCheckTask;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AlchemyPotionBrewer {
    private static final Method getItem;
    private static final Method setItem;

    @Deprecated(forRemoval=true, since="2.2.010")
    public static boolean isValidBrew(Player player, ItemStack[] contents) {
        if (!AlchemyPotionBrewer.isValidIngredientByPlayer(player, contents[3])) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            AlchemyPotion potion;
            if (contents[i] == null || contents[i].getType() != Material.POTION && contents[i].getType() != Material.SPLASH_POTION && contents[i].getType() != Material.LINGERING_POTION || AlchemyPotionBrewer.getChildPotion(potion = mcMMO.p.getPotionConfig().getPotion(contents[i]), contents[3]) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidBrew(int ingredientLevel, ItemStack[] contents) {
        if (!AlchemyPotionBrewer.isValidIngredientByLevel(ingredientLevel, contents[3])) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            AlchemyPotion potion;
            if (contents[i] == null || contents[i].getType() != Material.POTION && contents[i].getType() != Material.SPLASH_POTION && contents[i].getType() != Material.LINGERING_POTION || AlchemyPotionBrewer.getChildPotion(potion = mcMMO.p.getPotionConfig().getPotion(contents[i]), contents[3]) == null) continue;
            return true;
        }
        return false;
    }

    private static AlchemyPotion getChildPotion(AlchemyPotion potion, ItemStack ingredient) {
        if (potion != null) {
            return potion.getChild(ingredient);
        }
        return null;
    }

    public static boolean isEmpty(ItemStack item) {
        return item == null || item.getType() == Material.AIR || item.getAmount() == 0;
    }

    private static void removeIngredient(BrewerInventory inventory, Player player) {
        if (inventory.getIngredient() == null) {
            return;
        }
        ItemStack ingredient = inventory.getIngredient().clone();
        if (!AlchemyPotionBrewer.isEmpty(ingredient) && AlchemyPotionBrewer.isValidIngredientByPlayer(player, ingredient)) {
            if (ingredient.getAmount() <= 1) {
                inventory.setIngredient(null);
            } else {
                ingredient.setAmount(ingredient.getAmount() - 1);
                inventory.setIngredient(ingredient);
            }
        }
    }

    private static boolean hasIngredient(BrewerInventory inventory, Player player) {
        ItemStack ingredient = inventory.getIngredient() == null ? null : inventory.getIngredient().clone();
        return !AlchemyPotionBrewer.isEmpty(ingredient) && AlchemyPotionBrewer.isValidIngredientByPlayer(player, ingredient);
    }

    public static boolean isValidIngredientByPlayer(Player player, ItemStack item) {
        if (AlchemyPotionBrewer.isEmpty(item)) {
            return false;
        }
        for (ItemStack ingredient : AlchemyPotionBrewer.getValidIngredients(UserManager.getPlayer(player))) {
            if (!item.isSimilar(ingredient)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidIngredientByLevel(int ingredientLevel, ItemStack item) {
        if (AlchemyPotionBrewer.isEmpty(item)) {
            return false;
        }
        for (ItemStack ingredient : mcMMO.p.getPotionConfig().getIngredients(ingredientLevel)) {
            if (!item.isSimilar(ingredient)) continue;
            return true;
        }
        return false;
    }

    private static List<ItemStack> getValidIngredients(@Nullable McMMOPlayer mmoPlayer) {
        if (mmoPlayer == null) {
            return mcMMO.p.getPotionConfig().getIngredients(1);
        }
        return mcMMO.p.getPotionConfig().getIngredients(!Permissions.isSubSkillEnabled(mmoPlayer, SubSkillType.ALCHEMY_CONCOCTIONS) ? 1 : mmoPlayer.getAlchemyManager().getTier());
    }

    public static void finishBrewing(BlockState brewingStand, @Nullable McMMOPlayer mmoPlayer, boolean forced) {
        AlchemyPotion output;
        Player player;
        if (!(brewingStand instanceof BrewingStand)) {
            return;
        }
        BrewerInventory inventory = ((BrewingStand)brewingStand).getInventory();
        ItemStack ingredient = inventory.getIngredient() == null ? null : inventory.getIngredient().clone();
        Player player2 = player = mmoPlayer != null ? mmoPlayer.getPlayer() : null;
        if (ingredient == null) {
            return;
        }
        if (player == null || !AlchemyPotionBrewer.hasIngredient(inventory, player)) {
            return;
        }
        ArrayList<Object> inputList = new ArrayList<Object>(Collections.nCopies(3, null));
        ArrayList<Object> outputList = new ArrayList<Object>(Collections.nCopies(3, null));
        for (int i = 0; i < 3; ++i) {
            ItemStack potionInBrewStandInputSlot = inventory.getItem(i);
            if (AlchemyPotionBrewer.isEmpty(potionInBrewStandInputSlot) || potionInBrewStandInputSlot.getType() == Material.GLASS_BOTTLE || !mcMMO.p.getPotionConfig().isValidPotion(potionInBrewStandInputSlot)) continue;
            AlchemyPotion alchemyPotion = mcMMO.p.getPotionConfig().getPotion(potionInBrewStandInputSlot);
            output = alchemyPotion.getChild(ingredient);
            inputList.set(i, alchemyPotion);
            if (output == null) continue;
            outputList.set(i, output.toItemStack(potionInBrewStandInputSlot.getAmount()).clone());
        }
        FakeBrewEvent event = new FakeBrewEvent(brewingStand.getBlock(), inventory, outputList, ((BrewingStand)brewingStand).getFuelLevel());
        mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || inputList.isEmpty()) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (outputList.get(i) == null) continue;
            inventory.setItem(i, (ItemStack)outputList.get(i));
        }
        AlchemyPotionBrewer.removeIngredient(inventory, player);
        for (AlchemyPotion alchemyPotion : inputList) {
            if (alchemyPotion == null || (output = alchemyPotion.getChild(ingredient)) == null || player == null) continue;
            PotionStage potionStage = PotionStage.getPotionStage(alchemyPotion, output);
            if (UserManager.getPlayer(player) == null) continue;
            UserManager.getPlayer(player).getAlchemyManager().handlePotionBrewSuccesses(potionStage, 1);
        }
        if (!forced) {
            AlchemyPotionBrewer.scheduleUpdate((Inventory)inventory);
        }
    }

    public static boolean transferItems(InventoryView view, int fromSlot, ClickType click) {
        boolean success = false;
        try {
            if (click.isLeftClick()) {
                success = AlchemyPotionBrewer.transferItems(view, fromSlot);
            } else if (click.isRightClick()) {
                success = AlchemyPotionBrewer.transferOneItem(view, fromSlot);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return success;
    }

    private static boolean transferOneItem(InventoryView view, int fromSlot) throws InvocationTargetException, IllegalAccessException {
        ItemStack from = ((ItemStack)getItem.invoke((Object)view, fromSlot)).clone();
        ItemStack to = ((ItemStack)getItem.invoke((Object)view, 3)).clone();
        if (AlchemyPotionBrewer.isEmpty(from)) {
            return false;
        }
        boolean emptyTo = AlchemyPotionBrewer.isEmpty(to);
        int fromAmount = from.getAmount();
        if (!emptyTo && fromAmount >= from.getType().getMaxStackSize()) {
            return false;
        }
        if (emptyTo || from.isSimilar(to)) {
            if (emptyTo) {
                to = from.clone();
                to.setAmount(1);
            } else {
                to.setAmount(to.getAmount() + 1);
            }
            from.setAmount(fromAmount - 1);
            setItem.invoke((Object)view, 3, to);
            setItem.invoke((Object)view, fromSlot, from);
            return true;
        }
        return false;
    }

    private static boolean transferItems(InventoryView view, int fromSlot) throws InvocationTargetException, IllegalAccessException {
        ItemStack from = ((ItemStack)getItem.invoke((Object)view, fromSlot)).clone();
        ItemStack to = ((ItemStack)getItem.invoke((Object)view, 3)).clone();
        if (AlchemyPotionBrewer.isEmpty(from)) {
            return false;
        }
        if (AlchemyPotionBrewer.isEmpty(to)) {
            setItem.invoke((Object)view, 3, from);
            setItem.invoke((Object)view, fromSlot, null);
            return true;
        }
        if (from.isSimilar(to)) {
            int maxSize;
            int toAmount;
            int fromAmount = from.getAmount();
            if (fromAmount + (toAmount = to.getAmount()) > (maxSize = to.getType().getMaxStackSize())) {
                int left = fromAmount + toAmount - maxSize;
                to.setAmount(maxSize);
                setItem.invoke((Object)view, 3, to);
                from.setAmount(left);
                setItem.invoke((Object)view, fromSlot, from);
                return true;
            }
            to.setAmount(fromAmount + toAmount);
            setItem.invoke((Object)view, fromSlot, null);
            setItem.invoke((Object)view, 3, to);
            return true;
        }
        return false;
    }

    public static void scheduleCheck(@NotNull BrewingStand brewingStand) {
        mcMMO.p.getFoliaLib().getScheduler().runAtLocation(brewingStand.getLocation(), new AlchemyBrewCheckTask(brewingStand));
    }

    public static void scheduleUpdate(Inventory inventory) {
        for (HumanEntity humanEntity : inventory.getViewers()) {
            if (!(humanEntity instanceof Player)) continue;
            mcMMO.p.getFoliaLib().getScheduler().runAtEntity((Entity)humanEntity, new PlayerUpdateInventoryTask((Player)humanEntity));
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.bukkit.inventory.InventoryView");
            getItem = clazz.getDeclaredMethod("getItem", Integer.TYPE);
            setItem = clazz.getDeclaredMethod("setItem", Integer.TYPE, ItemStack.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

