/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.axes;

import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.axes.Axes;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class AxesManager
extends SkillManager {
    public AxesManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.AXES);
    }

    public boolean canUseAxeMastery() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.AXES_AXE_MASTERY)) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.AXES_AXE_MASTERY);
    }

    public boolean canCriticalHit(@NotNull LivingEntity target) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.AXES_CRITICAL_STRIKES)) {
            return false;
        }
        return target.isValid() && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.AXES_CRITICAL_STRIKES);
    }

    public boolean canImpact(@NotNull LivingEntity target) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.AXES_ARMOR_IMPACT)) {
            return false;
        }
        return target.isValid() && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.AXES_ARMOR_IMPACT) && Axes.hasArmor(target);
    }

    public boolean canGreaterImpact(@NotNull LivingEntity target) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.AXES_GREATER_IMPACT)) {
            return false;
        }
        return target.isValid() && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.AXES_GREATER_IMPACT) && !Axes.hasArmor(target);
    }

    public boolean canUseSkullSplitter(@NotNull LivingEntity target) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.AXES_SKULL_SPLITTER)) {
            return false;
        }
        return target.isValid() && this.mmoPlayer.getAbilityMode(SuperAbilityType.SKULL_SPLITTER) && Permissions.skullSplitter((Permissible)this.getPlayer());
    }

    public boolean canActivateAbility() {
        return this.mmoPlayer.getToolPreparationMode(ToolType.AXE) && Permissions.skullSplitter((Permissible)this.getPlayer());
    }

    public double axeMastery() {
        if (ProbabilityUtil.isNonRNGSkillActivationSuccessful(SubSkillType.AXES_AXE_MASTERY, this.mmoPlayer)) {
            return Axes.getAxeMasteryBonusDamage(this.getPlayer());
        }
        return 0.0;
    }

    public double criticalHit(LivingEntity target, double damage) {
        if (!ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.AXES_CRITICAL_STRIKES, this.mmoPlayer, this.mmoPlayer.getAttackStrength())) {
            return 0.0;
        }
        Player player = this.getPlayer();
        if (this.mmoPlayer.useChatNotifications()) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Axes.Combat.CriticalHit");
        }
        if (target instanceof Player) {
            Player defender = (Player)target;
            if (NotificationManager.doesPlayerUseNotifications(defender)) {
                NotificationManager.sendPlayerInformation(defender, NotificationType.SUBSKILL_MESSAGE, "Axes.Combat.CritStruck");
            }
            damage = damage * Axes.criticalHitPVPModifier - damage;
        } else {
            damage = damage * Axes.criticalHitPVEModifier - damage;
        }
        return damage;
    }

    public void impactCheck(@NotNull LivingEntity target) {
        double durabilityDamage = this.getImpactDurabilityDamage();
        EntityEquipment equipment = target.getEquipment();
        if (equipment == null) {
            return;
        }
        for (ItemStack armor : equipment.getArmorContents()) {
            if (armor == null || !ItemUtils.isArmor(armor) || !ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.AXES_ARMOR_IMPACT, this.mmoPlayer, this.mmoPlayer.getAttackStrength())) continue;
            SkillUtils.handleArmorDurabilityChange(armor, durabilityDamage, 1.0);
        }
    }

    public double getImpactDurabilityDamage() {
        return mcMMO.p.getAdvancedConfig().getImpactDurabilityDamageMultiplier() * (double)RankUtils.getRank(this.getPlayer(), SubSkillType.AXES_ARMOR_IMPACT);
    }

    public double greaterImpact(@NotNull LivingEntity target) {
        Player defender;
        if (!ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.AXES_GREATER_IMPACT, this.mmoPlayer, this.mmoPlayer.getAttackStrength())) {
            return 0.0;
        }
        Player player = this.getPlayer();
        ParticleEffectUtils.playGreaterImpactEffect(target);
        target.setVelocity(player.getLocation().getDirection().normalize().multiply(Axes.greaterImpactKnockbackMultiplier));
        if (this.mmoPlayer.useChatNotifications()) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Axes.Combat.GI.Proc");
        }
        if (target instanceof Player && NotificationManager.doesPlayerUseNotifications(defender = (Player)target)) {
            NotificationManager.sendPlayerInformation(defender, NotificationType.SUBSKILL_MESSAGE, "Axes.Combat.GI.Struck");
        }
        return Axes.greaterImpactBonusDamage;
    }

    public void skullSplitterCheck(@NotNull LivingEntity target, double damage) {
        CombatUtils.applyAbilityAoE(this.getPlayer(), target, damage / Axes.skullSplitterModifier * this.mmoPlayer.getAttackStrength(), this.skill);
    }
}

