/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.experience;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.ExperienceBarHideTask;
import com.gmail.nossr50.util.experience.ExperienceBarWrapper;
import com.gmail.nossr50.util.player.NotificationManager;
import java.util.HashMap;
import java.util.HashSet;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExperienceBarManager {
    private final McMMOPlayer mcMMOPlayer;
    int delaySeconds = 3;
    private HashMap<PrimarySkillType, ExperienceBarWrapper> experienceBars;
    private HashMap<PrimarySkillType, ExperienceBarHideTask> experienceBarHideTaskHashMap;
    private HashSet<PrimarySkillType> alwaysVisible;
    private HashSet<PrimarySkillType> disabledBars;

    public ExperienceBarManager(McMMOPlayer mcMMOPlayer) {
        this.mcMMOPlayer = mcMMOPlayer;
        this.init();
    }

    public void init() {
        this.experienceBars = new HashMap();
        this.experienceBarHideTaskHashMap = new HashMap();
        this.alwaysVisible = new HashSet();
        this.disabledBars = new HashSet();
    }

    public void updateExperienceBar(PrimarySkillType primarySkillType, Plugin plugin) {
        if (this.disabledBars.contains((Object)primarySkillType) || !ExperienceConfig.getInstance().isExperienceBarsEnabled() || !ExperienceConfig.getInstance().isExperienceBarEnabled(primarySkillType)) {
            return;
        }
        if (this.experienceBars.get((Object)primarySkillType) == null) {
            this.experienceBars.put(primarySkillType, new ExperienceBarWrapper(primarySkillType, this.mcMMOPlayer));
        }
        ExperienceBarWrapper experienceBarWrapper = this.experienceBars.get((Object)primarySkillType);
        experienceBarWrapper.setProgress(this.mcMMOPlayer.getProgressInCurrentSkillLevel(primarySkillType));
        experienceBarWrapper.showExperienceBar();
        if (this.experienceBarHideTaskHashMap.get((Object)primarySkillType) != null) {
            this.experienceBarHideTaskHashMap.get((Object)primarySkillType).cancel();
        }
        this.scheduleHideTask(primarySkillType, plugin);
    }

    private void scheduleHideTask(PrimarySkillType primarySkillType, Plugin plugin) {
        if (this.alwaysVisible.contains((Object)primarySkillType)) {
            return;
        }
        ExperienceBarHideTask experienceBarHideTask = new ExperienceBarHideTask(this, this.mcMMOPlayer, primarySkillType);
        mcMMO.p.getFoliaLib().getScheduler().runAtEntityLater((Entity)this.mcMMOPlayer.getPlayer(), experienceBarHideTask, (long)this.delaySeconds * 20L);
        this.experienceBarHideTaskHashMap.put(primarySkillType, experienceBarHideTask);
    }

    public void hideExperienceBar(PrimarySkillType primarySkillType) {
        if (this.experienceBars.containsKey((Object)primarySkillType)) {
            this.experienceBars.get((Object)primarySkillType).hideExperienceBar();
        }
    }

    public void clearTask(PrimarySkillType primarySkillType) {
        this.experienceBarHideTaskHashMap.remove((Object)primarySkillType);
    }

    public void disableAllBars() {
        for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
            this.xpBarSettingToggle(XPBarSettingTarget.HIDE, primarySkillType);
        }
        NotificationManager.sendPlayerInformationChatOnlyPrefixed(this.mcMMOPlayer.getPlayer(), "Commands.XPBar.DisableAll", new String[0]);
    }

    public void xpBarSettingToggle(@NotNull XPBarSettingTarget settingTarget, @Nullable PrimarySkillType skillType) {
        switch (settingTarget) {
            case SHOW: {
                this.disabledBars.remove((Object)skillType);
                this.alwaysVisible.add(skillType);
                if (this.experienceBarHideTaskHashMap.containsKey((Object)skillType)) {
                    this.experienceBarHideTaskHashMap.get((Object)skillType).cancel();
                }
                this.updateExperienceBar(skillType, (Plugin)mcMMO.p);
                break;
            }
            case HIDE: {
                this.alwaysVisible.remove((Object)skillType);
                this.disabledBars.add(skillType);
                if (this.experienceBarHideTaskHashMap.containsKey((Object)skillType)) {
                    this.experienceBarHideTaskHashMap.get((Object)skillType).cancel();
                }
                this.hideExperienceBar(skillType);
                break;
            }
            case RESET: {
                this.resetBarSettings();
            }
        }
        this.informPlayer(settingTarget, skillType);
    }

    private void resetBarSettings() {
        for (PrimarySkillType permanent : this.alwaysVisible) {
            this.hideExperienceBar(permanent);
        }
        this.alwaysVisible.clear();
        this.disabledBars.clear();
        this.disabledBars.add(PrimarySkillType.SALVAGE);
        this.disabledBars.add(PrimarySkillType.SMELTING);
    }

    private void informPlayer(@NotNull @NotNull @NotNull XPBarSettingTarget settingTarget, @Nullable PrimarySkillType primarySkillType) {
        if (settingTarget != XPBarSettingTarget.RESET) {
            NotificationManager.sendPlayerInformationChatOnlyPrefixed(this.mcMMOPlayer.getPlayer(), "Commands.XPBar.SettingChanged", mcMMO.p.getSkillTools().getLocalizedSkillName(primarySkillType), settingTarget.toString());
        } else {
            NotificationManager.sendPlayerInformationChatOnlyPrefixed(this.mcMMOPlayer.getPlayer(), "Commands.XPBar.Reset", new String[0]);
        }
    }

    public static enum XPBarSettingTarget {
        SHOW,
        HIDE,
        RESET,
        DISABLE;

    }
}

