/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.skills;

import com.gmail.nossr50.datatypes.meta.RecentlyReplantedCropMeta;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.CancellableRunnable;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Cocoa;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelayedCropReplant
extends CancellableRunnable {
    private final int desiredCropAge;
    private final Location cropLocation;
    private final Material cropMaterial;
    private boolean wasImmaturePlant;
    private final BlockBreakEvent blockBreakEvent;
    @Nullable
    private BlockFace cropFace;

    public DelayedCropReplant(BlockBreakEvent blockBreakEvent, BlockState cropState, int desiredCropAge, boolean wasImmaturePlant) {
        BlockData cropData = cropState.getBlockData();
        if (cropData instanceof Directional) {
            Directional cropDir = (Directional)cropData;
            this.cropFace = cropDir.getFacing();
        }
        this.blockBreakEvent = blockBreakEvent;
        this.wasImmaturePlant = wasImmaturePlant;
        this.cropMaterial = cropState.getType();
        this.desiredCropAge = desiredCropAge;
        this.cropLocation = cropState.getLocation();
    }

    @Override
    public void run() {
        Block cropBlock = this.cropLocation.getBlock();
        BlockState currentState = cropBlock.getState();
        PlantAnchorType plantAnchorType = PlantAnchorType.NORMAL;
        mcMMO.p.getFoliaLib().getScheduler().runAtLocationLater(this.blockBreakEvent.getBlock().getLocation(), new markPlantAsOld(this.blockBreakEvent.getBlock().getLocation()), 10L);
        if (this.blockBreakEvent.isCancelled()) {
            this.wasImmaturePlant = true;
        }
        if (currentState.getType().equals((Object)this.cropMaterial) || currentState.getType().equals((Object)Material.AIR) || currentState.getType().equals((Object)Material.CAVE_AIR)) {
            cropBlock.setType(this.cropMaterial);
            BlockState newState = cropBlock.getState();
            BlockData newData = newState.getBlockData();
            int age = 0;
            if (!this.wasImmaturePlant) {
                age = this.desiredCropAge;
            }
            if (newData instanceof Directional) {
                Directional directional = (Directional)newState.getBlockData();
                directional.setFacing(this.cropFace);
                newState.setBlockData((BlockData)directional);
                if (newData instanceof Cocoa) {
                    plantAnchorType = PlantAnchorType.COCOA;
                }
            }
            Ageable ageable = (Ageable)newState.getBlockData();
            ageable.setAge(age);
            newState.setBlockData((BlockData)ageable);
            newState.update(true, true);
            ParticleEffectUtils.playGreenThumbEffect(this.cropLocation);
            mcMMO.p.getFoliaLib().getScheduler().runAtLocationLater(newState.getLocation(), new PhysicsBlockUpdate(newState.getBlock(), this.cropFace, plantAnchorType), 1L);
        }
    }

    private static enum PlantAnchorType {
        NORMAL,
        COCOA;

    }

    private static class markPlantAsOld
    extends CancellableRunnable {
        private final Location cropLoc;

        public markPlantAsOld(Location cropLoc) {
            this.cropLoc = cropLoc;
        }

        @Override
        public void run() {
            Block cropBlock = this.cropLoc.getBlock();
            if (cropBlock.getMetadata("mcMMO: Recently Replanted").size() > 0) {
                cropBlock.setMetadata("mcMMO: Recently Replanted", (MetadataValue)new RecentlyReplantedCropMeta((Plugin)mcMMO.p, false));
            }
        }
    }

    private static class PhysicsBlockUpdate
    extends CancellableRunnable {
        private final Block plantBlock;
        private final PlantAnchorType plantAnchorType;
        private BlockFace plantFace;

        private PhysicsBlockUpdate(@NotNull Block plantBlock, @Nullable BlockFace plantFace, @NotNull PlantAnchorType plantAnchorType) {
            this.plantBlock = plantBlock;
            this.plantAnchorType = plantAnchorType;
            if (plantFace != null) {
                this.plantFace = plantFace;
            }
        }

        @Override
        public void run() {
            switch (this.plantAnchorType) {
                case COCOA: {
                    this.checkPlantIntegrity(this.plantFace);
                    break;
                }
                case NORMAL: {
                    this.checkPlantIntegrity(BlockFace.DOWN);
                }
            }
        }

        private void checkPlantIntegrity(@NotNull BlockFace blockFace) {
            Block neighbor = this.plantBlock.getRelative(blockFace);
            if (this.plantAnchorType == PlantAnchorType.COCOA) {
                if (!neighbor.getType().toString().toLowerCase().contains("jungle")) {
                    this.plantBlock.breakNaturally();
                }
            } else {
                switch (neighbor.getType()) {
                    case AIR: 
                    case CAVE_AIR: 
                    case WATER: 
                    case LAVA: {
                        this.plantBlock.breakNaturally();
                        break;
                    }
                }
            }
        }
    }
}

