/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.acrobatics;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.BlockLocationHistory;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.MobDodgeMetaCleanup;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.acrobatics.Acrobatics;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class AcrobaticsManager
extends SkillManager {
    private long rollXPCooldown = 0L;
    private final long rollXPInterval = 3000L;
    private long rollXPIntervalLengthen = 10000L;
    private final BlockLocationHistory fallLocationMap = new BlockLocationHistory(50);

    public AcrobaticsManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.ACROBATICS);
    }

    public boolean hasFallenInLocationBefore(Location location) {
        return this.fallLocationMap.contains(location);
    }

    public void addLocationToFallMap(Location location) {
        this.fallLocationMap.add(location);
    }

    public boolean canGainRollXP() {
        if (!ExperienceConfig.getInstance().isAcrobaticsExploitingPrevented()) {
            return true;
        }
        if (System.currentTimeMillis() >= this.rollXPCooldown) {
            this.rollXPCooldown = System.currentTimeMillis() + 3000L;
            this.rollXPIntervalLengthen = 10000L;
            return true;
        }
        this.rollXPCooldown += this.rollXPIntervalLengthen;
        this.rollXPIntervalLengthen += 1000L;
        return false;
    }

    public boolean canDodge(Entity damager) {
        if (this.getPlayer().isBlocking()) {
            return false;
        }
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.ACROBATICS_DODGE)) {
            return false;
        }
        if (Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.ACROBATICS_DODGE)) {
            if (damager instanceof LightningStrike && Acrobatics.dodgeLightningDisabled) {
                return false;
            }
            return mcMMO.p.getSkillTools().canCombatSkillsTrigger(this.skill, damager);
        }
        return false;
    }

    public double dodgeCheck(Entity attacker, double damage) {
        double modifiedDamage = Acrobatics.calculateModifiedDodgeDamage(damage, Acrobatics.dodgeDamageModifier);
        Player player = this.getPlayer();
        if (!this.isFatal(modifiedDamage) && ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.ACROBATICS_DODGE, UserManager.getPlayer(player))) {
            ParticleEffectUtils.playDodgeEffect(player);
            if (this.mmoPlayer.useChatNotifications()) {
                NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Acrobatics.Combat.Proc");
            }
            if (SkillUtils.cooldownExpired(this.mmoPlayer.getRespawnATS(), 5) && attacker instanceof Mob) {
                Mob mob = (Mob)attacker;
                if (mob.hasMetadata("mcMMO: Dodge Tracker") && ExperienceConfig.getInstance().isAcrobaticsExploitingPrevented()) {
                    MetadataValue metadataValue = (MetadataValue)mob.getMetadata("mcMMO: Dodge Tracker").get(0);
                    int count = metadataValue.asInt();
                    if (count <= 5) {
                        this.applyXpGain((float)(damage * (double)Acrobatics.dodgeXpModifier), XPGainReason.PVE);
                        mob.setMetadata("mcMMO: Dodge Tracker", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)(count + 1)));
                        MobDodgeMetaCleanup metaCleanupTask = new MobDodgeMetaCleanup(mob, mcMMO.p);
                        mcMMO.p.getFoliaLib().getScheduler().runAtEntityTimer((Entity)mob, (Consumer)metaCleanupTask, 20L, 1200L);
                    }
                } else {
                    this.applyXpGain((float)(damage * (double)Acrobatics.dodgeXpModifier), XPGainReason.PVE);
                }
            }
            return modifiedDamage;
        }
        return damage;
    }

    private boolean isFatal(double damage) {
        return this.getPlayer().getHealth() - damage <= 0.0;
    }
}

