/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.skills;

import com.gmail.nossr50.api.exceptions.InvalidSkillException;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.text.StringUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class SkillTools {
    private final mcMMO pluginRef;
    @NotNull
    public final ImmutableList<String> LOCALIZED_SKILL_NAMES;
    @NotNull
    public final ImmutableList<String> FORMATTED_SUBSKILL_NAMES;
    @NotNull
    public final ImmutableSet<String> EXACT_SUBSKILL_NAMES;
    @NotNull
    public final ImmutableList<PrimarySkillType> CHILD_SKILLS;
    @NotNull
    public static final ImmutableList<PrimarySkillType> NON_CHILD_SKILLS;
    @NotNull
    public static final ImmutableList<PrimarySkillType> SALVAGE_PARENTS;
    @NotNull
    public static final ImmutableList<PrimarySkillType> SMELTING_PARENTS;
    @NotNull
    public final ImmutableList<PrimarySkillType> COMBAT_SKILLS;
    @NotNull
    public final ImmutableList<PrimarySkillType> GATHERING_SKILLS;
    @NotNull
    public final ImmutableList<PrimarySkillType> MISC_SKILLS;
    @NotNull
    private final ImmutableMap<SubSkillType, PrimarySkillType> subSkillParentRelationshipMap;
    @NotNull
    private final ImmutableMap<SuperAbilityType, PrimarySkillType> superAbilityParentRelationshipMap;
    @NotNull
    private final ImmutableMap<PrimarySkillType, Set<SubSkillType>> primarySkillChildrenMap;
    private final ImmutableMap<PrimarySkillType, SuperAbilityType> mainActivatedAbilityChildMap;
    private final ImmutableMap<PrimarySkillType, ToolType> primarySkillToolMap;

    public SkillTools(@NotNull mcMMO pluginRef) throws InvalidSkillException {
        this.pluginRef = pluginRef;
        EnumMap<SubSkillType, PrimarySkillType> tempSubParentMap = new EnumMap<SubSkillType, PrimarySkillType>(SubSkillType.class);
        for (PrimarySkillType primarySkillType1 : PrimarySkillType.values()) {
            SubSkillType[] subSkillTypeArray = SubSkillType.values();
            int n = subSkillTypeArray.length;
            for (int i = 0; i < n; ++i) {
                SubSkillType subSkillType = subSkillTypeArray[i];
                String[] splitSubSkillName = subSkillType.toString().split("_");
                if (!primarySkillType1.toString().equalsIgnoreCase(splitSubSkillName[0])) continue;
                tempSubParentMap.put(subSkillType, primarySkillType1);
            }
        }
        this.subSkillParentRelationshipMap = ImmutableMap.copyOf(tempSubParentMap);
        EnumMap tempPrimaryChildMap = new EnumMap(PrimarySkillType.class);
        for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
            tempPrimaryChildMap.put(primarySkillType, new HashSet());
        }
        for (Enum enum_ : SubSkillType.values()) {
            PrimarySkillType parentSkill = (PrimarySkillType)((Object)this.subSkillParentRelationshipMap.get((Object)enum_));
            ((Set)tempPrimaryChildMap.get((Object)parentSkill)).add(enum_);
        }
        this.primarySkillChildrenMap = ImmutableMap.copyOf(tempPrimaryChildMap);
        EnumMap<PrimarySkillType, ToolType> tempToolMap = new EnumMap<PrimarySkillType, ToolType>(PrimarySkillType.class);
        tempToolMap.put(PrimarySkillType.AXES, ToolType.AXE);
        tempToolMap.put(PrimarySkillType.WOODCUTTING, ToolType.AXE);
        tempToolMap.put(PrimarySkillType.UNARMED, ToolType.FISTS);
        tempToolMap.put(PrimarySkillType.SWORDS, ToolType.SWORD);
        tempToolMap.put(PrimarySkillType.EXCAVATION, ToolType.SHOVEL);
        tempToolMap.put(PrimarySkillType.HERBALISM, ToolType.HOE);
        tempToolMap.put(PrimarySkillType.MINING, ToolType.PICKAXE);
        this.primarySkillToolMap = ImmutableMap.copyOf(tempToolMap);
        EnumMap<SuperAbilityType, PrimarySkillType> tempAbilityParentRelationshipMap = new EnumMap<SuperAbilityType, PrimarySkillType>(SuperAbilityType.class);
        EnumMap<PrimarySkillType, SuperAbilityType> tempMainActivatedAbilityChildMap = new EnumMap<PrimarySkillType, SuperAbilityType>(PrimarySkillType.class);
        for (SuperAbilityType superAbilityType : SuperAbilityType.values()) {
            try {
                PrimarySkillType parent = this.getSuperAbilityParent(superAbilityType);
                tempAbilityParentRelationshipMap.put(superAbilityType, parent);
                if (superAbilityType == SuperAbilityType.BLAST_MINING) continue;
                tempMainActivatedAbilityChildMap.put(parent, superAbilityType);
            }
            catch (InvalidSkillException e) {
                e.printStackTrace();
            }
        }
        this.superAbilityParentRelationshipMap = ImmutableMap.copyOf(tempAbilityParentRelationshipMap);
        this.mainActivatedAbilityChildMap = ImmutableMap.copyOf(tempMainActivatedAbilityChildMap);
        ArrayList<PrimarySkillType> arrayList = new ArrayList<PrimarySkillType>();
        for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
            if (!SkillTools.isChildSkill(primarySkillType)) continue;
            arrayList.add(primarySkillType);
        }
        this.CHILD_SKILLS = ImmutableList.copyOf(arrayList);
        this.COMBAT_SKILLS = mcMMO.getCompatibilityManager().getMinecraftGameVersion().isAtLeast(1, 21, 0) ? ImmutableList.of((Object)((Object)PrimarySkillType.ARCHERY), (Object)((Object)PrimarySkillType.AXES), (Object)((Object)PrimarySkillType.CROSSBOWS), (Object)((Object)PrimarySkillType.MACES), (Object)((Object)PrimarySkillType.SWORDS), (Object)((Object)PrimarySkillType.TAMING), (Object)((Object)PrimarySkillType.TRIDENTS), (Object)((Object)PrimarySkillType.UNARMED)) : ImmutableList.of((Object)((Object)PrimarySkillType.ARCHERY), (Object)((Object)PrimarySkillType.AXES), (Object)((Object)PrimarySkillType.CROSSBOWS), (Object)((Object)PrimarySkillType.SWORDS), (Object)((Object)PrimarySkillType.TAMING), (Object)((Object)PrimarySkillType.TRIDENTS), (Object)((Object)PrimarySkillType.UNARMED));
        this.GATHERING_SKILLS = ImmutableList.of((Object)((Object)PrimarySkillType.EXCAVATION), (Object)((Object)PrimarySkillType.FISHING), (Object)((Object)PrimarySkillType.HERBALISM), (Object)((Object)PrimarySkillType.MINING), (Object)((Object)PrimarySkillType.WOODCUTTING));
        this.MISC_SKILLS = ImmutableList.of((Object)((Object)PrimarySkillType.ACROBATICS), (Object)((Object)PrimarySkillType.ALCHEMY), (Object)((Object)PrimarySkillType.REPAIR), (Object)((Object)PrimarySkillType.SALVAGE), (Object)((Object)PrimarySkillType.SMELTING));
        this.LOCALIZED_SKILL_NAMES = ImmutableList.copyOf(this.buildLocalizedPrimarySkillNames());
        this.FORMATTED_SUBSKILL_NAMES = ImmutableList.copyOf(this.buildFormattedSubSkillNameList());
        this.EXACT_SUBSKILL_NAMES = ImmutableSet.copyOf(this.buildExactSubSkillNameList());
    }

    @NotNull
    private PrimarySkillType getSuperAbilityParent(SuperAbilityType superAbilityType) throws InvalidSkillException {
        return switch (superAbilityType) {
            default -> throw new IncompatibleClassChangeError();
            case SuperAbilityType.BERSERK -> PrimarySkillType.UNARMED;
            case SuperAbilityType.GREEN_TERRA -> PrimarySkillType.HERBALISM;
            case SuperAbilityType.TREE_FELLER -> PrimarySkillType.WOODCUTTING;
            case SuperAbilityType.SUPER_BREAKER, SuperAbilityType.BLAST_MINING -> PrimarySkillType.MINING;
            case SuperAbilityType.SKULL_SPLITTER -> PrimarySkillType.AXES;
            case SuperAbilityType.SERRATED_STRIKES -> PrimarySkillType.SWORDS;
            case SuperAbilityType.GIGA_DRILL_BREAKER -> PrimarySkillType.EXCAVATION;
            case SuperAbilityType.SUPER_SHOTGUN -> PrimarySkillType.CROSSBOWS;
            case SuperAbilityType.TRIDENTS_SUPER_ABILITY -> PrimarySkillType.TRIDENTS;
            case SuperAbilityType.EXPLOSIVE_SHOT -> PrimarySkillType.ARCHERY;
            case SuperAbilityType.MACES_SUPER_ABILITY -> PrimarySkillType.MACES;
        };
    }

    @NotNull
    private ArrayList<String> buildFormattedSubSkillNameList() {
        ArrayList<String> subSkillNameList = new ArrayList<String>();
        for (SubSkillType subSkillType : SubSkillType.values()) {
            subSkillNameList.add(subSkillType.getNiceNameNoSpaces(subSkillType));
        }
        return subSkillNameList;
    }

    @NotNull
    private HashSet<String> buildExactSubSkillNameList() {
        HashSet<String> subSkillNameExactSet = new HashSet<String>();
        for (SubSkillType subSkillType : SubSkillType.values()) {
            subSkillNameExactSet.add(subSkillType.toString());
        }
        return subSkillNameExactSet;
    }

    @VisibleForTesting
    @NotNull
    private ArrayList<String> buildLocalizedPrimarySkillNames() {
        ArrayList<String> localizedSkillNameList = new ArrayList<String>();
        for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
            localizedSkillNameList.add(this.getLocalizedSkillName(primarySkillType));
        }
        Collections.sort(localizedSkillNameList);
        return localizedSkillNameList;
    }

    public PrimarySkillType matchSkill(String skillName) {
        if (!this.pluginRef.getGeneralConfig().getLocale().equalsIgnoreCase("en_US")) {
            for (PrimarySkillType type : PrimarySkillType.values()) {
                if (!skillName.equalsIgnoreCase(LocaleLoader.getString(StringUtils.getCapitalized(type.name()) + ".SkillName"))) continue;
                return type;
            }
        }
        for (PrimarySkillType type : PrimarySkillType.values()) {
            if (!type.name().equalsIgnoreCase(skillName)) continue;
            return type;
        }
        if (!skillName.equalsIgnoreCase("all")) {
            this.pluginRef.getLogger().warning("Invalid mcMMO skill (" + skillName + ")");
        }
        return null;
    }

    public PrimarySkillType getPrimarySkillBySubSkill(SubSkillType subSkillType) {
        return (PrimarySkillType)((Object)this.subSkillParentRelationshipMap.get((Object)subSkillType));
    }

    public PrimarySkillType getPrimarySkillBySuperAbility(SuperAbilityType superAbilityType) {
        return (PrimarySkillType)((Object)this.superAbilityParentRelationshipMap.get((Object)superAbilityType));
    }

    public SuperAbilityType getSuperAbility(PrimarySkillType primarySkillType) {
        if (this.mainActivatedAbilityChildMap.get((Object)primarySkillType) == null) {
            return null;
        }
        return (SuperAbilityType)((Object)this.mainActivatedAbilityChildMap.get((Object)primarySkillType));
    }

    public boolean isSuperAbilityUnlocked(PrimarySkillType primarySkillType, Player player) {
        SuperAbilityType superAbilityType = mcMMO.p.getSkillTools().getSuperAbility(primarySkillType);
        SubSkillType subSkillType = superAbilityType.getSubSkillTypeDefinition();
        return RankUtils.hasUnlockedSubskill(player, subSkillType);
    }

    public boolean getPVPEnabled(PrimarySkillType primarySkillType) {
        return this.pluginRef.getGeneralConfig().getPVPEnabled(primarySkillType);
    }

    public boolean getPVEEnabled(PrimarySkillType primarySkillType) {
        return this.pluginRef.getGeneralConfig().getPVEEnabled(primarySkillType);
    }

    public boolean getHardcoreStatLossEnabled(PrimarySkillType primarySkillType) {
        return this.pluginRef.getGeneralConfig().getHardcoreStatLossEnabled(primarySkillType);
    }

    public boolean getHardcoreVampirismEnabled(PrimarySkillType primarySkillType) {
        return this.pluginRef.getGeneralConfig().getHardcoreVampirismEnabled(primarySkillType);
    }

    public ToolType getPrimarySkillToolType(PrimarySkillType primarySkillType) {
        return (ToolType)((Object)this.primarySkillToolMap.get((Object)primarySkillType));
    }

    public Set<SubSkillType> getSubSkills(PrimarySkillType primarySkillType) {
        return (Set)this.primarySkillChildrenMap.get((Object)primarySkillType);
    }

    public double getXpMultiplier(PrimarySkillType primarySkillType) {
        return ExperienceConfig.getInstance().getFormulaSkillModifier(primarySkillType);
    }

    public static boolean isChildSkill(PrimarySkillType primarySkillType) {
        return switch (primarySkillType) {
            case PrimarySkillType.SALVAGE, PrimarySkillType.SMELTING -> true;
            default -> false;
        };
    }

    public String getLocalizedSkillName(PrimarySkillType primarySkillType) {
        return LocaleLoader.getString(StringUtils.getCapitalized(primarySkillType.toString()) + ".SkillName");
    }

    public boolean doesPlayerHaveSkillPermission(Player player, PrimarySkillType primarySkillType) {
        return Permissions.skillEnabled((Permissible)player, primarySkillType);
    }

    public boolean canCombatSkillsTrigger(PrimarySkillType primarySkillType, Entity target) {
        return target instanceof Player || target instanceof Tameable && ((Tameable)target).isTamed() ? this.getPVPEnabled(primarySkillType) : this.getPVEEnabled(primarySkillType);
    }

    public String getCapitalizedPrimarySkillName(PrimarySkillType primarySkillType) {
        return StringUtils.getCapitalized(primarySkillType.toString());
    }

    public int getSuperAbilityCooldown(SuperAbilityType superAbilityType) {
        return this.pluginRef.getGeneralConfig().getCooldown(superAbilityType);
    }

    public int getSuperAbilityMaxLength(SuperAbilityType superAbilityType) {
        return this.pluginRef.getGeneralConfig().getMaxLength(superAbilityType);
    }

    public int getLevelCap(@NotNull PrimarySkillType primarySkillType) {
        return mcMMO.p.getGeneralConfig().getLevelCap(primarySkillType);
    }

    public boolean superAbilityPermissionCheck(SuperAbilityType superAbilityType, Player player) {
        return superAbilityType.getPermissions(player);
    }

    @NotNull
    public List<PrimarySkillType> getChildSkills() {
        return this.CHILD_SKILLS;
    }

    @NotNull
    public ImmutableList<PrimarySkillType> getNonChildSkills() {
        return NON_CHILD_SKILLS;
    }

    @NotNull
    public ImmutableList<PrimarySkillType> getCombatSkills() {
        return this.COMBAT_SKILLS;
    }

    @NotNull
    public ImmutableList<PrimarySkillType> getGatheringSkills() {
        return this.GATHERING_SKILLS;
    }

    @NotNull
    public ImmutableList<PrimarySkillType> getMiscSkills() {
        return this.MISC_SKILLS;
    }

    @NotNull
    public ImmutableList<PrimarySkillType> getChildSkillParents(PrimarySkillType childSkill) throws IllegalArgumentException {
        switch (childSkill) {
            case SALVAGE: {
                return SALVAGE_PARENTS;
            }
            case SMELTING: {
                return SMELTING_PARENTS;
            }
        }
        throw new IllegalArgumentException("Skill " + String.valueOf((Object)childSkill) + " is not a child skill");
    }

    static {
        ArrayList<PrimarySkillType> tempNonChildSkills = new ArrayList<PrimarySkillType>();
        for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
            if (primarySkillType == PrimarySkillType.SALVAGE || primarySkillType == PrimarySkillType.SMELTING) continue;
            tempNonChildSkills.add(primarySkillType);
        }
        NON_CHILD_SKILLS = ImmutableList.copyOf(tempNonChildSkills);
        SALVAGE_PARENTS = ImmutableList.of((Object)((Object)PrimarySkillType.REPAIR), (Object)((Object)PrimarySkillType.FISHING));
        SMELTING_PARENTS = ImmutableList.of((Object)((Object)PrimarySkillType.MINING), (Object)((Object)PrimarySkillType.REPAIR));
    }
}

