/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.party;

import com.gmail.nossr50.datatypes.chat.ChatChannel;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.party.ItemShareType;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyLeader;
import com.gmail.nossr50.datatypes.party.ShareMode;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.events.party.McMMOPartyAllianceChangeEvent;
import com.gmail.nossr50.events.party.McMMOPartyChangeEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PartyManager {
    @NotNull
    private final List<Party> parties;
    @NotNull
    private final File partyFile;
    @NotNull
    private final mcMMO pluginRef;

    public PartyManager(@NotNull mcMMO pluginRef) {
        this.pluginRef = pluginRef;
        String partiesFilePath = mcMMO.getFlatFileDirectory() + "parties.yml";
        this.partyFile = new File(partiesFilePath);
        this.parties = new ArrayList<Party>();
    }

    public boolean isPartyFull(@NotNull Player player, @NotNull Party targetParty) {
        Objects.requireNonNull(player, "player cannot be null!");
        Objects.requireNonNull(targetParty, "targetParty cannot be null!");
        return !Permissions.partySizeBypass((Permissible)player) && this.pluginRef.getGeneralConfig().getPartyMaxSize() >= 1 && targetParty.getOnlineMembers().size() >= this.pluginRef.getGeneralConfig().getPartyMaxSize();
    }

    public boolean areAllies(@NotNull Player firstPlayer, @NotNull Player secondPlayer) {
        Objects.requireNonNull(firstPlayer, "firstPlayer cannot be null!");
        Objects.requireNonNull(secondPlayer, "secondPlayer cannot be null!");
        if (UserManager.getPlayer(firstPlayer) == null) {
            return false;
        }
        if (UserManager.getPlayer(secondPlayer) == null) {
            return false;
        }
        Party firstParty = UserManager.getPlayer(firstPlayer).getParty();
        Party secondParty = UserManager.getPlayer(secondPlayer).getParty();
        if (firstParty == null || secondParty == null || firstParty.getAlly() == null || secondParty.getAlly() == null) {
            return false;
        }
        return firstParty.equals(secondParty.getAlly()) && secondParty.equals(firstParty.getAlly());
    }

    @NotNull
    public List<Player> getNearMembers(@NotNull McMMOPlayer mmoPlayer) {
        Objects.requireNonNull(mmoPlayer, "mmoPlayer cannot be null!");
        ArrayList<Player> nearMembers = new ArrayList<Player>();
        Party party = mmoPlayer.getParty();
        if (party != null) {
            Player player = mmoPlayer.getPlayer();
            double range = this.pluginRef.getGeneralConfig().getPartyShareRange();
            for (Player member : party.getOnlineMembers()) {
                if (player.equals(member) || !member.isValid() || !Misc.isNear(player.getLocation(), member.getLocation(), range)) continue;
                nearMembers.add(member);
            }
        }
        return nearMembers;
    }

    @NotNull
    public List<Player> getNearVisibleMembers(@NotNull McMMOPlayer mmoPlayer) {
        Objects.requireNonNull(mmoPlayer, "mmoPlayer cannot be null!");
        ArrayList<Player> nearMembers = new ArrayList<Player>();
        Party party = mmoPlayer.getParty();
        if (party != null) {
            Player player = mmoPlayer.getPlayer();
            double range = this.pluginRef.getGeneralConfig().getPartyShareRange();
            for (Player member : party.getVisibleMembers(player)) {
                if (player.equals(member) || !member.isValid() || !Misc.isNear(player.getLocation(), member.getLocation(), range)) continue;
                nearMembers.add(member);
            }
        }
        return nearMembers;
    }

    @NotNull
    public LinkedHashMap<UUID, String> getAllMembers(@NotNull Player player) {
        Objects.requireNonNull(player, "player cannot be null!");
        Party party = this.getParty(player);
        return party == null ? new LinkedHashMap<UUID, String>() : party.getMembers();
    }

    @NotNull
    public List<Player> getOnlineMembers(@NotNull String partyName) {
        Objects.requireNonNull(partyName, "partyName cannot be null!");
        return this.getOnlineMembers(this.getParty(partyName));
    }

    @NotNull
    public List<Player> getOnlineMembers(@NotNull Player player) {
        Objects.requireNonNull(player, "player cannot be null!");
        return this.getOnlineMembers(this.getParty(player));
    }

    private List<Player> getOnlineMembers(@Nullable Party party) {
        return party == null ? new ArrayList() : party.getOnlineMembers();
    }

    @Nullable
    public Party getParty(@NotNull String partyName) {
        Objects.requireNonNull(partyName, "partyName cannot be null!");
        for (Party party : this.parties) {
            if (!party.getName().equalsIgnoreCase(partyName)) continue;
            return party;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public Party getPlayerParty(@NotNull String playerName) {
        Objects.requireNonNull(playerName, "playerName cannot be null!");
        for (Party party : this.parties) {
            if (!party.getMembers().containsValue(playerName)) continue;
            return party;
        }
        return null;
    }

    @Nullable
    public Party getPlayerParty(@NotNull String playerName, @NotNull UUID uuid) {
        Objects.requireNonNull(playerName, "playerName cannot be null!");
        Objects.requireNonNull(uuid, "uuid cannot be null!");
        for (Party party : this.parties) {
            LinkedHashMap<UUID, String> members = party.getMembers();
            if (!members.containsKey(uuid) && !members.containsValue(playerName)) continue;
            if (members.get(uuid) == null || !members.get(uuid).equals(playerName)) {
                members.put(uuid, playerName);
            }
            return party;
        }
        return null;
    }

    @Nullable
    public Party getParty(@NotNull Player player) {
        Objects.requireNonNull(player, "player cannot be null!");
        if (UserManager.getPlayer(player) == null) {
            return null;
        }
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        if (mmoPlayer == null) {
            return null;
        }
        return mmoPlayer.getParty();
    }

    @NotNull
    public List<Party> getParties() {
        return this.parties;
    }

    public void removeFromParty(@NotNull OfflinePlayer player, @NotNull Party party) {
        Objects.requireNonNull(player, "player cannot be null!");
        Objects.requireNonNull(party, "party cannot be null!");
        LinkedHashMap<UUID, String> members = party.getMembers();
        String playerName = player.getName();
        members.remove(player.getUniqueId());
        if (player.isOnline()) {
            party.getOnlineMembers().remove(player.getPlayer());
        }
        if (members.isEmpty()) {
            this.parties.remove(party);
        } else {
            if (party.getLeader().getUniqueId().equals(player.getUniqueId())) {
                this.setPartyLeader(members.keySet().iterator().next(), party);
            }
            this.informPartyMembersQuit(party, playerName);
        }
    }

    public void removeFromParty(@NotNull McMMOPlayer mcMMOPlayer) {
        Objects.requireNonNull(mcMMOPlayer, "mcMMOPlayer cannot be null!");
        if (mcMMOPlayer.getParty() == null) {
            return;
        }
        this.removeFromParty((OfflinePlayer)mcMMOPlayer.getPlayer(), mcMMOPlayer.getParty());
        this.processPartyLeaving(mcMMOPlayer);
    }

    @Deprecated
    public void disbandParty(@NotNull Party party) {
        Objects.requireNonNull(party, "party cannot be null!");
        this.disbandParty(null, party);
    }

    public void disbandParty(@Nullable McMMOPlayer mcMMOPlayer, @NotNull Party party) {
        Objects.requireNonNull(party, "party cannot be null!");
        for (Player member : party.getOnlineMembers()) {
            if (UserManager.getPlayer(member) == null) continue;
            this.processPartyLeaving(UserManager.getPlayer(member));
        }
        if (party.getAlly() != null) {
            party.getAlly().setAlly(null);
        }
        this.parties.remove(party);
        if (mcMMOPlayer != null) {
            this.handlePartyChangeEvent(mcMMOPlayer.getPlayer(), party.getName(), null, McMMOPartyChangeEvent.EventReason.DISBANDED_PARTY);
        }
    }

    public void createParty(@NotNull McMMOPlayer mcMMOPlayer, @NotNull String partyName, @Nullable String password) {
        Player player = mcMMOPlayer.getPlayer();
        Party party = new Party(new PartyLeader(player.getUniqueId(), player.getName()), partyName.replace(".", ""), password);
        if (password != null) {
            player.sendMessage(LocaleLoader.getString("Party.Password.Set", password));
        }
        this.parties.add(party);
        player.sendMessage(LocaleLoader.getString("Commands.Party.Create", party.getName()));
        this.addToParty(mcMMOPlayer, party);
        this.handlePartyChangeEvent(player, null, partyName, McMMOPartyChangeEvent.EventReason.CREATED_PARTY);
    }

    public boolean checkPartyPassword(@NotNull Player player, @NotNull Party party, @Nullable String password) {
        if (party.isLocked()) {
            String partyPassword = party.getPassword();
            if (partyPassword == null) {
                player.sendMessage(LocaleLoader.getString("Party.Locked"));
                return false;
            }
            if (password == null) {
                player.sendMessage(LocaleLoader.getString("Party.Password.None"));
                return false;
            }
            if (!password.equals(partyPassword)) {
                player.sendMessage(LocaleLoader.getString("Party.Password.Incorrect"));
                return false;
            }
        }
        return true;
    }

    public void joinInvitedParty(@NotNull McMMOPlayer mcMMOPlayer) {
        Objects.requireNonNull(mcMMOPlayer, "mcMMOPlayer cannot be null!");
        Party invite = mcMMOPlayer.getPartyInvite();
        if (!this.parties.contains(invite)) {
            NotificationManager.sendPlayerInformation(mcMMOPlayer.getPlayer(), NotificationType.PARTY_MESSAGE, "Party.Disband");
            return;
        }
        if (this.pluginRef.getGeneralConfig().getPartyMaxSize() > 0 && invite.getMembers().size() >= this.pluginRef.getGeneralConfig().getPartyMaxSize()) {
            NotificationManager.sendPlayerInformation(mcMMOPlayer.getPlayer(), NotificationType.PARTY_MESSAGE, "Commands.Party.PartyFull.InviteAccept", invite.getName(), String.valueOf(this.pluginRef.getGeneralConfig().getPartyMaxSize()));
            return;
        }
        NotificationManager.sendPlayerInformation(mcMMOPlayer.getPlayer(), NotificationType.PARTY_MESSAGE, "Commands.Party.Invite.Accepted", invite.getName());
        mcMMOPlayer.removePartyInvite();
        this.addToParty(mcMMOPlayer, invite);
    }

    public void acceptAllianceInvite(@NotNull McMMOPlayer mcMMOPlayer) {
        Objects.requireNonNull(mcMMOPlayer, "mcMMOPlayer cannot be null!");
        Party invite = mcMMOPlayer.getPartyAllianceInvite();
        Player player = mcMMOPlayer.getPlayer();
        if (!this.parties.contains(invite)) {
            player.sendMessage(LocaleLoader.getString("Party.Disband"));
            return;
        }
        if (!this.handlePartyChangeAllianceEvent(player, mcMMOPlayer.getParty().getName(), invite.getName(), McMMOPartyAllianceChangeEvent.EventReason.FORMED_ALLIANCE)) {
            return;
        }
        player.sendMessage(LocaleLoader.getString("Commands.Party.Alliance.Invite.Accepted", invite.getName()));
        mcMMOPlayer.removePartyAllianceInvite();
        this.createAlliance(mcMMOPlayer.getParty(), invite);
    }

    public void createAlliance(@NotNull Party firstParty, @NotNull Party secondParty) {
        Objects.requireNonNull(firstParty, "firstParty cannot be null!");
        Objects.requireNonNull(secondParty, "secondParty cannot be null!");
        firstParty.setAlly(secondParty);
        secondParty.setAlly(firstParty);
        for (Player member : firstParty.getOnlineMembers()) {
            member.sendMessage(LocaleLoader.getString("Party.Alliance.Formed", secondParty.getName()));
        }
        for (Player member : secondParty.getOnlineMembers()) {
            member.sendMessage(LocaleLoader.getString("Party.Alliance.Formed", firstParty.getName()));
        }
    }

    public boolean disbandAlliance(@NotNull Player player, @NotNull Party firstParty, @NotNull Party secondParty) {
        Objects.requireNonNull(player, "player cannot be null!");
        Objects.requireNonNull(firstParty, "firstParty cannot be null!");
        Objects.requireNonNull(secondParty, "secondParty cannot be null!");
        if (!this.handlePartyChangeAllianceEvent(player, firstParty.getName(), secondParty.getName(), McMMOPartyAllianceChangeEvent.EventReason.DISBAND_ALLIANCE)) {
            return false;
        }
        this.disbandAlliance(firstParty, secondParty);
        return true;
    }

    private void disbandAlliance(@NotNull Party firstParty, @NotNull Party secondParty) {
        Objects.requireNonNull(firstParty, "firstParty cannot be null!");
        Objects.requireNonNull(secondParty, "secondParty cannot be null!");
        firstParty.setAlly(null);
        secondParty.setAlly(null);
        for (Player member : firstParty.getOnlineMembers()) {
            member.sendMessage(LocaleLoader.getString("Party.Alliance.Disband", secondParty.getName()));
        }
        for (Player member : secondParty.getOnlineMembers()) {
            member.sendMessage(LocaleLoader.getString("Party.Alliance.Disband", firstParty.getName()));
        }
    }

    public void addToParty(@NotNull McMMOPlayer mcMMOPlayer, @NotNull Party party) {
        Objects.requireNonNull(mcMMOPlayer, "mcMMOPlayer cannot be null!");
        Objects.requireNonNull(party, "party cannot be null!");
        Player player = mcMMOPlayer.getPlayer();
        String playerName = player.getName();
        this.informPartyMembersJoin(party, playerName);
        mcMMOPlayer.setParty(party);
        party.getMembers().put(player.getUniqueId(), player.getName());
        party.getOnlineMembers().add(player);
    }

    @Nullable
    public String getPartyLeaderName(@NotNull String partyName) {
        Objects.requireNonNull(partyName, "partyName cannot be null!");
        Party party = this.getParty(partyName);
        return party == null ? null : party.getLeader().getPlayerName();
    }

    public void setPartyLeader(@NotNull UUID uuid, @NotNull Party party) {
        Objects.requireNonNull(uuid, "uuid cannot be null!");
        Objects.requireNonNull(party, "party cannot be null!");
        OfflinePlayer player = this.pluginRef.getServer().getOfflinePlayer(uuid);
        UUID leaderUniqueId = party.getLeader().getUniqueId();
        for (Player member : party.getOnlineMembers()) {
            UUID memberUniqueId = member.getUniqueId();
            if (memberUniqueId.equals(player.getUniqueId())) {
                member.sendMessage(LocaleLoader.getString("Party.Owner.Player"));
                continue;
            }
            if (memberUniqueId.equals(leaderUniqueId)) {
                member.sendMessage(LocaleLoader.getString("Party.Owner.NotLeader"));
                continue;
            }
            member.sendMessage(LocaleLoader.getString("Party.Owner.New", player.getName()));
        }
        party.setLeader(new PartyLeader(player.getUniqueId(), player.getName()));
    }

    public boolean canInvite(@NotNull McMMOPlayer mcMMOPlayer) {
        Objects.requireNonNull(mcMMOPlayer, "mcMMOPlayer cannot be null!");
        Party party = mcMMOPlayer.getParty();
        return !party.isLocked() || party.getLeader().getUniqueId().equals(mcMMOPlayer.getPlayer().getUniqueId());
    }

    public boolean checkPartyExistence(@NotNull Player player, @NotNull String partyName) {
        Objects.requireNonNull(player, "player cannot be null!");
        Objects.requireNonNull(partyName, "partyName cannot be null!");
        if (this.getParty(partyName) == null) {
            return false;
        }
        player.sendMessage(LocaleLoader.getString("Commands.Party.AlreadyExists", partyName));
        return true;
    }

    public boolean changeOrJoinParty(@NotNull McMMOPlayer mmoPlayer, @NotNull String newPartyName) {
        Objects.requireNonNull(mmoPlayer, "mmoPlayer cannot be null!");
        Objects.requireNonNull(newPartyName, "newPartyName cannot be null!");
        Player player = mmoPlayer.getPlayer();
        if (mmoPlayer.inParty()) {
            Party oldParty = mmoPlayer.getParty();
            if (!this.handlePartyChangeEvent(player, oldParty.getName(), newPartyName, McMMOPartyChangeEvent.EventReason.CHANGED_PARTIES)) {
                return false;
            }
        } else {
            return this.handlePartyChangeEvent(player, null, newPartyName, McMMOPartyChangeEvent.EventReason.JOINED_PARTY);
        }
        this.removeFromParty(mmoPlayer);
        return true;
    }

    public boolean inSameParty(@NotNull Player firstPlayer, @NotNull Player secondPlayer) {
        Objects.requireNonNull(firstPlayer, "firstPlayer cannot be null!");
        Objects.requireNonNull(secondPlayer, "secondPlayer cannot be null!");
        if (UserManager.getPlayer(firstPlayer) == null) {
            return false;
        }
        if (UserManager.getPlayer(secondPlayer) == null) {
            return false;
        }
        Party firstParty = UserManager.getPlayer(firstPlayer).getParty();
        Party secondParty = UserManager.getPlayer(secondPlayer).getParty();
        if (firstParty == null || secondParty == null) {
            return false;
        }
        return firstParty.equals(secondParty);
    }

    public void loadParties() {
        if (!this.pluginRef.getPartyConfig().isPartyEnabled() || !this.partyFile.exists()) {
            return;
        }
        try {
            YamlConfiguration partiesFile = YamlConfiguration.loadConfiguration((File)this.partyFile);
            ArrayList<Party> hasAlly = new ArrayList<Party>();
            for (String partyName : partiesFile.getConfigurationSection("").getKeys(false)) {
                try {
                    Party party = new Party(partyName);
                    String[] leaderSplit = partiesFile.getString(partyName + ".Leader").split("[|]");
                    party.setLeader(new PartyLeader(UUID.fromString(leaderSplit[0]), leaderSplit[1]));
                    party.setPassword(partiesFile.getString(partyName + ".Password"));
                    party.setLocked(partiesFile.getBoolean(partyName + ".Locked"));
                    party.setLevel(partiesFile.getInt(partyName + ".Level"));
                    party.setXp(partiesFile.getInt(partyName + ".Xp"));
                    if (partiesFile.getString(partyName + ".Ally") != null) {
                        hasAlly.add(party);
                    }
                    party.setXpShareMode(ShareMode.getShareMode(partiesFile.getString(partyName + ".ExpShareMode", "NONE")));
                    party.setItemShareMode(ShareMode.getShareMode(partiesFile.getString(partyName + ".ItemShareMode", "NONE")));
                    for (ItemShareType itemShareType : ItemShareType.values()) {
                        party.setSharingDrops(itemShareType, partiesFile.getBoolean(partyName + ".ItemShareType." + itemShareType.toString(), true));
                    }
                    LinkedHashMap<UUID, String> members = party.getMembers();
                    for (String memberEntry : partiesFile.getStringList(partyName + ".Members")) {
                        String[] memberSplit = memberEntry.split("[|]");
                        members.put(UUID.fromString(memberSplit[0]), memberSplit[1]);
                    }
                    this.parties.add(party);
                }
                catch (Exception e) {
                    this.pluginRef.getLogger().log(Level.WARNING, "An exception occurred while loading a party with name '" + partyName + "'. Skipped loading party.", e);
                }
            }
            LogUtils.debug(this.pluginRef.getLogger(), "Loaded (" + this.parties.size() + ") Parties...");
            for (Party party : hasAlly) {
                party.setAlly(this.getParty(partiesFile.getString(party.getName() + ".Ally")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveParties() {
        LogUtils.debug(this.pluginRef.getLogger(), "[Party Data] Saving...");
        if (this.partyFile.exists() && !this.partyFile.delete()) {
            this.pluginRef.getLogger().warning("Could not delete party file. Party saving failed!");
            return;
        }
        YamlConfiguration partiesFile = new YamlConfiguration();
        for (Party party : this.parties) {
            String partyName = party.getName();
            PartyLeader leader = party.getLeader();
            partiesFile.set(partyName + ".Leader", (Object)(leader.getUniqueId().toString() + "|" + leader.getPlayerName()));
            partiesFile.set(partyName + ".Password", (Object)party.getPassword());
            partiesFile.set(partyName + ".Locked", (Object)party.isLocked());
            partiesFile.set(partyName + ".Level", (Object)party.getLevel());
            partiesFile.set(partyName + ".Xp", (Object)((int)party.getXp()));
            partiesFile.set(partyName + ".Ally", (Object)(party.getAlly() != null ? party.getAlly().getName() : ""));
            partiesFile.set(partyName + ".ExpShareMode", (Object)party.getXpShareMode().toString());
            partiesFile.set(partyName + ".ItemShareMode", (Object)party.getItemShareMode().toString());
            for (ItemShareType itemShareType : ItemShareType.values()) {
                partiesFile.set(partyName + ".ItemShareType." + itemShareType.toString(), (Object)party.sharingDrops(itemShareType));
            }
            ArrayList<CallSite> members = new ArrayList<CallSite>();
            for (Map.Entry<UUID, String> memberEntry : party.getMembers().entrySet()) {
                String memberUniqueId;
                String string = memberUniqueId = memberEntry.getKey() == null ? "" : memberEntry.getKey().toString();
                String memberName = memberEntry.getValue();
                if (members.contains(memberName)) continue;
                members.add((CallSite)((Object)(memberUniqueId + "|" + memberName)));
            }
            partiesFile.set(partyName + ".Members", members);
        }
        try {
            partiesFile.save(this.partyFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean handlePartyChangeEvent(Player player, String oldPartyName, String newPartyName, McMMOPartyChangeEvent.EventReason reason) {
        McMMOPartyChangeEvent event = new McMMOPartyChangeEvent(player, oldPartyName, newPartyName, reason);
        this.pluginRef.getServer().getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public boolean handlePartyChangeAllianceEvent(Player player, String oldAllyName, String newAllyName, McMMOPartyAllianceChangeEvent.EventReason reason) {
        McMMOPartyAllianceChangeEvent event = new McMMOPartyAllianceChangeEvent(player, oldAllyName, newAllyName, reason);
        this.pluginRef.getServer().getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public void processPartyLeaving(@NotNull McMMOPlayer mcMMOPlayer) {
        mcMMOPlayer.removeParty();
        mcMMOPlayer.setChatMode(ChatChannel.NONE);
        mcMMOPlayer.setItemShareModifier(10);
    }

    public void informPartyMembersLevelUp(Party party, int levelsGained, int level) {
        boolean levelUpSoundsEnabled = this.pluginRef.getGeneralConfig().getLevelUpSoundsEnabled();
        for (Player member : party.getOnlineMembers()) {
            member.sendMessage(LocaleLoader.getString("Party.LevelUp", levelsGained, level));
            if (!levelUpSoundsEnabled) continue;
            SoundManager.sendSound(member, member.getLocation(), SoundType.LEVEL_UP);
        }
    }

    private void informPartyMembersJoin(Party party, String playerName) {
        for (Player member : party.getOnlineMembers()) {
            member.sendMessage(LocaleLoader.getString("Party.InformedOnJoin", playerName));
        }
    }

    private void informPartyMembersQuit(Party party, String playerName) {
        for (Player member : party.getOnlineMembers()) {
            member.sendMessage(LocaleLoader.getString("Party.InformedOnQuit", playerName));
        }
    }
}

