/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.party;

import com.gmail.nossr50.chat.SamePartyPredicate;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.party.ItemShareType;
import com.gmail.nossr50.datatypes.party.PartyLeader;
import com.gmail.nossr50.datatypes.party.ShareMode;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Party {
    private static final DecimalFormat percent = new DecimalFormat("##0.00%", DecimalFormatSymbols.getInstance(Locale.US));
    @NotNull
    private final Predicate<CommandSender> samePartyPredicate;
    private final LinkedHashMap<UUID, String> members = new LinkedHashMap();
    private final List<Player> onlineMembers = new ArrayList<Player>();
    private PartyLeader leader;
    private String name;
    private String password;
    private boolean locked;
    private Party ally;
    private int level;
    private float xp;
    private ShareMode xpShareMode = ShareMode.NONE;
    private ShareMode itemShareMode = ShareMode.NONE;
    private boolean shareLootDrops = true;
    private boolean shareMiningDrops = true;
    private boolean shareHerbalismDrops = true;
    private boolean shareWoodcuttingDrops = true;
    private boolean shareMiscDrops = true;

    public Party(String name) {
        this.name = name;
        this.samePartyPredicate = new SamePartyPredicate<CommandSender>(this);
    }

    public Party(PartyLeader leader, String name) {
        this.leader = leader;
        this.name = name;
        this.locked = true;
        this.level = 0;
        this.samePartyPredicate = new SamePartyPredicate<CommandSender>(this);
    }

    public Party(PartyLeader leader, String name, String password) {
        this.leader = leader;
        this.name = name;
        this.password = password;
        this.locked = true;
        this.level = 0;
        this.samePartyPredicate = new SamePartyPredicate<CommandSender>(this);
    }

    public Party(PartyLeader leader, String name, String password, boolean locked) {
        this.leader = leader;
        this.name = name;
        this.password = password;
        this.locked = locked;
        this.level = 0;
        this.samePartyPredicate = new SamePartyPredicate<CommandSender>(this);
    }

    public LinkedHashMap<UUID, String> getMembers() {
        return this.members;
    }

    public List<Player> getOnlineMembers() {
        return this.onlineMembers;
    }

    public List<Player> getVisibleMembers(Player player) {
        ArrayList<Player> visibleMembers = new ArrayList<Player>();
        for (Player p : this.onlineMembers) {
            if (!player.canSee(p)) continue;
            visibleMembers.add(p);
        }
        return visibleMembers;
    }

    public List<String> getOnlinePlayerNames(CommandSender sender) {
        Player player = sender instanceof Player ? (Player)sender : null;
        ArrayList<String> onlinePlayerNames = new ArrayList<String>();
        for (Player onlinePlayer : this.getOnlineMembers()) {
            if (player == null || !player.canSee(onlinePlayer)) continue;
            onlinePlayerNames.add(onlinePlayer.getName());
        }
        return onlinePlayerNames;
    }

    public boolean addOnlineMember(Player player) {
        return this.onlineMembers.add(player);
    }

    public boolean removeOnlineMember(Player player) {
        return this.onlineMembers.remove(player);
    }

    public String getName() {
        return this.name;
    }

    public PartyLeader getLeader() {
        return this.leader;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public Party getAlly() {
        return this.ally;
    }

    public List<String> getItemShareCategories() {
        ArrayList<String> shareCategories = new ArrayList<String>();
        for (ItemShareType shareType : ItemShareType.values()) {
            if (!this.sharingDrops(shareType)) continue;
            shareCategories.add(shareType.getLocaleString());
        }
        return shareCategories;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLeader(PartyLeader leader) {
        this.leader = leader;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setAlly(Party ally) {
        this.ally = ally;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public float getXp() {
        return this.xp;
    }

    public void setXp(float xp) {
        this.xp = xp;
    }

    public void addXp(float xp) {
        this.setXp(this.getXp() + xp);
    }

    protected float levelUp() {
        float xpRemoved = this.getXpToLevel();
        this.setLevel(this.getLevel() + 1);
        this.setXp(this.getXp() - xpRemoved);
        return xpRemoved;
    }

    public int getXpToLevel() {
        FormulaType formulaType = ExperienceConfig.getInstance().getFormulaType();
        return mcMMO.getFormulaManager().getXPtoNextLevel(this.level, formulaType) * (this.getOnlineMembers().size() + mcMMO.p.getGeneralConfig().getPartyXpCurveMultiplier());
    }

    public String getXpToLevelPercentage() {
        return percent.format(this.getXp() / (float)this.getXpToLevel());
    }

    public void applyXpGain(float xp) {
        if (!EventUtils.handlePartyXpGainEvent(this, xp)) {
            return;
        }
        if (this.getXp() < (float)this.getXpToLevel()) {
            return;
        }
        int levelsGained = 0;
        float xpRemoved = 0.0f;
        while (this.getXp() >= (float)this.getXpToLevel()) {
            if (this.hasReachedLevelCap()) {
                this.setXp(0.0f);
                return;
            }
            xpRemoved += this.levelUp();
            ++levelsGained;
        }
        if (!EventUtils.handlePartyLevelChangeEvent(this, levelsGained, xpRemoved)) {
            return;
        }
        if (!mcMMO.p.getGeneralConfig().getPartyInformAllMembers()) {
            Player leader = mcMMO.p.getServer().getPlayer(this.leader.getUniqueId());
            if (leader != null) {
                leader.sendMessage(LocaleLoader.getString("Party.LevelUp", levelsGained, this.getLevel()));
                if (mcMMO.p.getGeneralConfig().getLevelUpSoundsEnabled()) {
                    SoundManager.sendSound(leader, leader.getLocation(), SoundType.LEVEL_UP);
                }
            }
        } else {
            mcMMO.p.getPartyManager().informPartyMembersLevelUp(this, levelsGained, this.getLevel());
        }
    }

    public boolean hasReachedLevelCap() {
        return mcMMO.p.getGeneralConfig().getPartyLevelCap() < this.getLevel() + 1;
    }

    public void setXpShareMode(ShareMode xpShareMode) {
        this.xpShareMode = xpShareMode;
    }

    public ShareMode getXpShareMode() {
        return this.xpShareMode;
    }

    public void setItemShareMode(ShareMode itemShareMode) {
        this.itemShareMode = itemShareMode;
    }

    public ShareMode getItemShareMode() {
        return this.itemShareMode;
    }

    public boolean sharingDrops(ItemShareType shareType) {
        switch (shareType) {
            case HERBALISM: {
                return this.shareHerbalismDrops;
            }
            case LOOT: {
                return this.shareLootDrops;
            }
            case MINING: {
                return this.shareMiningDrops;
            }
            case MISC: {
                return this.shareMiscDrops;
            }
            case WOODCUTTING: {
                return this.shareWoodcuttingDrops;
            }
        }
        return false;
    }

    public void setSharingDrops(ItemShareType shareType, boolean enabled) {
        switch (shareType) {
            case HERBALISM: {
                this.shareHerbalismDrops = enabled;
                break;
            }
            case LOOT: {
                this.shareLootDrops = enabled;
                break;
            }
            case MINING: {
                this.shareMiningDrops = enabled;
                break;
            }
            case MISC: {
                this.shareMiscDrops = enabled;
                break;
            }
            case WOODCUTTING: {
                this.shareWoodcuttingDrops = enabled;
                break;
            }
        }
    }

    public boolean hasMember(String memberName) {
        return this.getMembers().values().stream().anyMatch(memberName::equalsIgnoreCase);
    }

    public boolean hasMember(UUID uuid) {
        return this.getMembers().containsKey(uuid);
    }

    public String createMembersList(Player player) {
        StringBuilder memberList = new StringBuilder();
        ArrayList<CallSite> coloredNames = new ArrayList<CallSite>();
        for (UUID playerUUID : this.members.keySet()) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerUUID);
            if (offlinePlayer.isOnline() && player.canSee((Player)offlinePlayer)) {
                ChatColor onlineColor = this.leader.getUniqueId().equals(playerUUID) ? ChatColor.GOLD : ChatColor.GREEN;
                coloredNames.add((CallSite)((Object)(String.valueOf(onlineColor) + offlinePlayer.getName())));
                continue;
            }
            coloredNames.add((CallSite)((Object)(String.valueOf(ChatColor.DARK_GRAY) + this.members.get(playerUUID))));
        }
        this.buildChatMessage(memberList, coloredNames.toArray(new String[0]));
        return memberList.toString();
    }

    private void buildChatMessage(@NotNull StringBuilder stringBuilder, String @NotNull [] names) {
        for (int i = 0; i < names.length; ++i) {
            if (i + 1 >= names.length) {
                stringBuilder.append(names[i]);
                continue;
            }
            stringBuilder.append(names[i]).append(" ");
        }
    }

    public List<Player> getNearMembers(McMMOPlayer mcMMOPlayer) {
        ArrayList<Player> nearMembers = new ArrayList<Player>();
        Party party = mcMMOPlayer.getParty();
        if (party != null) {
            Player player = mcMMOPlayer.getPlayer();
            double range = mcMMO.p.getGeneralConfig().getPartyShareRange();
            for (Player member : party.getOnlineMembers()) {
                if (player.equals(member) || !member.isValid() || !Misc.isNear(player.getLocation(), member.getLocation(), range)) continue;
                nearMembers.add(member);
            }
        }
        return nearMembers;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Party)) {
            return false;
        }
        Party other = (Party)obj;
        if (this.getName() == null || other.getName() == null) {
            return false;
        }
        return this.getName().equals(other.getName());
    }

    @NotNull
    public Predicate<CommandSender> getSamePartyPredicate() {
        return this.samePartyPredicate;
    }
}

