/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.chat.author;

import com.gmail.nossr50.chat.author.Author;
import com.gmail.nossr50.datatypes.chat.ChatChannel;
import com.gmail.nossr50.util.text.TextUtils;
import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPlayerAuthor
implements Author {
    @NotNull
    private final Player player;
    @NotNull
    private String lastKnownDisplayName;
    @NotNull
    private final HashMap<ChatChannel, String> sanitizedNameCache;

    public AbstractPlayerAuthor(@NotNull Player player) {
        this.player = player;
        this.lastKnownDisplayName = player.getDisplayName();
        this.sanitizedNameCache = new HashMap();
    }

    private boolean hasPlayerDisplayNameChanged() {
        return !this.player.getDisplayName().equals(this.lastKnownDisplayName);
    }

    private void updateLastKnownDisplayName() {
        this.lastKnownDisplayName = this.player.getDisplayName();
    }

    @NotNull
    protected String getSanitizedName(@NotNull ChatChannel chatChannel, boolean useDisplayName) {
        if (this.sanitizedNameCache.containsKey((Object)chatChannel)) {
            if (useDisplayName && this.hasPlayerDisplayNameChanged()) {
                this.updateLastKnownDisplayName();
                this.updateSanitizedNameCache(chatChannel, true);
            }
        } else {
            if (useDisplayName && this.hasPlayerDisplayNameChanged()) {
                this.updateLastKnownDisplayName();
            }
            this.updateSanitizedNameCache(chatChannel, useDisplayName);
        }
        return this.sanitizedNameCache.get((Object)chatChannel);
    }

    private void updateSanitizedNameCache(@NotNull ChatChannel chatChannel, boolean useDisplayName) {
        if (useDisplayName) {
            this.sanitizedNameCache.put(chatChannel, TextUtils.sanitizeForSerializer(this.player.getDisplayName()));
        } else {
            this.sanitizedNameCache.put(chatChannel, this.player.getName());
        }
    }

    @Override
    public boolean isConsole() {
        return false;
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    public @NonNull UUID uuid() {
        return this.player.getUniqueId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPlayerAuthor that = (AbstractPlayerAuthor)o;
        return Objects.equal((Object)this.player, (Object)that.player) && Objects.equal((Object)this.lastKnownDisplayName, (Object)that.lastKnownDisplayName) && Objects.equal(this.sanitizedNameCache, that.sanitizedNameCache);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.player, this.lastKnownDisplayName, this.sanitizedNameCache});
    }
}

