/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.player;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UserManager {
    private static HashSet<McMMOPlayer> playerDataSet;

    private UserManager() {
    }

    public static void track(@NotNull McMMOPlayer mcMMOPlayer) {
        mcMMOPlayer.getPlayer().setMetadata("mcMMO: Player Data", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)mcMMOPlayer));
        if (playerDataSet == null) {
            playerDataSet = new HashSet();
        }
        playerDataSet.add(mcMMOPlayer);
    }

    public static void cleanupPlayer(McMMOPlayer mcMMOPlayer) {
        if (playerDataSet != null) {
            playerDataSet.remove(mcMMOPlayer);
        }
    }

    public static void remove(@NotNull Player player) {
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            return;
        }
        mcMMOPlayer.cleanup();
        player.removeMetadata("mcMMO: Player Data", (Plugin)mcMMO.p);
        if (playerDataSet != null) {
            playerDataSet.remove(mcMMOPlayer);
        }
    }

    public static void clearAll() {
        for (Player player : mcMMO.p.getServer().getOnlinePlayers()) {
            UserManager.remove(player);
        }
        if (playerDataSet != null) {
            playerDataSet.clear();
        }
    }

    public static void saveAll() {
        if (playerDataSet == null) {
            return;
        }
        ImmutableList trackedSyncData = ImmutableList.copyOf(playerDataSet);
        mcMMO.p.getLogger().info("Saving mcMMOPlayers... (" + trackedSyncData.size() + ")");
        for (McMMOPlayer playerData : trackedSyncData) {
            try {
                LogUtils.debug(mcMMO.p.getLogger(), "Saving data for player: " + playerData.getPlayerName());
                playerData.getProfile().save(true);
            }
            catch (Exception e) {
                mcMMO.p.getLogger().warning("Could not save mcMMO player data for player: " + playerData.getPlayerName());
            }
        }
        mcMMO.p.getLogger().info("Finished save operation for " + trackedSyncData.size() + " players!");
    }

    @NotNull
    public static Collection<McMMOPlayer> getPlayers() {
        ArrayList<McMMOPlayer> playerCollection = new ArrayList<McMMOPlayer>();
        for (Player player : mcMMO.p.getServer().getOnlinePlayers()) {
            if (!UserManager.hasPlayerDataKey((Entity)player)) continue;
            playerCollection.add(UserManager.getPlayer(player));
        }
        return playerCollection;
    }

    @Nullable
    public static McMMOPlayer getPlayer(String playerName) {
        return UserManager.retrieveMcMMOPlayer(playerName, false);
    }

    @Nullable
    public static McMMOPlayer getOfflinePlayer(OfflinePlayer player) {
        if (player instanceof Player) {
            return UserManager.getPlayer((Player)player);
        }
        return UserManager.retrieveMcMMOPlayer(player.getName(), true);
    }

    @Nullable
    public static McMMOPlayer getOfflinePlayer(String playerName) {
        return UserManager.retrieveMcMMOPlayer(playerName, true);
    }

    @Nullable
    public static McMMOPlayer getPlayer(@Nullable Player player) {
        if (player != null && player.hasMetadata("mcMMO: Player Data")) {
            return (McMMOPlayer)((MetadataValue)player.getMetadata("mcMMO: Player Data").get(0)).value();
        }
        return null;
    }

    @Nullable
    private static McMMOPlayer retrieveMcMMOPlayer(@Nullable String playerName, boolean offlineValid) {
        if (playerName == null) {
            return null;
        }
        Player player = mcMMO.p.getServer().getPlayerExact(playerName);
        if (player == null) {
            if (!offlineValid) {
                mcMMO.p.getLogger().warning("A valid mcMMOPlayer object could not be found for " + playerName + ".");
            }
            return null;
        }
        return UserManager.getPlayer(player);
    }

    public static boolean hasPlayerDataKey(@Nullable Entity entity) {
        return entity != null && entity.hasMetadata("mcMMO: Player Data");
    }
}

