/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.datatypes.skills.subskills.taming.CallOfTheWildType;
import com.gmail.nossr50.skills.taming.TrackedTamingEntity;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.gmail.nossr50.util.text.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransientEntityTracker {
    @NotNull
    final Map<UUID, Set<TrackedTamingEntity>> playerSummonedEntityTracker = new ConcurrentHashMap<UUID, Set<TrackedTamingEntity>>();
    @NotNull
    final Set<LivingEntity> entityLookupCache = ConcurrentHashMap.newKeySet();

    public void initPlayer(@NotNull Player player) {
        this.playerSummonedEntityTracker.computeIfAbsent(player.getUniqueId(), __ -> ConcurrentHashMap.newKeySet());
    }

    public void cleanupPlayer(@NotNull Player player) {
        this.cleanPlayer(player, player.getUniqueId());
    }

    public int getActiveSummonsForPlayerOfType(@NotNull UUID playerUUID, @NotNull CallOfTheWildType callOfTheWildType) {
        return this.getTrackedEntities(playerUUID, callOfTheWildType).stream().filter(tte -> tte.getLivingEntity().isValid()).mapToInt(tte -> 1).sum();
    }

    public void addSummon(@NotNull UUID playerUUID, @NotNull TrackedTamingEntity trackedTamingEntity) {
        this.playerSummonedEntityTracker.computeIfAbsent(playerUUID, __ -> ConcurrentHashMap.newKeySet()).add(trackedTamingEntity);
        this.entityLookupCache.add(trackedTamingEntity.getLivingEntity());
    }

    public void killSummonAndCleanMobFlags(@NotNull LivingEntity livingEntity, @Nullable Player player, boolean timeExpired) {
        if (livingEntity.isValid()) {
            livingEntity.setHealth(0.0);
            livingEntity.remove();
            Location location = livingEntity.getLocation();
            if (location.getWorld() != null) {
                location.getWorld().playSound(location, Sound.BLOCK_FIRE_EXTINGUISH, 0.8f, 0.8f);
                ParticleEffectUtils.playCallOfTheWildEffect(livingEntity);
            }
            if (player != null && player.isOnline()) {
                if (timeExpired) {
                    NotificationManager.sendPlayerInformationChatOnly(player, "Taming.Summon.COTW.TimeExpired", StringUtils.getPrettyEntityTypeString(livingEntity.getType()));
                } else {
                    NotificationManager.sendPlayerInformationChatOnly(player, "Taming.Summon.COTW.Removed", StringUtils.getPrettyEntityTypeString(livingEntity.getType()));
                }
            }
        }
    }

    public boolean isTransient(@NotNull LivingEntity livingEntity) {
        return this.entityLookupCache.contains(livingEntity);
    }

    @NotNull
    private Set<TrackedTamingEntity> getTrackedEntities(@NotNull UUID playerUUID, @NotNull CallOfTheWildType callOfTheWildType) {
        Set entities = this.playerSummonedEntityTracker.computeIfAbsent(playerUUID, __ -> ConcurrentHashMap.newKeySet());
        return entities.stream().filter(trackedTamingEntity -> trackedTamingEntity.getCallOfTheWildType() == callOfTheWildType).collect(Collectors.toSet());
    }

    private void cleanPlayer(@Nullable Player player, @NotNull UUID playerUUID) {
        this.killAndCleanAllSummons(playerUUID, player);
        this.playerSummonedEntityTracker.remove(playerUUID);
    }

    private void killAndCleanAllSummons(@NotNull UUID playerUUID, @Nullable Player player) {
        Set<TrackedTamingEntity> entities = this.playerSummonedEntityTracker.get(playerUUID);
        if (entities == null) {
            return;
        }
        HashSet<TrackedTamingEntity> playerSummonsToRemove = new HashSet<TrackedTamingEntity>(entities);
        playerSummonsToRemove.forEach(trackedTamingEntity -> this.killAndCleanSummon(playerUUID, player, (TrackedTamingEntity)trackedTamingEntity));
    }

    public void killAndCleanSummon(@NotNull UUID playerUUID, @Nullable Player player, @NotNull TrackedTamingEntity trackedTamingEntity) {
        this.killSummonAndCleanMobFlags(trackedTamingEntity.getLivingEntity(), player, false);
        this.removeSummonFromTracker(playerUUID, trackedTamingEntity);
    }

    public void removeSummonFromTracker(@NotNull UUID playerUUID, @NotNull TrackedTamingEntity trackedTamingEntity) {
        this.entityLookupCache.remove(trackedTamingEntity.getLivingEntity());
        if (this.playerSummonedEntityTracker.containsKey(playerUUID)) {
            this.playerSummonedEntityTracker.get(playerUUID).remove(trackedTamingEntity);
        }
    }

    public void removeTrackedEntity(@NotNull LivingEntity livingEntity) {
        if (!this.entityLookupCache.contains(livingEntity)) {
            return;
        }
        ArrayList matchingEntities = new ArrayList();
        this.playerSummonedEntityTracker.values().forEach(trackedEntitiesPerPlayer -> trackedEntitiesPerPlayer.stream().filter(trackedTamingEntity -> trackedTamingEntity.getLivingEntity() == livingEntity).forEach(matchingEntities::add));
        matchingEntities.forEach(TrackedTamingEntity::run);
    }
}

