/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database;

import com.gmail.nossr50.database.DatabaseManager;
import com.gmail.nossr50.database.FlatFileDatabaseManager;
import com.gmail.nossr50.database.SQLDatabaseManager;
import com.gmail.nossr50.datatypes.database.DatabaseType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseManagerFactory {
    private static Class<? extends DatabaseManager> customManager = null;
    public static final String MYSQL_DRIVER = "com.mysql.cj.jdbc.Driver";

    public static DatabaseManager getDatabaseManager(@NotNull String userFilePath, @NotNull Logger logger, long purgeTime, int startingLevel) {
        if (customManager != null) {
            try {
                return DatabaseManagerFactory.createDefaultCustomDatabaseManager();
            }
            catch (Exception e) {
                LogUtils.debug(mcMMO.p.getLogger(), "Could not create custom database manager");
                e.printStackTrace();
            }
            catch (Throwable e) {
                LogUtils.debug(mcMMO.p.getLogger(), "Failed to create custom database manager");
                e.printStackTrace();
            }
            LogUtils.debug(mcMMO.p.getLogger(), "Falling back on " + (mcMMO.p.getGeneralConfig().getUseMySQL() ? "SQL" : "Flatfile") + " database");
        }
        return mcMMO.p.getGeneralConfig().getUseMySQL() ? new SQLDatabaseManager(logger, MYSQL_DRIVER) : new FlatFileDatabaseManager(userFilePath, logger, purgeTime, startingLevel);
    }

    public static void setCustomDatabaseManagerClass(Class<? extends DatabaseManager> clazz) {
        try {
            clazz.getConstructor(new Class[0]);
            customManager = clazz;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Provided database manager class must have an empty constructor", e);
        }
    }

    public static Class<? extends DatabaseManager> getCustomDatabaseManagerClass() {
        return customManager;
    }

    @Nullable
    public static DatabaseManager createDatabaseManager(@NotNull DatabaseType type, @NotNull String userFilePath, @NotNull Logger logger, long purgeTime, int startingLevel) {
        switch (type) {
            case FLATFILE: {
                LogUtils.debug(mcMMO.p.getLogger(), "Using FlatFile Database");
                return new FlatFileDatabaseManager(userFilePath, logger, purgeTime, startingLevel);
            }
            case SQL: {
                LogUtils.debug(mcMMO.p.getLogger(), "Using SQL Database");
                return new SQLDatabaseManager(logger, MYSQL_DRIVER);
            }
            case CUSTOM: {
                try {
                    LogUtils.debug(mcMMO.p.getLogger(), "Attempting to use Custom Database");
                    return DatabaseManagerFactory.createDefaultCustomDatabaseManager();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static DatabaseManager createDefaultCustomDatabaseManager() throws Throwable {
        return customManager.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static DatabaseManager createCustomDatabaseManager(Class<? extends DatabaseManager> clazz) throws Throwable {
        return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

