/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.skills;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.CancellableRunnable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class AwardCombatXpTask
extends CancellableRunnable {
    private final McMMOPlayer mcMMOPlayer;
    private final double baseXp;
    private final PrimarySkillType primarySkillType;
    private final LivingEntity target;
    private final XPGainReason xpGainReason;
    private final double baseHealth;

    public AwardCombatXpTask(McMMOPlayer mcMMOPlayer, PrimarySkillType primarySkillType, double baseXp, LivingEntity target, XPGainReason xpGainReason) {
        this.mcMMOPlayer = mcMMOPlayer;
        this.primarySkillType = primarySkillType;
        this.baseXp = baseXp;
        this.target = target;
        this.xpGainReason = xpGainReason;
        this.baseHealth = target.getHealth();
    }

    @Override
    public void run() {
        double health = this.target.getHealth();
        double damage = this.baseHealth - health;
        if (damage <= 0.0) {
            return;
        }
        if (health < 0.0) {
            damage += health;
        }
        if (ExperienceConfig.getInstance().useCombatHPCeiling()) {
            damage = Math.min(damage, (double)ExperienceConfig.getInstance().getCombatHPCeiling());
        }
        double finalDamage = damage;
        mcMMO.p.getFoliaLib().getScheduler().runAtEntity((Entity)this.mcMMOPlayer.getPlayer(), task -> this.mcMMOPlayer.beginXpGain(this.primarySkillType, (int)(finalDamage * this.baseXp), this.xpGainReason, XPGainSource.SELF));
    }
}

