/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.archery;

import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.archery.Archery;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.PotionEffectUtil;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class ArcheryManager
extends SkillManager {
    public ArcheryManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.ARCHERY);
    }

    public boolean canDaze(LivingEntity target) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.ARCHERY_DAZE)) {
            return false;
        }
        return target instanceof Player && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.ARCHERY_DAZE);
    }

    public boolean canSkillShot() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.ARCHERY_SKILL_SHOT)) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.ARCHERY_SKILL_SHOT);
    }

    public boolean canRetrieveArrows() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.ARCHERY_ARROW_RETRIEVAL)) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.ARCHERY_ARROW_RETRIEVAL);
    }

    public static double distanceXpBonusMultiplier(LivingEntity target, Entity arrow) {
        if (!arrow.hasMetadata("mcMMO: Arrow Distance")) {
            return 1.0;
        }
        Location firedLocation = (Location)((MetadataValue)arrow.getMetadata("mcMMO: Arrow Distance").get(0)).value();
        Location targetLocation = target.getLocation();
        if (firedLocation == null || firedLocation.getWorld() == null) {
            return 1.0;
        }
        if (firedLocation.getWorld() != targetLocation.getWorld()) {
            return 1.0;
        }
        return 1.0 + Math.min(firedLocation.distance(targetLocation), 50.0) * Archery.DISTANCE_XP_MULTIPLIER;
    }

    public void retrieveArrows(LivingEntity target, Projectile projectile) {
        if (projectile.hasMetadata("mcMMO: Tracked Arrow")) {
            Archery.incrementTrackerValue(target);
            projectile.removeMetadata("mcMMO: Tracked Arrow", (Plugin)mcMMO.p);
        }
    }

    public double daze(Player defender) {
        if (!ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.ARCHERY_DAZE, this.mmoPlayer)) {
            return 0.0;
        }
        Location dazedLocation = defender.getLocation();
        dazedLocation.setPitch((float)(90 - Misc.getRandom().nextInt(181)));
        mcMMO.p.getFoliaLib().getScheduler().teleportAsync((Entity)defender, dazedLocation);
        defender.addPotionEffect(new PotionEffect(PotionEffectUtil.getNauseaPotionEffectType(), 200, 10));
        if (NotificationManager.doesPlayerUseNotifications(defender)) {
            NotificationManager.sendPlayerInformation(defender, NotificationType.SUBSKILL_MESSAGE, "Combat.TouchedFuzzy");
        }
        if (this.mmoPlayer.useChatNotifications()) {
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE, "Combat.TargetDazed");
        }
        return Archery.dazeBonusDamage;
    }

    public double skillShot(double oldDamage) {
        if (ProbabilityUtil.isNonRNGSkillActivationSuccessful(SubSkillType.ARCHERY_SKILL_SHOT, this.mmoPlayer)) {
            return Archery.getSkillShotBonusDamage(this.getPlayer(), oldDamage);
        }
        return oldDamage;
    }
}

