/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.skills;

import com.gmail.nossr50.config.HiddenConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.ItemMetadataUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.PotionEffectUtil;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.PerksUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.text.StringUtils;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SkillUtils {
    private SkillUtils() {
    }

    public static void applyXpGain(McMMOPlayer mmoPlayer, PrimarySkillType skill, float xp, XPGainReason xpGainReason) {
        mmoPlayer.beginXpGain(skill, xp, xpGainReason, XPGainSource.SELF);
    }

    public static void applyXpGain(McMMOPlayer mmoPlayer, PrimarySkillType skill, float xp, XPGainReason xpGainReason, XPGainSource xpGainSource) {
        mmoPlayer.beginXpGain(skill, xp, xpGainReason, xpGainSource);
    }

    public static String[] calculateLengthDisplayValues(Player player, float skillValue, PrimarySkillType skill) {
        int maxLength = mcMMO.p.getSkillTools().getSuperAbilityMaxLength(mcMMO.p.getSkillTools().getSuperAbility(skill));
        int abilityLengthVar = mcMMO.p.getAdvancedConfig().getAbilityLength();
        int abilityLengthCap = mcMMO.p.getAdvancedConfig().getAbilityLengthCap();
        int length = abilityLengthCap > 0 ? (int)Math.min((float)abilityLengthCap, 2.0f + skillValue / (float)abilityLengthVar) : 2 + (int)(skillValue / (float)abilityLengthVar);
        int enduranceLength = PerksUtils.handleActivationPerks(player, length, maxLength);
        if (maxLength != 0) {
            length = Math.min(length, maxLength);
        }
        return new String[]{String.valueOf(length), String.valueOf(enduranceLength)};
    }

    public static int handleFoodSkills(Player player, int eventFoodLevel, SubSkillType subSkillType) {
        int curRank = RankUtils.getRank(player, subSkillType);
        int currentFoodLevel = player.getFoodLevel();
        int foodChange = eventFoodLevel - currentFoodLevel;
        return currentFoodLevel + (foodChange += curRank);
    }

    public static int calculateTimeLeft(long deactivatedTimeStamp, int cooldown, Player player) {
        return (int)((deactivatedTimeStamp + (long)(PerksUtils.handleCooldownPerks(player, cooldown) * 1000) - System.currentTimeMillis()) / 1000L);
    }

    public static boolean cooldownExpired(long deactivatedTimeStamp, int cooldown) {
        return System.currentTimeMillis() >= (deactivatedTimeStamp + (long)cooldown) * 1000L;
    }

    public static boolean isSkill(String skillName) {
        return mcMMO.p.getGeneralConfig().getLocale().equalsIgnoreCase("en_US") ? mcMMO.p.getSkillTools().matchSkill(skillName) != null : SkillUtils.isLocalizedSkill(skillName);
    }

    public static void sendSkillMessage(Player player, NotificationType notificationType, String key) {
        Location location = player.getLocation();
        for (Player otherPlayer : player.getWorld().getPlayers()) {
            if (otherPlayer == player || !Misc.isNear(location, otherPlayer.getLocation(), 10.0)) continue;
            NotificationManager.sendNearbyPlayersInformation(otherPlayer, notificationType, key, player.getName());
        }
    }

    public static void handleAbilitySpeedIncrease(Player player) {
        if (HiddenConfig.getInstance().useEnchantmentBuffs()) {
            ItemStack heldItem = player.getInventory().getItemInMainHand();
            if (heldItem == null) {
                return;
            }
            if (!ItemUtils.canBeSuperAbilityDigBoosted(heldItem)) {
                return;
            }
            int originalDigSpeed = heldItem.getEnchantmentLevel(mcMMO.p.getEnchantmentMapper().getEfficiency());
            ItemUtils.addDigSpeedToItem(heldItem, heldItem.getEnchantmentLevel(mcMMO.p.getEnchantmentMapper().getEfficiency()));
            ItemMetadataUtils.setSuperAbilityBoostedItem(heldItem, originalDigSpeed);
        } else {
            McMMOPlayer mmoPlayer;
            int duration = 0;
            int amplifier = 0;
            if (player.hasPotionEffect(PotionEffectUtil.getHastePotionEffectType())) {
                for (PotionEffect effect : player.getActivePotionEffects()) {
                    if (effect.getType() != PotionEffectUtil.getHastePotionEffectType()) continue;
                    duration = effect.getDuration();
                    amplifier = effect.getAmplifier();
                    break;
                }
            }
            if ((mmoPlayer = UserManager.getPlayer(player)) == null) {
                return;
            }
            PrimarySkillType skill = mmoPlayer.getAbilityMode(SuperAbilityType.SUPER_BREAKER) ? PrimarySkillType.MINING : PrimarySkillType.EXCAVATION;
            int abilityLengthVar = mcMMO.p.getAdvancedConfig().getAbilityLength();
            int abilityLengthCap = mcMMO.p.getAdvancedConfig().getAbilityLengthCap();
            int ticks = abilityLengthCap > 0 ? PerksUtils.handleActivationPerks(player, Math.min(abilityLengthCap, 2 + mmoPlayer.getSkillLevel(skill) / abilityLengthVar), mcMMO.p.getSkillTools().getSuperAbilityMaxLength(mcMMO.p.getSkillTools().getSuperAbility(skill))) * 20 : PerksUtils.handleActivationPerks(player, 2 + mmoPlayer.getSkillLevel(skill) / abilityLengthVar, mcMMO.p.getSkillTools().getSuperAbilityMaxLength(mcMMO.p.getSkillTools().getSuperAbility(skill))) * 20;
            PotionEffect abilityBuff = new PotionEffect(PotionEffectUtil.getHastePotionEffectType(), duration + ticks, amplifier + 10);
            player.addPotionEffect(abilityBuff, true);
        }
    }

    public static void removeAbilityBoostsFromInventory(@NotNull Player player) {
        for (ItemStack itemStack : player.getInventory().getContents()) {
            SkillUtils.removeAbilityBuff(itemStack);
        }
    }

    public static void removeAbilityBuff(@Nullable ItemStack itemStack) {
        ItemMeta itemMeta;
        if (itemStack == null) {
            return;
        }
        if (!ItemUtils.canBeSuperAbilityDigBoosted(itemStack)) {
            return;
        }
        if (ItemMetadataUtils.isLegacyAbilityTool(itemStack) && (itemMeta = itemStack.getItemMeta()) != null) {
            itemMeta.removeEnchant(mcMMO.p.getEnchantmentMapper().getEfficiency());
            itemStack.setItemMeta(itemMeta);
            ItemUtils.removeAbilityLore(itemStack);
        }
        if (ItemMetadataUtils.isSuperAbilityBoosted(itemStack)) {
            ItemMetadataUtils.removeBonusDigSpeedOnSuperAbilityTool(itemStack);
        }
    }

    public static void handleDurabilityChange(ItemStack itemStack, int durabilityModifier) {
        SkillUtils.handleDurabilityChange(itemStack, durabilityModifier, 1.0);
    }

    public static void handleDurabilityChange(ItemStack itemStack, double durabilityModifier, double maxDamageModifier) {
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().isUnbreakable()) {
            return;
        }
        Material type = itemStack.getType();
        short maxDurability = mcMMO.getRepairableManager().isRepairable(type) ? mcMMO.getRepairableManager().getRepairable(type).getMaximumDurability() : type.getMaxDurability();
        durabilityModifier = (int)Math.min(durabilityModifier / (double)(itemStack.getEnchantmentLevel(mcMMO.p.getEnchantmentMapper().getUnbreaking()) + 1), (double)maxDurability * maxDamageModifier);
        itemStack.setDurability((short)Math.min((double)itemStack.getDurability() + durabilityModifier, (double)maxDurability));
    }

    private static boolean isLocalizedSkill(String skillName) {
        for (PrimarySkillType skill : PrimarySkillType.values()) {
            if (!skillName.equalsIgnoreCase(LocaleLoader.getString(StringUtils.getCapitalized(skill.toString()) + ".SkillName"))) continue;
            return true;
        }
        return false;
    }

    public static void handleArmorDurabilityChange(ItemStack itemStack, double durabilityModifier, double maxDamageModifier) {
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().isUnbreakable()) {
            return;
        }
        Material type = itemStack.getType();
        short maxDurability = mcMMO.getRepairableManager().isRepairable(type) ? mcMMO.getRepairableManager().getRepairable(type).getMaximumDurability() : type.getMaxDurability();
        durabilityModifier = (int)Math.min(durabilityModifier * (0.6 + 0.4 / (double)(itemStack.getEnchantmentLevel(mcMMO.p.getEnchantmentMapper().getUnbreaking()) + 1)), (double)maxDurability * maxDamageModifier);
        itemStack.setDurability((short)Math.min((double)itemStack.getDurability() + durabilityModifier, (double)maxDurability));
    }

    @Nullable
    public static Material getRepairAndSalvageItem(@NotNull ItemStack inHand) {
        if (ItemUtils.isPrismarineTool(inHand)) {
            return Material.PRISMARINE_CRYSTALS;
        }
        if (ItemUtils.isNetheriteTool(inHand) || ItemUtils.isNetheriteArmor(inHand)) {
            return Material.NETHERITE_SCRAP;
        }
        if (ItemUtils.isDiamondTool(inHand) || ItemUtils.isDiamondArmor(inHand)) {
            return Material.DIAMOND;
        }
        if (ItemUtils.isGoldTool(inHand) || ItemUtils.isGoldArmor(inHand)) {
            return Material.GOLD_INGOT;
        }
        if (ItemUtils.isIronTool(inHand) || ItemUtils.isIronArmor(inHand)) {
            return Material.IRON_INGOT;
        }
        if (ItemUtils.isStoneTool(inHand)) {
            return Material.COBBLESTONE;
        }
        if (ItemUtils.isWoodTool(inHand)) {
            return Material.OAK_WOOD;
        }
        if (ItemUtils.isLeatherArmor(inHand)) {
            return Material.LEATHER;
        }
        if (ItemUtils.isStringTool(inHand)) {
            return Material.STRING;
        }
        return null;
    }

    public static int getRepairAndSalvageQuantities(ItemStack item) {
        return SkillUtils.getRepairAndSalvageQuantities(item.getType(), SkillUtils.getRepairAndSalvageItem(item));
    }

    public static int getRepairAndSalvageQuantities(Material itemMaterial, Material recipeMaterial) {
        int quantity = 0;
        if (mcMMO.getMaterialMapStore().isPrismarineTool(itemMaterial)) {
            return 16;
        }
        if (mcMMO.getMaterialMapStore().isNetheriteTool(itemMaterial) || mcMMO.getMaterialMapStore().isNetheriteArmor(itemMaterial)) {
            return 4;
        }
        Iterator recipeIterator = Bukkit.getServer().recipeIterator();
        while (recipeIterator.hasNext()) {
            Recipe bukkitRecipe = (Recipe)recipeIterator.next();
            if (bukkitRecipe.getResult().getType() != itemMaterial) continue;
            if (bukkitRecipe instanceof ShapelessRecipe) {
                for (ItemStack ingredient : ((ShapelessRecipe)bukkitRecipe).getIngredientList()) {
                    if (ingredient == null || recipeMaterial != null && ingredient.getType() != recipeMaterial || ingredient.getType() != recipeMaterial) continue;
                    quantity += ingredient.getAmount();
                }
                continue;
            }
            if (!(bukkitRecipe instanceof ShapedRecipe)) continue;
            for (ItemStack ingredient : ((ShapedRecipe)bukkitRecipe).getIngredientMap().values()) {
                if (ingredient == null || recipeMaterial != null && ingredient.getType() != recipeMaterial || ingredient.getType() != recipeMaterial) continue;
                quantity += ingredient.getAmount();
            }
        }
        return quantity;
    }

    public static boolean canUseSubskill(Player player, @NotNull SubSkillType subSkillType) {
        return Permissions.isSubSkillEnabled((Permissible)player, subSkillType) && RankUtils.hasUnlockedSubskill(player, subSkillType);
    }
}

