/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database;

import com.gmail.nossr50.api.exceptions.InvalidSkillException;
import com.gmail.nossr50.datatypes.database.DatabaseType;
import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DatabaseManager {
    public static final int progressInterval = 200;

    public int purgePowerlessUsers();

    public void purgeOldUsers();

    public boolean removeUser(String var1, UUID var2);

    public void cleanupUser(UUID var1);

    public boolean saveUser(PlayerProfile var1);

    @NotNull
    public List<PlayerStat> readLeaderboard(@Nullable PrimarySkillType var1, int var2, int var3) throws InvalidSkillException;

    public Map<PrimarySkillType, Integer> readRank(String var1);

    @NotNull
    public PlayerProfile newUser(String var1, UUID var2);

    @NotNull
    public PlayerProfile newUser(@NotNull Player var1);

    @NotNull
    public PlayerProfile loadPlayerProfile(@NotNull String var1);

    @NotNull
    public PlayerProfile loadPlayerProfile(@NotNull OfflinePlayer var1);

    @NotNull
    public PlayerProfile loadPlayerProfile(@NotNull UUID var1);

    public List<String> getStoredUsers();

    public void convertUsers(DatabaseManager var1);

    public boolean saveUserUUID(String var1, UUID var2);

    public boolean saveUserUUIDs(Map<String, UUID> var1);

    public DatabaseType getDatabaseType();

    public void onDisable();
}

