/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.config.WorldBlacklist;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.chat.ChatChannel;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.taming.CallOfTheWildType;
import com.gmail.nossr50.events.McMMOReplaceVanillaTreasureEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.MobHealthDisplayUpdaterTask;
import com.gmail.nossr50.runnables.player.PlayerProfileLoadingTask;
import com.gmail.nossr50.skills.fishing.FishingManager;
import com.gmail.nossr50.skills.herbalism.HerbalismManager;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.skills.repair.Repair;
import com.gmail.nossr50.skills.repair.RepairManager;
import com.gmail.nossr50.skills.salvage.Salvage;
import com.gmail.nossr50.skills.salvage.SalvageManager;
import com.gmail.nossr50.skills.taming.TamingManager;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.ChimaeraWing;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.HardcoreManager;
import com.gmail.nossr50.util.LogUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.MobHealthbarUtils;
import com.gmail.nossr50.util.Motd;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.worldguard.WorldGuardManager;
import com.gmail.nossr50.worldguard.WorldGuardUtils;
import java.util.Locale;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    private final mcMMO plugin;

    public PlayerListener(mcMMO plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getPlayer().getWorld())) {
            if (mcMMO.p.getGeneralConfig().getScoreboardsEnabled()) {
                ScoreboardManager.teardownPlayer(event.getPlayer());
            }
            return;
        }
        if (WorldBlacklist.isWorldBlacklisted(event.getFrom().getWorld()) && mcMMO.p.getGeneralConfig().getScoreboardsEnabled()) {
            ScoreboardManager.setupPlayer(event.getPlayer());
        }
        Player player = event.getPlayer();
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (!UserManager.hasPlayerDataKey((Entity)player) || mcMMO.p.getGeneralConfig().getXPAfterTeleportCooldown() <= 0 || event.getFrom().equals((Object)event.getTo())) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        UserManager.getPlayer(player).actualizeTeleportATS();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamageByEntityHighest(EntityDamageByEntityEvent event) {
        LivingEntity attacker;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getDamager() instanceof LivingEntity) {
            attacker = (LivingEntity)event.getDamager();
        } else if (event.getDamager() instanceof Projectile && ((Projectile)event.getDamager()).getShooter() instanceof LivingEntity) {
            attacker = (LivingEntity)((Projectile)event.getDamager()).getShooter();
        } else {
            return;
        }
        if (attacker instanceof HumanEntity) {
            return;
        }
        if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag((Player)event.getEntity())) {
            return;
        }
        if (player.getHealth() - event.getFinalDamage() > 0.0) {
            return;
        }
        new MobHealthDisplayUpdaterTask(attacker).run();
        mcMMO.p.getFoliaLib().getScheduler().runAtEntityLater((Entity)attacker, () -> MobHealthbarUtils.handleMobHealthbars(attacker, 0.0, mcMMO.p), 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDeathMonitor(PlayerDeathEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
            return;
        }
        boolean statLossEnabled = HardcoreManager.isStatLossEnabled();
        boolean vampirismEnabled = HardcoreManager.isVampirismEnabled();
        if (!statLossEnabled && !vampirismEnabled) {
            return;
        }
        Player killedPlayer = event.getEntity();
        if (!killedPlayer.hasMetadata("mcMMO: Player Data") || Permissions.hardcoreBypass((Permissible)killedPlayer)) {
            return;
        }
        Player killer = killedPlayer.getKiller();
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(killedPlayer)) {
            return;
        }
        if (statLossEnabled || killer != null && vampirismEnabled) {
            if (EventUtils.callPreDeathPenaltyEvent(killedPlayer).isCancelled()) {
                return;
            }
            if (killer != null && vampirismEnabled) {
                HardcoreManager.invokeVampirism(killer, killedPlayer);
            }
            if (statLossEnabled) {
                HardcoreManager.invokeStatPenalty(killedPlayer);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=false)
    public void onPlayerDeathNormal(PlayerDeathEvent playerDeathEvent) {
        SkillUtils.removeAbilityBoostsFromInventory(playerDeathEvent.getEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        mmoPlayer.checkGodMode();
        mmoPlayer.checkParty();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getPlayer().getWorld())) {
            return;
        }
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(event.getPlayer())) {
            return;
        }
        SkillUtils.removeAbilityBuff(event.getItemDrop().getItemStack());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerFishHighest(PlayerFishEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (!UserManager.hasPlayerDataKey((Entity)player) || !mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, PrimarySkillType.FISHING)) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        FishingManager fishingManager = UserManager.getPlayer(player).getFishingManager();
        switch (event.getState()) {
            case CAUGHT_FISH: {
                if (event.getCaught() != null) {
                    Item fishingCatch = (Item)event.getCaught();
                    if (mcMMO.p.getGeneralConfig().getFishingOverrideTreasures() && fishingCatch.getItemStack().getType() != Material.SALMON && fishingCatch.getItemStack().getType() != Material.COD && fishingCatch.getItemStack().getType() != Material.TROPICAL_FISH && fishingCatch.getItemStack().getType() != Material.PUFFERFISH) {
                        ItemStack replacementCatch = new ItemStack(Material.SALMON, 1);
                        McMMOReplaceVanillaTreasureEvent replaceVanillaTreasureEvent = new McMMOReplaceVanillaTreasureEvent(fishingCatch, replacementCatch, player);
                        Bukkit.getPluginManager().callEvent((Event)replaceVanillaTreasureEvent);
                        replacementCatch = replaceVanillaTreasureEvent.getReplacementItemStack();
                        fishingCatch.setItemStack(replacementCatch);
                    }
                    if (Permissions.vanillaXpBoost((Permissible)player, PrimarySkillType.FISHING) && fishingManager.handleVanillaXpBoost(event.getExpToDrop()) > 1) {
                        event.setExpToDrop(fishingManager.handleVanillaXpBoost(event.getExpToDrop()));
                    }
                }
                return;
            }
            case IN_GROUND: {
                Block block = player.getTargetBlock(null, 100);
                if (fishingManager.canIceFish(block)) {
                    this.cancelFishingEventAndDropXp(event, player);
                    fishingManager.iceFishing(event.getHook(), block);
                }
                return;
            }
        }
    }

    private void cancelFishingEventAndDropXp(PlayerFishEvent event, Player player) {
        event.setCancelled(true);
        ExperienceOrb experienceOrb = (ExperienceOrb)player.getWorld().spawnEntity(player.getEyeLocation(), EntityType.EXPERIENCE_ORB);
        experienceOrb.setExperience(event.getExpToDrop());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerFishMonitor(PlayerFishEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (!UserManager.hasPlayerDataKey((Entity)player) || !mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, PrimarySkillType.FISHING)) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        Entity caught = event.getCaught();
        FishingManager fishingManager = UserManager.getPlayer(player).getFishingManager();
        if (ExperienceConfig.getInstance().isFishingExploitingPrevented()) {
            if (event.getHook().getMetadata("mcMMO: Fish Hook Tracker").size() == 0) {
                fishingManager.setFishHookReference(event.getHook());
            }
            if (event.getState() == PlayerFishEvent.State.CAUGHT_FISH && fishingManager.isFishingTooOften()) {
                event.setExpToDrop(0);
                if (caught instanceof Item) {
                    Item caughtItem = (Item)caught;
                    caughtItem.remove();
                }
                return;
            }
        }
        switch (event.getState()) {
            case FISHING: {
                if (fishingManager.canMasterAngler()) {
                    int lureLevel = 0;
                    ItemStack inHand = player.getInventory().getItemInMainHand();
                    if (inHand != null && inHand.getItemMeta() != null && inHand.getType().getKey().getKey().equalsIgnoreCase("fishing_rod")) {
                        if (inHand.getItemMeta().hasEnchants()) {
                            for (Enchantment enchantment : inHand.getItemMeta().getEnchants().keySet()) {
                                if (!enchantment.toString().toLowerCase().contains("lure")) continue;
                                lureLevel = inHand.getEnchantmentLevel(enchantment);
                            }
                        }
                        if (!player.getInventory().getItemInOffHand().getType().getKey().getKey().equalsIgnoreCase("fishing_rod")) {
                            fishingManager.masterAngler(event.getHook(), lureLevel);
                            fishingManager.setFishingTarget();
                        }
                    }
                }
                return;
            }
            case CAUGHT_FISH: {
                if (caught instanceof Item) {
                    Item caughtItem = (Item)caught;
                    if (ExperienceConfig.getInstance().isFishingExploitingPrevented()) {
                        fishingManager.processExploiting(event.getHook().getLocation().toVector());
                        if (fishingManager.isExploitingFishing(event.getHook().getLocation().toVector())) {
                            player.sendMessage(LocaleLoader.getString("Fishing.ScarcityTip", ExperienceConfig.getInstance().getFishingExploitingOptionMoveRange()));
                            event.setExpToDrop(0);
                            caughtItem.remove();
                            return;
                        }
                    }
                    fishingManager.processFishing(caughtItem);
                    fishingManager.setFishingTarget();
                }
                return;
            }
            case CAUGHT_ENTITY: {
                if (fishingManager.canShake(caught)) {
                    fishingManager.shakeCheck((LivingEntity)caught);
                    fishingManager.setFishingTarget();
                }
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerPickupItem(EntityPickupItemEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getEntity().getWorld())) {
            return;
        }
        if (Misc.isNPCEntityExcludingVillagers((Entity)event.getEntity())) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
                return;
            }
            if (!UserManager.hasPlayerDataKey((Entity)player)) {
                return;
            }
            McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
            if (mmoPlayer == null) {
                return;
            }
            Item drop = event.getItem();
            if (drop.hasMetadata("mcMMO: Tracked Arrow")) {
                drop.removeMetadata("mcMMO: Tracked Arrow", (Plugin)mcMMO.p);
            }
            if (drop.hasMetadata("mcMMO: Disarmed Item") && !player.getName().equals(((MetadataValue)drop.getMetadata("mcMMO: Disarmed Item").get(0)).asString())) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        if (mmoPlayer == null) {
            return;
        }
        mmoPlayer.logout(mcMMO.isServerShutdownExecuted());
        mcMMO.getTransientMetadataTools().cleanLivingEntityMetadata((LivingEntity)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        mcMMO.p.getFoliaLib().getScheduler().runLaterAsync((Consumer)new PlayerProfileLoadingTask(player), 60L);
        if (mcMMO.p.getGeneralConfig().getMOTDEnabled() && Permissions.motd((Permissible)player)) {
            Motd.displayAll(player);
        }
        if (this.plugin.isXPEventEnabled() && mcMMO.p.getGeneralConfig().playerJoinEventInfo()) {
            player.sendMessage(LocaleLoader.getString("XPRate.Event", ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        UserManager.getPlayer(player).actualizeRespawnATS();
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractLowest(PlayerInteractEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        Material clickedBlockType = clickedBlock.getType();
        if (clickedBlockType == Repair.anvilMaterial || clickedBlockType == Salvage.anvilMaterial) {
            event.setUseItemInHand(Event.Result.ALLOW);
            if (!event.getPlayer().isSneaking() && mcMMO.getMaterialMapStore().isToolActivationBlackListed(clickedBlockType)) {
                event.setUseInteractedBlock(Event.Result.DENY);
            }
        }
        if (event.getHand() != EquipmentSlot.HAND || !UserManager.hasPlayerDataKey((Entity)player) || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        MiningManager miningManager = mmoPlayer.getMiningManager();
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        switch (event.getAction()) {
            case RIGHT_CLICK_BLOCK: {
                Material type = clickedBlock.getType();
                if (!mcMMO.p.getGeneralConfig().getAbilitiesOnlyActivateWhenSneaking() || player.isSneaking()) {
                    if (type == Repair.anvilMaterial && mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, PrimarySkillType.REPAIR) && mcMMO.getRepairableManager().isRepairable(heldItem) && heldItem.getAmount() <= 1) {
                        RepairManager repairManager = mmoPlayer.getRepairManager();
                        event.setCancelled(true);
                        if (!repairManager.checkConfirmation(true)) break;
                        repairManager.handleRepair(heldItem);
                        player.updateInventory();
                        break;
                    }
                    if (type != Salvage.anvilMaterial || !mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, PrimarySkillType.SALVAGE) || !RankUtils.hasUnlockedSubskill(player, SubSkillType.SALVAGE_SCRAP_COLLECTOR) || !mcMMO.getSalvageableManager().isSalvageable(heldItem) || heldItem.getAmount() > 1) break;
                    SalvageManager salvageManager = UserManager.getPlayer(player).getSalvageManager();
                    event.setCancelled(true);
                    if (!salvageManager.checkConfirmation(true)) break;
                    SkillUtils.removeAbilityBoostsFromInventory(player);
                    salvageManager.handleSalvage(clickedBlock.getLocation(), heldItem);
                    player.updateInventory();
                    break;
                }
                if (!miningManager.canDetonate()) break;
                if (type == Material.TNT) {
                    event.setCancelled(true);
                    break;
                }
                miningManager.remoteDetonation();
                break;
            }
            case LEFT_CLICK_BLOCK: {
                SalvageManager salvageManager;
                Material type = clickedBlock.getType();
                if (mcMMO.p.getGeneralConfig().getAbilitiesOnlyActivateWhenSneaking() && !player.isSneaking()) break;
                if (type == Repair.anvilMaterial && mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, PrimarySkillType.REPAIR) && mcMMO.getRepairableManager().isRepairable(heldItem)) {
                    RepairManager repairManager = mmoPlayer.getRepairManager();
                    if (!repairManager.checkConfirmation(false)) break;
                    repairManager.setLastAnvilUse(0);
                    player.sendMessage(LocaleLoader.getString("Skills.Cancelled", LocaleLoader.getString("Repair.Pretty.Name")));
                    break;
                }
                if (type != Salvage.anvilMaterial || !mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, PrimarySkillType.SALVAGE) || !mcMMO.getSalvageableManager().isSalvageable(heldItem) || !(salvageManager = mmoPlayer.getSalvageManager()).checkConfirmation(false)) break;
                salvageManager.setLastAnvilUse(0);
                player.sendMessage(LocaleLoader.getString("Skills.Cancelled", LocaleLoader.getString("Salvage.Pretty.Name")));
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerInteractMonitor(PlayerInteractEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasMainFlag(player)) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND || !UserManager.hasPlayerDataKey((Entity)player) || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        if (mmoPlayer == null) {
            return;
        }
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if ((event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_AIR) && ExperienceConfig.getInstance().isFishingExploitingPrevented() && (heldItem.getType() == Material.FISHING_ROD || player.getInventory().getItemInOffHand().getType() == Material.FISHING_ROD) && player.isInsideVehicle() && (player.getVehicle() instanceof Minecart || player.getVehicle() instanceof PoweredMinecart)) {
            player.getVehicle().eject();
        }
        switch (event.getAction()) {
            case RIGHT_CLICK_BLOCK: {
                if (player.getInventory().getItemInOffHand().getType() != Material.AIR && !player.isInsideVehicle() && !player.isSneaking()) break;
                if (event.getClickedBlock() == null) {
                    return;
                }
                Block block = event.getClickedBlock();
                BlockState blockState = block.getState();
                if (BlockUtils.canActivateTools(blockState)) {
                    if (mcMMO.p.getGeneralConfig().getAbilitiesEnabled()) {
                        if (BlockUtils.canActivateHerbalism(blockState)) {
                            mmoPlayer.processAbilityActivation(PrimarySkillType.HERBALISM);
                        }
                        mmoPlayer.processAbilityActivation(PrimarySkillType.AXES);
                        mmoPlayer.processAbilityActivation(PrimarySkillType.EXCAVATION);
                        mmoPlayer.processAbilityActivation(PrimarySkillType.MINING);
                        mmoPlayer.processAbilityActivation(PrimarySkillType.SWORDS);
                        mmoPlayer.processAbilityActivation(PrimarySkillType.UNARMED);
                        mmoPlayer.processAbilityActivation(PrimarySkillType.WOODCUTTING);
                    }
                    ChimaeraWing.activationCheck(player);
                }
                HerbalismManager herbalismManager = mmoPlayer.getHerbalismManager();
                if (event.isCancelled() && event.useInteractedBlock() == Event.Result.DENY) break;
                if (heldItem.getType() == Material.BONE_MEAL) {
                    switch (blockState.getType().toString()) {
                        case "BEETROOTS": 
                        case "CARROT": 
                        case "COCOA": 
                        case "WHEAT": 
                        case "NETHER_WART_BLOCK": 
                        case "POTATO": 
                        case "MANGROVE_PROPAGULE": {
                            mcMMO.getUserBlockTracker().setEligible(blockState);
                        }
                    }
                }
                if (herbalismManager.canGreenThumbBlock(blockState)) {
                    if (EventUtils.callSubSkillBlockEvent(player, SubSkillType.HERBALISM_GREEN_THUMB, block).isCancelled()) break;
                    player.getInventory().getItemInMainHand().setAmount(heldItem.getAmount() - 1);
                    player.updateInventory();
                    if (!herbalismManager.processGreenThumbBlocks(blockState) || !EventUtils.simulateBlockBreak(block, player)) break;
                    blockState.update(true);
                    break;
                }
                if (herbalismManager.canUseShroomThumb(blockState)) {
                    if (EventUtils.callSubSkillBlockEvent(player, SubSkillType.HERBALISM_SHROOM_THUMB, block).isCancelled()) break;
                    event.setCancelled(true);
                    if (!herbalismManager.processShroomThumb(blockState) || !EventUtils.simulateBlockBreak(block, player)) break;
                    blockState.update(true);
                    break;
                }
                herbalismManager.processBerryBushHarvesting(blockState);
                break;
            }
            case RIGHT_CLICK_AIR: {
                if (player.getInventory().getItemInOffHand().getType() != Material.AIR && !player.isInsideVehicle() && !player.isSneaking()) break;
                if (mcMMO.p.getGeneralConfig().getAbilitiesEnabled()) {
                    mmoPlayer.processAbilityActivation(PrimarySkillType.AXES);
                    mmoPlayer.processAbilityActivation(PrimarySkillType.EXCAVATION);
                    mmoPlayer.processAbilityActivation(PrimarySkillType.HERBALISM);
                    mmoPlayer.processAbilityActivation(PrimarySkillType.MINING);
                    mmoPlayer.processAbilityActivation(PrimarySkillType.SWORDS);
                    mmoPlayer.processAbilityActivation(PrimarySkillType.UNARMED);
                    mmoPlayer.processAbilityActivation(PrimarySkillType.WOODCUTTING);
                }
                ChimaeraWing.activationCheck(player);
                MiningManager miningManager = mmoPlayer.getMiningManager();
                if (!miningManager.canDetonate()) break;
                miningManager.remoteDetonation();
                break;
            }
            case LEFT_CLICK_BLOCK: 
            case LEFT_CLICK_AIR: {
                if (!player.isSneaking()) break;
                Material type = heldItem.getType();
                TamingManager tamingManager = mmoPlayer.getTamingManager();
                if (type == mcMMO.p.getGeneralConfig().getTamingCOTWMaterial(CallOfTheWildType.WOLF.getConfigEntityTypeEntry())) {
                    tamingManager.summonWolf();
                    break;
                }
                if (type == mcMMO.p.getGeneralConfig().getTamingCOTWMaterial(CallOfTheWildType.CAT.getConfigEntityTypeEntry())) {
                    tamingManager.summonOcelot();
                    break;
                }
                if (type != mcMMO.p.getGeneralConfig().getTamingCOTWMaterial(CallOfTheWildType.HORSE.getConfigEntityTypeEntry())) break;
                tamingManager.summonHorse();
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (ExperienceConfig.getInstance().isNPCInteractionPrevented() && Misc.isNPCEntityExcludingVillagers((Entity)player) || !UserManager.hasPlayerDataKey((Entity)player)) {
            return;
        }
        McMMOPlayer mmoPlayer = UserManager.getOfflinePlayer((OfflinePlayer)player);
        if (mmoPlayer == null) {
            LogUtils.debug(mcMMO.p.getLogger(), player.getName() + "is chatting, but is currently not logged in to the server.");
            LogUtils.debug(mcMMO.p.getLogger(), "Party & Admin chat will not work properly for this player.");
            return;
        }
        if (this.plugin.getChatManager().isChatChannelEnabled(mmoPlayer.getChatChannel()) && mmoPlayer.getChatChannel() != ChatChannel.NONE) {
            if (this.plugin.getChatManager().isMessageAllowed(mmoPlayer)) {
                this.plugin.getChatManager().processPlayerMessage(mmoPlayer, event.getMessage(), event.isAsynchronous());
                event.setCancelled(true);
            } else {
                this.plugin.getChatManager().setOrToggleChatChannel(mmoPlayer, mmoPlayer.getChatChannel());
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (!mcMMO.p.getGeneralConfig().getLocale().equalsIgnoreCase("en_US")) {
            String message = event.getMessage();
            String command = message.substring(1).split(" ")[0];
            String lowerCaseCommand = command.toLowerCase(Locale.ENGLISH);
            for (PrimarySkillType skill : PrimarySkillType.values()) {
                String skillName = skill.toString().toLowerCase(Locale.ENGLISH);
                String localizedName = mcMMO.p.getSkillTools().getLocalizedSkillName(skill).toLowerCase(Locale.ENGLISH);
                if (lowerCaseCommand.equals(localizedName)) {
                    event.setMessage(message.replace(command, skillName));
                    break;
                }
                if (lowerCaseCommand.equals(skillName)) break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (entity instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)entity;
            if (frame.getItem().getType() != Material.AIR) {
                return;
            }
            ItemStack itemInHand = event.getHand() == EquipmentSlot.OFF_HAND ? event.getPlayer().getInventory().getItemInOffHand() : event.getPlayer().getInventory().getItemInMainHand();
            SkillUtils.removeAbilityBuff(itemInHand);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        SkillUtils.removeAbilityBuff(event.getMainHandItem());
        SkillUtils.removeAbilityBuff(event.getOffHandItem());
    }
}

