/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.player;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.commands.McRankCommandAsyncTask;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class McRankCommand
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        switch (args.length) {
            case 0: {
                if (CommandUtils.noConsoleUsage(sender)) {
                    return true;
                }
                if (!Permissions.mcrank((Permissible)sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (!CommandUtils.hasPlayerDataKey(sender)) {
                    return true;
                }
                this.display(sender, sender.getName());
                return true;
            }
            case 1: {
                if (!Permissions.mcrankOthers((Permissible)sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (!CommandUtils.hasPlayerDataKey(sender)) {
                    return true;
                }
                String playerName = CommandUtils.getMatchedPlayerName(args[0]);
                McMMOPlayer mmoPlayer = UserManager.getOfflinePlayer(playerName);
                if (mmoPlayer != null) {
                    Player player = mmoPlayer.getPlayer();
                    playerName = player.getName();
                    if (CommandUtils.tooFar(sender, player, Permissions.mcrankFar((Permissible)sender))) {
                        return true;
                    }
                }
                this.display(sender, playerName);
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            List<String> playerNames = CommandUtils.getOnlinePlayerNames(sender);
            return (List)StringUtil.copyPartialMatches((String)args[0], playerNames, new ArrayList(playerNames.size()));
        }
        return ImmutableList.of();
    }

    private void display(CommandSender sender, String playerName) {
        if (sender instanceof Player) {
            McMMOPlayer mmoPlayer = UserManager.getPlayer(sender.getName());
            if (mmoPlayer == null) {
                sender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
                return;
            }
            long cooldownMillis = Math.min(mcMMO.p.getGeneralConfig().getDatabasePlayerCooldown(), 1750L);
            if (mmoPlayer.getDatabaseATS() + cooldownMillis > System.currentTimeMillis()) {
                sender.sendMessage(LocaleLoader.getString("Commands.Database.CooldownMS", this.getCDSeconds(mmoPlayer, cooldownMillis)));
                return;
            }
            if (((Player)sender).hasMetadata("mcMMO: Processing Database Command")) {
                sender.sendMessage(LocaleLoader.getString("Commands.Database.Processing"));
                return;
            }
            ((Player)sender).setMetadata("mcMMO: Processing Database Command", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, null));
            mmoPlayer.actualizeDatabaseATS();
        }
        boolean useBoard = mcMMO.p.getGeneralConfig().getScoreboardsEnabled() && sender instanceof Player && mcMMO.p.getGeneralConfig().getRankUseBoard();
        boolean useChat = !useBoard || mcMMO.p.getGeneralConfig().getRankUseChat();
        mcMMO.p.getFoliaLib().getScheduler().runAsync(new McRankCommandAsyncTask(playerName, sender, useBoard, useChat));
    }

    private long getCDSeconds(McMMOPlayer mmoPlayer, long cooldownMillis) {
        return mmoPlayer.getDatabaseATS() + cooldownMillis - System.currentTimeMillis();
    }
}

