/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.unarmed;

import com.gmail.nossr50.api.ItemSpawnReason;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.unarmed.Unarmed;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class UnarmedManager
extends SkillManager {
    public UnarmedManager(McMMOPlayer mmoPlayer) {
        super(mmoPlayer, PrimarySkillType.UNARMED);
    }

    public boolean canActivateAbility() {
        return this.mmoPlayer.getToolPreparationMode(ToolType.FISTS) && Permissions.berserk((Permissible)this.getPlayer());
    }

    public boolean canUseSteelArm() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.UNARMED_STEEL_ARM_STYLE)) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.UNARMED_STEEL_ARM_STYLE);
    }

    public boolean canUseBerserk() {
        return this.mmoPlayer.getAbilityMode(SuperAbilityType.BERSERK);
    }

    public boolean canDisarm(LivingEntity target) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.UNARMED_DISARM)) {
            return false;
        }
        return target instanceof Player && ((Player)target).getInventory().getItemInMainHand().getType() != Material.AIR && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.UNARMED_DISARM);
    }

    public boolean canDeflect() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.UNARMED_ARROW_DEFLECT)) {
            return false;
        }
        Player player = this.getPlayer();
        return ItemUtils.isUnarmed(player.getInventory().getItemInMainHand()) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.UNARMED_ARROW_DEFLECT);
    }

    public boolean canUseBlockCracker() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.UNARMED_BLOCK_CRACKER)) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.UNARMED_BLOCK_CRACKER);
    }

    public void blockCrackerCheck(@NotNull Block block) {
        if (!ProbabilityUtil.isNonRNGSkillActivationSuccessful(SubSkillType.UNARMED_BLOCK_CRACKER, this.mmoPlayer)) {
            return;
        }
        switch (block.getType()) {
            case STONE_BRICKS: {
                if (!Unarmed.blockCrackerSmoothBrick) {
                    return;
                }
                block.setType(Material.CRACKED_STONE_BRICKS);
                return;
            }
            case INFESTED_STONE_BRICKS: {
                if (!Unarmed.blockCrackerSmoothBrick) {
                    return;
                }
                block.setType(Material.INFESTED_CRACKED_STONE_BRICKS);
                return;
            }
        }
    }

    public void disarmCheck(@NotNull Player defender) {
        if (ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.UNARMED_DISARM, this.mmoPlayer, this.mmoPlayer.getAttackStrength()) && !this.hasIronGrip(defender)) {
            if (EventUtils.callDisarmEvent(defender).isCancelled()) {
                return;
            }
            if (UserManager.getPlayer(defender) == null) {
                return;
            }
            Item item = ItemUtils.spawnItem(this.getPlayer(), defender.getLocation(), defender.getInventory().getItemInMainHand(), ItemSpawnReason.UNARMED_DISARMED_ITEM);
            if (item != null && mcMMO.p.getAdvancedConfig().getDisarmProtected()) {
                item.setMetadata("mcMMO: Disarmed Item", (MetadataValue)UserManager.getPlayer(defender).getPlayerMetadata());
            }
            defender.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
            NotificationManager.sendPlayerInformation(defender, NotificationType.SUBSKILL_MESSAGE, "Skills.Disarmed");
        }
    }

    public boolean deflectCheck() {
        if (ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.UNARMED_ARROW_DEFLECT, this.mmoPlayer)) {
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE, "Combat.ArrowDeflect");
            return true;
        }
        return false;
    }

    public double berserkDamage(double damage) {
        damage = damage * Unarmed.berserkDamageModifier * this.mmoPlayer.getAttackStrength() - damage;
        return damage;
    }

    public double calculateSteelArmStyleDamage() {
        if (ProbabilityUtil.isNonRNGSkillActivationSuccessful(SubSkillType.UNARMED_STEEL_ARM_STYLE, this.mmoPlayer)) {
            return this.getSteelArmStyleDamage();
        }
        return 0.0;
    }

    public double getSteelArmStyleDamage() {
        double rank = RankUtils.getRank(this.getPlayer(), SubSkillType.UNARMED_STEEL_ARM_STYLE);
        double bonus = 0.0;
        if (rank >= 18.0) {
            bonus = 1.0 + rank - 18.0;
        }
        double finalBonus = bonus + 0.5 + rank / 2.0;
        if (mcMMO.p.getAdvancedConfig().isSteelArmDamageCustom()) {
            return mcMMO.p.getAdvancedConfig().getSteelArmOverride(RankUtils.getRank(this.getPlayer(), SubSkillType.UNARMED_STEEL_ARM_STYLE), finalBonus);
        }
        return finalBonus;
    }

    private boolean hasIronGrip(@NotNull Player defender) {
        if (!Misc.isNPCEntityExcludingVillagers((Entity)defender) && Permissions.isSubSkillEnabled((Permissible)defender, SubSkillType.UNARMED_IRON_GRIP) && ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.UNARMED_IRON_GRIP, UserManager.getPlayer(defender))) {
            NotificationManager.sendPlayerInformation(defender, NotificationType.SUBSKILL_MESSAGE, "Unarmed.Ability.IronGrip.Defender");
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE, "Unarmed.Ability.IronGrip.Attacker");
            return true;
        }
        return false;
    }
}

