/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.placeholders;

import com.gmail.nossr50.api.ExperienceAPI;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.placeholders.PartyIsLeaderPlaceholder;
import com.gmail.nossr50.placeholders.PartyIsMemberPlaceholder;
import com.gmail.nossr50.placeholders.PartyLeaderPlaceholder;
import com.gmail.nossr50.placeholders.PartyNamePlaceholder;
import com.gmail.nossr50.placeholders.PartySizePlaceholder;
import com.gmail.nossr50.placeholders.Placeholder;
import com.gmail.nossr50.placeholders.PowerLevelCapPlaceholder;
import com.gmail.nossr50.placeholders.PowerLevelPlaceholder;
import com.gmail.nossr50.placeholders.SkillExpNeededPlaceholder;
import com.gmail.nossr50.placeholders.SkillExpPlaceholder;
import com.gmail.nossr50.placeholders.SkillExpRemainingPlaceholder;
import com.gmail.nossr50.placeholders.SkillLevelPlaceholder;
import com.gmail.nossr50.placeholders.SkillRankPlaceholder;
import com.gmail.nossr50.placeholders.SkillXpRatePlaceholder;
import com.gmail.nossr50.placeholders.XpEventActivePlaceholder;
import com.gmail.nossr50.placeholders.XpRatePlaceholder;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.text.StringUtils;
import java.util.Map;
import java.util.TreeMap;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PapiExpansion
extends PlaceholderExpansion {
    private final Map<String, Placeholder> placeholders = new TreeMap<String, Placeholder>(String.CASE_INSENSITIVE_ORDER);

    public PapiExpansion() {
        this.init();
    }

    public String getIdentifier() {
        return "mcmmo";
    }

    public String getAuthor() {
        return "mcMMO Dev Team";
    }

    public String getVersion() {
        return "1.0,0";
    }

    public boolean persist() {
        return true;
    }

    public String getRequiredPlugin() {
        return "mcMMO";
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String params) {
        String token;
        String data = null;
        int dataPosition = params.indexOf(":");
        if (dataPosition != -1) {
            token = params.substring(0, dataPosition);
            data = params.substring(dataPosition + 1);
        } else {
            token = params;
        }
        Placeholder placeholder = this.placeholders.get(token);
        if (placeholder != null) {
            return placeholder.process(player, data);
        }
        return null;
    }

    public Integer getSkillLevel(PrimarySkillType skill, Player player) {
        McMMOPlayer user = UserManager.getPlayer(player);
        if (user == null) {
            return null;
        }
        return user.getSkillLevel(skill);
    }

    public Integer getExpNeeded(PrimarySkillType skill, Player player) {
        McMMOPlayer user = UserManager.getPlayer(player);
        if (user == null) {
            return null;
        }
        return user.getXpToLevel(skill);
    }

    public Integer getExp(PrimarySkillType skill, Player player) {
        McMMOPlayer user = UserManager.getPlayer(player);
        if (user == null) {
            return null;
        }
        return user.getSkillXpLevel(skill);
    }

    public Integer getExpRemaining(PrimarySkillType skill, Player player) {
        McMMOPlayer user = UserManager.getPlayer(player);
        if (user == null) {
            return null;
        }
        int current = user.getSkillXpLevel(skill);
        int needed = user.getXpToLevel(skill);
        return needed - current;
    }

    public Integer getRank(PrimarySkillType skill, Player player) {
        try {
            return ExperienceAPI.getPlayerRankSkill(player.getUniqueId(), StringUtils.getCapitalized(skill.toString()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Integer getPowerLevel(Player player) {
        McMMOPlayer user = UserManager.getPlayer(player);
        if (user == null) {
            return null;
        }
        return user.getPowerLevel();
    }

    public Integer getPowerCap(Player player) {
        return mcMMO.p.getGeneralConfig().getPowerLevelCap();
    }

    public String getPartyName(Player player) {
        McMMOPlayer user = UserManager.getPlayer(player);
        if (user == null) {
            return null;
        }
        Party party = user.getParty();
        return party == null ? null : party.getName();
    }

    public String getPartyLeader(Player player) {
        McMMOPlayer user = UserManager.getPlayer(player);
        if (user == null) {
            return null;
        }
        Party party = user.getParty();
        return party == null ? null : party.getLeader().getPlayerName();
    }

    public Integer getPartySize(Player player) {
        McMMOPlayer user = UserManager.getPlayer(player);
        if (user == null) {
            return null;
        }
        Party party = user.getParty();
        return party == null ? null : Integer.valueOf(party.getMembers().size());
    }

    public String getXpRate(Player player) {
        return String.valueOf(ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier());
    }

    public String getSkillXpRate(PrimarySkillType skill, Player player) {
        McMMOPlayer user = UserManager.getPlayer(player);
        if (user == null) {
            return null;
        }
        double modifier = 1.0;
        if (Permissions.customXpBoost((Permissible)player, skill)) {
            modifier = ExperienceConfig.getInstance().getCustomXpPerkBoost();
        } else if (Permissions.quadrupleXp((Permissible)player, skill)) {
            modifier = 4.0;
        } else if (Permissions.tripleXp((Permissible)player, skill)) {
            modifier = 3.0;
        } else if (Permissions.doubleAndOneHalfXp((Permissible)player, skill)) {
            modifier = 2.5;
        } else if (Permissions.doubleXp((Permissible)player, skill)) {
            modifier = 2.0;
        } else if (Permissions.oneAndOneHalfXp((Permissible)player, skill)) {
            modifier = 1.5;
        } else if (Permissions.oneAndOneTenthXp((Permissible)player, skill)) {
            modifier = 1.1;
        }
        return String.valueOf(modifier);
    }

    public String isExpEventActive(Player player) {
        return mcMMO.p.isXPEventEnabled() ? PlaceholderAPIPlugin.booleanTrue() : PlaceholderAPIPlugin.booleanFalse();
    }

    public void registerPlaceholder(Placeholder placeholder) {
        Placeholder registered = this.placeholders.get(placeholder.getName());
        if (registered != null) {
            throw new IllegalStateException("Placeholder " + placeholder.getName() + " is already registered!");
        }
        this.placeholders.put(placeholder.getName(), placeholder);
    }

    protected void init() {
        for (PrimarySkillType skill : PrimarySkillType.values()) {
            this.registerPlaceholder(new SkillLevelPlaceholder(this, skill));
            this.registerPlaceholder(new SkillExpNeededPlaceholder(this, skill));
            this.registerPlaceholder(new SkillExpPlaceholder(this, skill));
            this.registerPlaceholder(new SkillExpRemainingPlaceholder(this, skill));
            this.registerPlaceholder(new SkillRankPlaceholder(this, skill));
            this.registerPlaceholder(new SkillXpRatePlaceholder(this, skill));
        }
        this.registerPlaceholder(new PowerLevelPlaceholder(this));
        this.registerPlaceholder(new PowerLevelCapPlaceholder(this));
        this.registerPlaceholder(new PartyIsMemberPlaceholder(this));
        this.registerPlaceholder(new PartyNamePlaceholder(this));
        this.registerPlaceholder(new PartyIsLeaderPlaceholder(this));
        this.registerPlaceholder(new PartyLeaderPlaceholder(this));
        this.registerPlaceholder(new PartySizePlaceholder(this));
        this.registerPlaceholder(new XpEventActivePlaceholder(this));
        this.registerPlaceholder(new XpRatePlaceholder(this));
    }
}

