/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.items;

import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.CancellableRunnable;
import com.gmail.nossr50.util.ChimaeraWing;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ChimaeraWingWarmup
extends CancellableRunnable {
    private final McMMOPlayer mmoPlayer;
    private final Location location;

    public ChimaeraWingWarmup(McMMOPlayer mmoPlayer, Location location) {
        this.mmoPlayer = mmoPlayer;
        this.location = location;
    }

    @Override
    public void run() {
        this.checkChimaeraWingTeleport();
    }

    private void checkChimaeraWingTeleport() {
        int timeRemaining;
        Player player = this.mmoPlayer.getPlayer();
        Location previousLocation = this.mmoPlayer.getTeleportCommenceLocation();
        if (player.getLocation().distanceSquared(previousLocation) > 1.0 || !player.getInventory().containsAtLeast(ChimaeraWing.getChimaeraWing(1), 1)) {
            player.sendMessage(LocaleLoader.getString("Teleport.Cancelled"));
            this.mmoPlayer.setTeleportCommenceLocation(null);
            return;
        }
        ItemStack inHand = player.getInventory().getItemInMainHand();
        if (!ItemUtils.isChimaeraWing(inHand) || inHand.getAmount() < mcMMO.p.getGeneralConfig().getChimaeraUseCost()) {
            player.sendMessage(LocaleLoader.getString("Skills.NeedMore", LocaleLoader.getString("Item.ChimaeraWing.Name")));
            return;
        }
        long recentlyHurt = this.mmoPlayer.getRecentlyHurt();
        int hurtCooldown = mcMMO.p.getGeneralConfig().getChimaeraRecentlyHurtCooldown();
        if (hurtCooldown > 0 && (timeRemaining = SkillUtils.calculateTimeLeft(recentlyHurt * 1000L, hurtCooldown, player)) > 0) {
            player.sendMessage(LocaleLoader.getString("Item.Injured.Wait", timeRemaining));
            return;
        }
        this.chimaeraExecuteTeleport();
    }

    private void chimaeraExecuteTeleport() {
        Player player = this.mmoPlayer.getPlayer();
        if (mcMMO.p.getGeneralConfig().getChimaeraUseBedSpawn() && player.getBedSpawnLocation() != null) {
            mcMMO.p.getFoliaLib().getScheduler().teleportAsync((Entity)player, player.getBedSpawnLocation());
        } else {
            Location spawnLocation = player.getWorld().getSpawnLocation();
            if (spawnLocation.getBlock().getType() == Material.AIR) {
                mcMMO.p.getFoliaLib().getScheduler().teleportAsync((Entity)player, spawnLocation);
            } else {
                mcMMO.p.getFoliaLib().getScheduler().teleportAsync((Entity)player, player.getWorld().getHighestBlockAt(spawnLocation).getLocation());
            }
        }
        ChimaeraWing.expendChimaeraWing(player, mcMMO.p.getGeneralConfig().getChimaeraUseCost(), player.getInventory().getItemInMainHand());
        this.mmoPlayer.actualizeChimeraWingLastUse();
        this.mmoPlayer.setTeleportCommenceLocation(null);
        if (mcMMO.p.getGeneralConfig().getChimaeraSoundEnabled()) {
            SoundManager.sendSound(player, this.location, SoundType.CHIMAERA_WING);
        }
        NotificationManager.sendPlayerInformation(player, NotificationType.ITEM_MESSAGE, "Item.ChimaeraWing.Pass");
    }
}

