/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;

public class MaterialMapStore {
    @NotNull
    private final HashSet<String> abilityBlackList = new HashSet();
    @NotNull
    private final HashSet<String> toolBlackList = new HashSet();
    @NotNull
    private final HashSet<String> mossyWhiteList = new HashSet();
    @NotNull
    private final HashSet<String> treeFellerDestructibleWhiteList = new HashSet();
    @NotNull
    private final HashSet<String> herbalismAbilityBlackList = new HashSet();
    @NotNull
    private final HashSet<String> blockCrackerWhiteList = new HashSet();
    @NotNull
    private final HashSet<String> canMakeShroomyWhiteList = new HashSet();
    @NotNull
    private final HashSet<String> multiBlockPlant = new HashSet();
    @NotNull
    private final HashSet<String> multiBlockHangingPlant = new HashSet();
    @NotNull
    private final HashSet<String> foodItemWhiteList = new HashSet();
    @NotNull
    private final HashSet<String> glassBlocks = new HashSet();
    @NotNull
    private final HashSet<String> netheriteArmor;
    @NotNull
    private final HashSet<String> netheriteTools;
    @NotNull
    private final HashSet<String> woodTools;
    @NotNull
    private final HashSet<String> stoneTools;
    @NotNull
    private final HashSet<String> leatherArmor = new HashSet();
    @NotNull
    private final HashSet<String> copperTools;
    @NotNull
    private final HashSet<String> copperArmor;
    @NotNull
    private final HashSet<String> ironArmor = new HashSet();
    @NotNull
    private final HashSet<String> ironTools;
    @NotNull
    private final HashSet<String> stringTools;
    @NotNull
    private final HashSet<String> prismarineTools;
    @NotNull
    private final HashSet<String> goldArmor;
    @NotNull
    private final HashSet<String> goldTools;
    @NotNull
    private final HashSet<String> chainmailArmor;
    @NotNull
    private final HashSet<String> diamondArmor;
    @NotNull
    private final HashSet<String> diamondTools;
    @NotNull
    private final HashSet<String> armors;
    @NotNull
    private final HashSet<String> swords;
    @NotNull
    private final HashSet<String> axes;
    @NotNull
    private final HashSet<String> hoes;
    @NotNull
    private final HashSet<String> shovels;
    @NotNull
    private final HashSet<String> pickAxes;
    @NotNull
    private final HashSet<String> tridents;
    @NotNull
    private final HashSet<String> bows;
    @NotNull
    private final HashSet<String> crossbows;
    @NotNull
    private final HashSet<String> tools;
    @NotNull
    private final HashSet<String> enchantables;
    @NotNull
    private final HashSet<String> maces;
    @NotNull
    private final HashSet<String> ores;
    @NotNull
    private final HashSet<String> intendedToolPickAxe;
    @NotNull
    private final HashSet<String> intendedToolShovel;
    @NotNull
    private final HashMap<String, Integer> tierValue;

    public MaterialMapStore() {
        this.copperArmor = new HashSet();
        this.chainmailArmor = new HashSet();
        this.goldArmor = new HashSet();
        this.diamondArmor = new HashSet();
        this.netheriteArmor = new HashSet();
        this.armors = new HashSet();
        this.woodTools = new HashSet();
        this.stoneTools = new HashSet();
        this.copperTools = new HashSet();
        this.ironTools = new HashSet();
        this.goldTools = new HashSet();
        this.diamondTools = new HashSet();
        this.netheriteTools = new HashSet();
        this.bows = new HashSet();
        this.crossbows = new HashSet();
        this.stringTools = new HashSet();
        this.prismarineTools = new HashSet();
        this.tools = new HashSet();
        this.swords = new HashSet();
        this.axes = new HashSet();
        this.pickAxes = new HashSet();
        this.shovels = new HashSet();
        this.hoes = new HashSet();
        this.tridents = new HashSet();
        this.maces = new HashSet();
        this.enchantables = new HashSet();
        this.ores = new HashSet();
        this.intendedToolPickAxe = new HashSet();
        this.intendedToolShovel = new HashSet();
        this.tierValue = new HashMap();
        this.fillVanillaMaterialRegisters();
    }

    private void fillVanillaMaterialRegisters() {
        this.fillAbilityBlackList();
        this.fillToolBlackList();
        this.fillMossyWhiteList();
        this.fillTreeFellerDestructibleWhiteList();
        this.fillHerbalismAbilityBlackList();
        this.fillBlockCrackerWhiteList();
        this.fillShroomyWhiteList();
        this.fillMultiBlockPlantSet();
        this.fillMultiBlockHangingPlantSet();
        this.fillFoodWhiteList();
        this.fillGlassBlockWhiteList();
        this.fillArmors();
        this.fillTools();
        this.fillEnchantables();
        this.fillOres();
        this.fillIntendedTools();
        this.fillTierMap();
    }

    public boolean isMultiBlockPlant(@NotNull Material material) {
        return this.multiBlockPlant.contains(material.getKey().getKey());
    }

    public boolean isMultiBlockHangingPlant(@NotNull Material material) {
        return this.multiBlockHangingPlant.contains(material.getKey().getKey());
    }

    public boolean isAbilityActivationBlackListed(@NotNull Material material) {
        return this.abilityBlackList.contains(material.getKey().getKey());
    }

    public boolean isToolActivationBlackListed(@NotNull Material material) {
        return this.toolBlackList.contains(material.getKey().getKey());
    }

    public boolean isMossyWhiteListed(@NotNull Material material) {
        return this.mossyWhiteList.contains(material.getKey().getKey());
    }

    public boolean isTreeFellerDestructible(@NotNull Material material) {
        return this.treeFellerDestructibleWhiteList.contains(material.getKey().getKey());
    }

    public boolean isHerbalismAbilityWhiteListed(@NotNull Material material) {
        return this.herbalismAbilityBlackList.contains(material.getKey().getKey());
    }

    public boolean isBlockCrackerWhiteListed(@NotNull Material material) {
        return this.blockCrackerWhiteList.contains(material.getKey().getKey());
    }

    public boolean isShroomyWhiteListed(@NotNull Material material) {
        return this.canMakeShroomyWhiteList.contains(material.getKey().getKey());
    }

    private void fillTierMap() {
        for (String id : this.leatherArmor) {
            this.tierValue.put(id, 1);
        }
        for (String id : this.copperArmor) {
            this.tierValue.put(id, 1);
        }
        for (String id : this.ironArmor) {
            this.tierValue.put(id, 2);
        }
        for (String id : this.goldArmor) {
            this.tierValue.put(id, 3);
        }
        for (String id : this.chainmailArmor) {
            this.tierValue.put(id, 3);
        }
        for (String id : this.diamondArmor) {
            this.tierValue.put(id, 6);
        }
        for (String id : this.netheriteArmor) {
            this.tierValue.put(id, 12);
        }
    }

    private void fillOres() {
        this.ores.add("coal_ore");
        this.ores.add("diamond_ore");
        this.ores.add("nether_quartz_ore");
        this.ores.add("quartz_ore");
        this.ores.add("gold_ore");
        this.ores.add("iron_ore");
        this.ores.add("lapis_ore");
        this.ores.add("lapis_lazuli_ore");
        this.ores.add("redstone_ore");
        this.ores.add("emerald_ore");
        this.ores.add("ancient_debris");
        this.ores.add("nether_gold_ore");
        this.ores.add("gilded_blackstone");
        this.ores.add("deepslate_redstone_ore");
        this.ores.add("deepslate_copper_ore");
        this.ores.add("deepslate_coal_ore");
        this.ores.add("deepslate_diamond_ore");
        this.ores.add("deepslate_emerald_ore");
        this.ores.add("deepslate_iron_ore");
        this.ores.add("deepslate_gold_ore");
        this.ores.add("deepslate_lapis_ore");
        this.ores.add("copper_ore");
    }

    private void fillIntendedTools() {
        this.intendedToolPickAxe.addAll(this.ores);
        this.intendedToolPickAxe.add("lapis_lazuli_ore");
        this.intendedToolPickAxe.add("packed_mud");
        this.intendedToolPickAxe.add("mud_bricks");
        this.intendedToolPickAxe.add("reinforced_deepslate");
        this.intendedToolPickAxe.add("ice");
        this.intendedToolPickAxe.add("packed_ice");
        this.intendedToolPickAxe.add("blue_ice");
        this.intendedToolPickAxe.add("frosted_ice");
        this.intendedToolPickAxe.add("anvil");
        this.intendedToolPickAxe.add("bell");
        this.intendedToolPickAxe.add("block_of_redstone");
        this.intendedToolPickAxe.add("brewing_stand");
        this.intendedToolPickAxe.add("cauldron");
        this.intendedToolPickAxe.add("chain");
        this.intendedToolPickAxe.add("hopper");
        this.intendedToolPickAxe.add("iron_bars");
        this.intendedToolPickAxe.add("iron_door");
        this.intendedToolPickAxe.add("iron_trapdoor");
        this.intendedToolPickAxe.add("lantern");
        this.intendedToolPickAxe.add("weighted_pressure_plates");
        this.intendedToolPickAxe.add("block_of_iron");
        this.intendedToolPickAxe.add("copper_blocks");
        this.intendedToolPickAxe.add("cut_copper");
        this.intendedToolPickAxe.add("cut_copper_slab");
        this.intendedToolPickAxe.add("cut_copper_stairs");
        this.intendedToolPickAxe.add("lapis_lazuli_block");
        this.intendedToolPickAxe.add("lightning_rod");
        this.intendedToolPickAxe.add("block_of_diamond");
        this.intendedToolPickAxe.add("block_of_emerald");
        this.intendedToolPickAxe.add("block_of_gold");
        this.intendedToolPickAxe.add("block_of_netherite");
        this.intendedToolPickAxe.add("piston");
        this.intendedToolPickAxe.add("sticky_piston");
        this.intendedToolPickAxe.add("conduit");
        this.intendedToolPickAxe.add("shulker_box");
        this.intendedToolPickAxe.add("element_constructor");
        this.intendedToolPickAxe.add("compound_creator");
        this.intendedToolPickAxe.add("material_reducer");
        this.intendedToolPickAxe.add("activator_rail");
        this.intendedToolPickAxe.add("detector_rail");
        this.intendedToolPickAxe.add("powered_rail");
        this.intendedToolPickAxe.add("rail");
        this.intendedToolPickAxe.add("andesite");
        this.intendedToolPickAxe.add("basalt");
        this.intendedToolPickAxe.add("blackstone");
        this.intendedToolPickAxe.add("blast_furnace");
        this.intendedToolPickAxe.add("block_of_coal");
        this.intendedToolPickAxe.add("block_of_quartz");
        this.intendedToolPickAxe.add("bricks");
        this.intendedToolPickAxe.add("cobblestone");
        this.intendedToolPickAxe.add("cobblestone_wall");
        this.intendedToolPickAxe.add("concrete");
        this.intendedToolPickAxe.add("dark_prismarine");
        this.intendedToolPickAxe.add("diorite");
        this.intendedToolPickAxe.add("dispenser");
        this.intendedToolPickAxe.add("dripstone_block");
        this.intendedToolPickAxe.add("dropper");
        this.intendedToolPickAxe.add("enchantment_table");
        this.intendedToolPickAxe.add("end_stone");
        this.intendedToolPickAxe.add("ender_chest");
        this.intendedToolPickAxe.add("furnace");
        this.intendedToolPickAxe.add("glazed_terracotta");
        this.intendedToolPickAxe.add("granite");
        this.intendedToolPickAxe.add("grindstone");
        this.intendedToolPickAxe.add("heat_block");
        this.intendedToolPickAxe.add("lodestone");
        this.intendedToolPickAxe.add("mossy_cobblestone");
        this.intendedToolPickAxe.add("nether_bricks");
        this.intendedToolPickAxe.add("nether_brick_fence");
        this.intendedToolPickAxe.add("nether_gold_ore");
        this.intendedToolPickAxe.add("nether_quartz_ore");
        this.intendedToolPickAxe.add("netherrack");
        this.intendedToolPickAxe.add("observer");
        this.intendedToolPickAxe.add("prismarine");
        this.intendedToolPickAxe.add("prismarine_bricks");
        this.intendedToolPickAxe.add("pointed_dripstone");
        this.intendedToolPickAxe.add("polished_andesite");
        this.intendedToolPickAxe.add("polished_blackstone");
        this.intendedToolPickAxe.add("polished_blackstone_bricks");
        this.intendedToolPickAxe.add("polished_diorite");
        this.intendedToolPickAxe.add("polished_granite");
        this.intendedToolPickAxe.add("red_sandstone");
        this.intendedToolPickAxe.add("sandstone");
        this.intendedToolPickAxe.add("smoker");
        this.intendedToolPickAxe.add("spawner");
        this.intendedToolPickAxe.add("stonecutter");
        this.intendedToolPickAxe.add("colored_terracotta");
        this.intendedToolPickAxe.add("smooth_stone");
        this.intendedToolPickAxe.add("stone");
        this.intendedToolPickAxe.add("stone_bricks");
        this.intendedToolPickAxe.add("stone_button");
        this.intendedToolPickAxe.add("stone_pressure_plate");
        this.intendedToolPickAxe.add("terracotta");
        this.intendedToolPickAxe.add("ancient_debris");
        this.intendedToolPickAxe.add("crying_obsidian");
        this.intendedToolPickAxe.add("glowing_obsidian");
        this.intendedToolPickAxe.add("obsidian");
        this.intendedToolPickAxe.add("respawn_anchor");
        this.intendedToolPickAxe.add("petrified_oak_slab");
        this.intendedToolPickAxe.add("stone_slab");
        this.intendedToolPickAxe.add("smooth_stone_slab");
        this.intendedToolPickAxe.add("cobblestone_slab");
        this.intendedToolPickAxe.add("mossy_cobblestone_slab");
        this.intendedToolPickAxe.add("stone_brick_slab");
        this.intendedToolPickAxe.add("mossy_stone_brick_slab");
        this.intendedToolPickAxe.add("andesite_slab");
        this.intendedToolPickAxe.add("polished_andesite_slab");
        this.intendedToolPickAxe.add("diorite_slab");
        this.intendedToolPickAxe.add("polished_diorite_slab");
        this.intendedToolPickAxe.add("granite_slab");
        this.intendedToolPickAxe.add("polished_granite_slab");
        this.intendedToolPickAxe.add("sandstone_slab");
        this.intendedToolPickAxe.add("cut_sandstone_slab");
        this.intendedToolPickAxe.add("smooth_sandstone_slab");
        this.intendedToolPickAxe.add("red_sandstone_slab");
        this.intendedToolPickAxe.add("cut_red_sandstone_slab");
        this.intendedToolPickAxe.add("smooth_red_sandstone_slab");
        this.intendedToolPickAxe.add("brick_slab");
        this.intendedToolPickAxe.add("prismarine_brick_slab");
        this.intendedToolPickAxe.add("dark_prismarine_slab");
        this.intendedToolPickAxe.add("nether_brick_slab");
        this.intendedToolPickAxe.add("red_netherbrick_slab");
        this.intendedToolPickAxe.add("quartz_slab");
        this.intendedToolPickAxe.add("smooth_quartz_slab");
        this.intendedToolPickAxe.add("purpur_slab");
        this.intendedToolPickAxe.add("end_stone_brick_slab");
        this.intendedToolPickAxe.add("blackstone_slab");
        this.intendedToolPickAxe.add("polished_blackstone_slab");
        this.intendedToolPickAxe.add("polished_blackstone_brick_slab");
        this.intendedToolPickAxe.add("lightly_weathered_cut_copper_slab");
        this.intendedToolPickAxe.add("semi_weathered_cut_copper_slab");
        this.intendedToolPickAxe.add("waxed_semi_weathered_cut_copper_slab");
        this.intendedToolPickAxe.add("weathered_cut_copper_slab");
        this.intendedToolPickAxe.add("waxed_cut_copper_slab");
        this.intendedToolPickAxe.add("waxed_lightly_weathered_cut_copper_slab");
        this.intendedToolPickAxe.add("petrified_oak_stairs");
        this.intendedToolPickAxe.add("stone_stairs");
        this.intendedToolPickAxe.add("smooth_stone_stairs");
        this.intendedToolPickAxe.add("cobblestone_stairs");
        this.intendedToolPickAxe.add("mossy_cobblestone_stairs");
        this.intendedToolPickAxe.add("stone_brick_stairs");
        this.intendedToolPickAxe.add("mossy_stone_brick_stairs");
        this.intendedToolPickAxe.add("andesite_stairs");
        this.intendedToolPickAxe.add("polished_andesite_stairs");
        this.intendedToolPickAxe.add("diorite_stairs");
        this.intendedToolPickAxe.add("polished_diorite_stairs");
        this.intendedToolPickAxe.add("granite_stairs");
        this.intendedToolPickAxe.add("polished_granite_stairs");
        this.intendedToolPickAxe.add("sandstone_stairs");
        this.intendedToolPickAxe.add("cut_sandstone_stairs");
        this.intendedToolPickAxe.add("smooth_sandstone_stairs");
        this.intendedToolPickAxe.add("red_sandstone_stairs");
        this.intendedToolPickAxe.add("cut_red_sandstone_stairs");
        this.intendedToolPickAxe.add("smooth_red_sandstone_stairs");
        this.intendedToolPickAxe.add("brick_stairs");
        this.intendedToolPickAxe.add("prismarine_brick_stairs");
        this.intendedToolPickAxe.add("dark_prismarine_stairs");
        this.intendedToolPickAxe.add("nether_brick_stairs");
        this.intendedToolPickAxe.add("red_netherbrick_stairs");
        this.intendedToolPickAxe.add("quartz_stairs");
        this.intendedToolPickAxe.add("smooth_quartz_stairs");
        this.intendedToolPickAxe.add("purpur_stairs");
        this.intendedToolPickAxe.add("end_stone_brick_stairs");
        this.intendedToolPickAxe.add("blackstone_stairs");
        this.intendedToolPickAxe.add("polished_blackstone_stairs");
        this.intendedToolPickAxe.add("polished_blackstone_brick_stairs");
        this.intendedToolPickAxe.add("lightly_weathered_cut_copper_stairs");
        this.intendedToolPickAxe.add("semi_weathered_cut_copper_stairs");
        this.intendedToolPickAxe.add("waxed_semi_weathered_cut_copper_stairs");
        this.intendedToolPickAxe.add("weathered_cut_copper_stairs");
        this.intendedToolPickAxe.add("waxed_cut_copper_stairs");
        this.intendedToolPickAxe.add("waxed_lightly_weathered_cut_copper_stairs");
        this.intendedToolPickAxe.add("calcite");
        this.intendedToolPickAxe.add("smooth_basalt");
        this.intendedToolPickAxe.add("block_of_amethyst");
        this.intendedToolPickAxe.add("small_amethyst_bud");
        this.intendedToolPickAxe.add("medium_amethyst_bud");
        this.intendedToolPickAxe.add("large_amethyst_bud");
        this.intendedToolPickAxe.add("amethyst_cluster");
        this.intendedToolPickAxe.add("budding_amethyst");
        this.intendedToolPickAxe.add("deepslate");
        this.intendedToolPickAxe.add("cobbled_deepslate");
        this.intendedToolPickAxe.add("tuff");
    }

    private void fillArmors() {
        this.fillLeatherArmorWhiteList();
        this.fillCopperArmorWhiteList();
        this.fillIronArmorWhiteList();
        this.fillChainmailWhiteList();
        this.fillGoldArmorWhiteList();
        this.fillDiamondArmorWhiteList();
        this.fillnetheriteArmorWhiteList();
        this.armors.addAll(this.leatherArmor);
        this.armors.addAll(this.copperArmor);
        this.armors.addAll(this.ironArmor);
        this.armors.addAll(this.chainmailArmor);
        this.armors.addAll(this.goldArmor);
        this.armors.addAll(this.diamondArmor);
        this.armors.addAll(this.netheriteArmor);
        this.armors.add("turtle_shell");
    }

    private void fillEnchantables() {
        this.enchantables.addAll(this.armors);
        this.enchantables.addAll(this.swords);
        this.enchantables.addAll(this.axes);
        this.enchantables.addAll(this.hoes);
        this.enchantables.addAll(this.pickAxes);
        this.enchantables.addAll(this.tridents);
        this.enchantables.addAll(this.bows);
        this.enchantables.addAll(this.crossbows);
        this.enchantables.addAll(this.maces);
        this.enchantables.add("shears");
        this.enchantables.add("fishing_rod");
        this.enchantables.add("carrot_on_a_stick");
        this.enchantables.add("enchanted_book");
        this.enchantables.add("flint_and_steel");
        this.enchantables.add("turtle_shell");
    }

    private void fillTools() {
        this.fillWoodToolsWhiteList();
        this.fillStoneToolsWhiteList();
        this.fillCopperToolsWhiteList();
        this.fillIronToolsWhiteList();
        this.fillGoldToolsWhiteList();
        this.fillDiamondToolsWhiteList();
        this.fillNetheriteToolsWhiteList();
        this.fillSwords();
        this.fillAxes();
        this.fillPickAxes();
        this.fillHoes();
        this.fillShovels();
        this.fillTridents();
        this.fillMaces();
        this.fillStringTools();
        this.fillPrismarineTools();
        this.fillBows();
        this.fillCrossbows();
        this.tools.addAll(this.woodTools);
        this.tools.addAll(this.stoneTools);
        this.tools.addAll(this.copperTools);
        this.tools.addAll(this.ironTools);
        this.tools.addAll(this.goldTools);
        this.tools.addAll(this.diamondTools);
        this.tools.addAll(this.netheriteTools);
        this.tools.addAll(this.tridents);
        this.tools.addAll(this.stringTools);
        this.tools.addAll(this.bows);
        this.tools.addAll(this.crossbows);
        this.tools.addAll(this.maces);
    }

    private void fillBows() {
        this.bows.add("bow");
    }

    private void fillCrossbows() {
        this.crossbows.add("crossbow");
    }

    private void fillStringTools() {
        this.stringTools.add("bow");
        this.stringTools.add("fishing_rod");
        this.stringTools.add("carrot_on_a_stick");
        this.stringTools.add("crossbow");
    }

    private void fillPrismarineTools() {
        this.prismarineTools.add("trident");
    }

    private void fillMaces() {
        this.maces.add("mace");
    }

    private void fillTridents() {
        this.tridents.add("trident");
    }

    private void fillSwords() {
        this.swords.add("wood_sword");
        this.swords.add("wooden_sword");
        this.swords.add("stone_sword");
        this.swords.add("copper_sword");
        this.swords.add("iron_sword");
        this.swords.add("gold_sword");
        this.swords.add("golden_sword");
        this.swords.add("diamond_sword");
        this.swords.add("netherite_sword");
    }

    private void fillAxes() {
        this.axes.add("wood_axe");
        this.axes.add("wooden_axe");
        this.axes.add("stone_axe");
        this.axes.add("copper_axe");
        this.axes.add("iron_axe");
        this.axes.add("gold_axe");
        this.axes.add("golden_axe");
        this.axes.add("diamond_axe");
        this.axes.add("netherite_axe");
    }

    private void fillPickAxes() {
        this.pickAxes.add("wood_pickaxe");
        this.pickAxes.add("wooden_pickaxe");
        this.pickAxes.add("stone_pickaxe");
        this.pickAxes.add("copper_pickaxe");
        this.pickAxes.add("iron_pickaxe");
        this.pickAxes.add("gold_pickaxe");
        this.pickAxes.add("golden_pickaxe");
        this.pickAxes.add("diamond_pickaxe");
        this.pickAxes.add("netherite_pickaxe");
    }

    private void fillHoes() {
        this.hoes.add("wood_hoe");
        this.hoes.add("wooden_hoe");
        this.hoes.add("stone_hoe");
        this.hoes.add("copper_hoe");
        this.hoes.add("iron_hoe");
        this.hoes.add("gold_hoe");
        this.hoes.add("golden_hoe");
        this.hoes.add("diamond_hoe");
        this.hoes.add("netherite_hoe");
    }

    private void fillShovels() {
        this.shovels.add("wood_shovel");
        this.shovels.add("wooden_shovel");
        this.shovels.add("stone_shovel");
        this.shovels.add("copper_shovel");
        this.shovels.add("iron_shovel");
        this.shovels.add("gold_shovel");
        this.shovels.add("golden_shovel");
        this.shovels.add("diamond_shovel");
        this.shovels.add("netherite_shovel");
    }

    private void fillLeatherArmorWhiteList() {
        this.leatherArmor.add("leather_helmet");
        this.leatherArmor.add("leather_chestplate");
        this.leatherArmor.add("leather_leggings");
        this.leatherArmor.add("leather_boots");
    }

    private void fillCopperArmorWhiteList() {
        this.copperArmor.add("copper_helmet");
        this.copperArmor.add("copper_chestplate");
        this.copperArmor.add("copper_leggings");
        this.copperArmor.add("copper_boots");
    }

    private void fillIronArmorWhiteList() {
        this.ironArmor.add("iron_helmet");
        this.ironArmor.add("iron_chestplate");
        this.ironArmor.add("iron_leggings");
        this.ironArmor.add("iron_boots");
    }

    private void fillChainmailWhiteList() {
        this.chainmailArmor.add("chainmail_helmet");
        this.chainmailArmor.add("chainmail_chestplate");
        this.chainmailArmor.add("chainmail_leggings");
        this.chainmailArmor.add("chainmail_boots");
    }

    private void fillGoldArmorWhiteList() {
        this.goldArmor.add("gold_helmet");
        this.goldArmor.add("gold_chestplate");
        this.goldArmor.add("gold_leggings");
        this.goldArmor.add("gold_boots");
        this.goldArmor.add("golden_helmet");
        this.goldArmor.add("golden_chestplate");
        this.goldArmor.add("golden_leggings");
        this.goldArmor.add("golden_boots");
    }

    private void fillDiamondArmorWhiteList() {
        this.diamondArmor.add("diamond_helmet");
        this.diamondArmor.add("diamond_chestplate");
        this.diamondArmor.add("diamond_leggings");
        this.diamondArmor.add("diamond_boots");
    }

    private void fillnetheriteArmorWhiteList() {
        this.netheriteArmor.add("netherite_helmet");
        this.netheriteArmor.add("netherite_chestplate");
        this.netheriteArmor.add("netherite_leggings");
        this.netheriteArmor.add("netherite_boots");
    }

    private void fillWoodToolsWhiteList() {
        this.woodTools.add("wood_sword");
        this.woodTools.add("wood_axe");
        this.woodTools.add("wood_hoe");
        this.woodTools.add("wood_pickaxe");
        this.woodTools.add("wood_shovel");
        this.woodTools.add("wooden_sword");
        this.woodTools.add("wooden_axe");
        this.woodTools.add("wooden_hoe");
        this.woodTools.add("wooden_pickaxe");
        this.woodTools.add("wooden_shovel");
    }

    private void fillStoneToolsWhiteList() {
        this.stoneTools.add("stone_sword");
        this.stoneTools.add("stone_axe");
        this.stoneTools.add("stone_hoe");
        this.stoneTools.add("stone_pickaxe");
        this.stoneTools.add("stone_shovel");
    }

    private void fillCopperToolsWhiteList() {
        this.copperTools.add("copper_sword");
        this.copperTools.add("copper_axe");
        this.copperTools.add("copper_hoe");
        this.copperTools.add("copper_pickaxe");
        this.copperTools.add("copper_shovel");
    }

    private void fillIronToolsWhiteList() {
        this.ironTools.add("iron_sword");
        this.ironTools.add("iron_axe");
        this.ironTools.add("iron_hoe");
        this.ironTools.add("iron_pickaxe");
        this.ironTools.add("iron_shovel");
        this.ironTools.add("bucket");
        this.ironTools.add("flint_and_steel");
        this.ironTools.add("shears");
    }

    private void fillGoldToolsWhiteList() {
        this.goldTools.add("gold_sword");
        this.goldTools.add("gold_axe");
        this.goldTools.add("gold_hoe");
        this.goldTools.add("gold_pickaxe");
        this.goldTools.add("gold_shovel");
        this.goldTools.add("golden_sword");
        this.goldTools.add("golden_axe");
        this.goldTools.add("golden_hoe");
        this.goldTools.add("golden_pickaxe");
        this.goldTools.add("golden_shovel");
    }

    private void fillDiamondToolsWhiteList() {
        this.diamondTools.add("diamond_sword");
        this.diamondTools.add("diamond_axe");
        this.diamondTools.add("diamond_hoe");
        this.diamondTools.add("diamond_pickaxe");
        this.diamondTools.add("diamond_shovel");
    }

    private void fillNetheriteToolsWhiteList() {
        this.netheriteTools.add("netherite_sword");
        this.netheriteTools.add("netherite_axe");
        this.netheriteTools.add("netherite_hoe");
        this.netheriteTools.add("netherite_pickaxe");
        this.netheriteTools.add("netherite_shovel");
    }

    private void fillGlassBlockWhiteList() {
        this.glassBlocks.add("glass");
        this.glassBlocks.add("glass_pane");
        this.glassBlocks.add("black_stained_glass");
        this.glassBlocks.add("black_stained_glass_pane");
        this.glassBlocks.add("blue_stained_glass");
        this.glassBlocks.add("blue_stained_glass_pane");
        this.glassBlocks.add("brown_stained_glass");
        this.glassBlocks.add("brown_stained_glass_pane");
        this.glassBlocks.add("cyan_stained_glass");
        this.glassBlocks.add("cyan_stained_glass_pane");
        this.glassBlocks.add("gray_stained_glass");
        this.glassBlocks.add("gray_stained_glass_pane");
        this.glassBlocks.add("green_stained_glass");
        this.glassBlocks.add("green_stained_glass_pane");
        this.glassBlocks.add("light_blue_stained_glass");
        this.glassBlocks.add("light_blue_stained_glass_pane");
        this.glassBlocks.add("light_gray_stained_glass");
        this.glassBlocks.add("light_gray_stained_glass_pane");
        this.glassBlocks.add("lime_stained_glass");
        this.glassBlocks.add("lime_stained_glass_pane");
        this.glassBlocks.add("magenta_stained_glass");
        this.glassBlocks.add("magenta_stained_glass_pane");
        this.glassBlocks.add("orange_stained_glass");
        this.glassBlocks.add("orange_stained_glass_pane");
        this.glassBlocks.add("pink_stained_glass");
        this.glassBlocks.add("pink_stained_glass_pane");
        this.glassBlocks.add("purple_stained_glass");
        this.glassBlocks.add("purple_stained_glass_pane");
        this.glassBlocks.add("red_stained_glass");
        this.glassBlocks.add("red_stained_glass_pane");
        this.glassBlocks.add("white_stained_glass");
        this.glassBlocks.add("white_stained_glass_pane");
        this.glassBlocks.add("yellow_stained_glass");
        this.glassBlocks.add("yellow_stained_glass_pane");
    }

    private void fillFoodWhiteList() {
        this.foodItemWhiteList.add("apple");
        this.foodItemWhiteList.add("baked_potato");
        this.foodItemWhiteList.add("beetroot");
        this.foodItemWhiteList.add("beetroot_soup");
        this.foodItemWhiteList.add("bread");
        this.foodItemWhiteList.add("cake");
        this.foodItemWhiteList.add("carrot");
        this.foodItemWhiteList.add("chorus_fruit");
        this.foodItemWhiteList.add("cooked_chicken");
        this.foodItemWhiteList.add("cooked_cod");
        this.foodItemWhiteList.add("cooked_mutton");
        this.foodItemWhiteList.add("cooked_porkchop");
        this.foodItemWhiteList.add("cooked_rabbit");
        this.foodItemWhiteList.add("cooked_salmon");
        this.foodItemWhiteList.add("cookie");
        this.foodItemWhiteList.add("dried_kelp");
        this.foodItemWhiteList.add("golden_apple");
        this.foodItemWhiteList.add("enchanted_golden_apple");
        this.foodItemWhiteList.add("golden_carrot");
        this.foodItemWhiteList.add("melon_slice");
        this.foodItemWhiteList.add("mushroom_stew");
        this.foodItemWhiteList.add("poisonous_potato");
        this.foodItemWhiteList.add("potato");
        this.foodItemWhiteList.add("pumpkin_pie");
        this.foodItemWhiteList.add("rabbit_stew");
        this.foodItemWhiteList.add("raw_beef");
        this.foodItemWhiteList.add("raw_chicken");
        this.foodItemWhiteList.add("raw_cod");
        this.foodItemWhiteList.add("raw_mutton");
        this.foodItemWhiteList.add("raw_porkchop");
        this.foodItemWhiteList.add("raw_rabbit");
        this.foodItemWhiteList.add("raw_salmon");
        this.foodItemWhiteList.add("rotten_flesh");
        this.foodItemWhiteList.add("suspicious_stew");
        this.foodItemWhiteList.add("sweet_berries");
        this.foodItemWhiteList.add("tropical_fish");
    }

    public boolean isArmor(@NotNull Material material) {
        return this.isArmor(material.getKey().getKey());
    }

    public boolean isArmor(@NotNull String id) {
        return this.armors.contains(id);
    }

    public boolean isTool(@NotNull Material material) {
        return this.isTool(material.getKey().getKey());
    }

    public boolean isTool(@NotNull String id) {
        return this.tools.contains(id);
    }

    public boolean isEnchantable(@NotNull Material material) {
        return this.isEnchantable(material.getKey().getKey());
    }

    public boolean isEnchantable(@NotNull String id) {
        return this.enchantables.contains(id);
    }

    public boolean isOre(@NotNull Material material) {
        return this.isOre(material.getKey().getKey());
    }

    public boolean isOre(@NotNull String id) {
        return this.ores.contains(id);
    }

    public boolean isBow(@NotNull Material material) {
        return this.isBow(material.getKey().getKey());
    }

    public boolean isBow(@NotNull String id) {
        return this.bows.contains(id);
    }

    public boolean isCrossbow(@NotNull Material material) {
        return this.isCrossbow(material.getKey().getKey());
    }

    public boolean isCrossbow(@NotNull String id) {
        return this.crossbows.contains(id);
    }

    public boolean isTrident(@NotNull Material material) {
        return this.isTrident(material.getKey().getKey());
    }

    public boolean isTrident(@NotNull String id) {
        return this.tridents.contains(id);
    }

    public boolean isMace(@NotNull Material material) {
        return this.isMace(material.getKey().getKey());
    }

    public boolean isMace(@NotNull String id) {
        return this.maces.contains(id);
    }

    public boolean isLeatherArmor(@NotNull Material material) {
        return this.isLeatherArmor(material.getKey().getKey());
    }

    public boolean isLeatherArmor(@NotNull String id) {
        return this.leatherArmor.contains(id);
    }

    public boolean isCopperArmor(@NotNull Material material) {
        return this.isCopperArmor(material.getKey().getKey());
    }

    public boolean isCopperArmor(@NotNull String id) {
        return this.copperArmor.contains(id);
    }

    public boolean isIronArmor(@NotNull Material material) {
        return this.isIronArmor(material.getKey().getKey());
    }

    public boolean isIronArmor(@NotNull String id) {
        return this.ironArmor.contains(id);
    }

    public boolean isGoldArmor(@NotNull Material material) {
        return this.isGoldArmor(material.getKey().getKey());
    }

    public boolean isGoldArmor(@NotNull String id) {
        return this.goldArmor.contains(id);
    }

    public boolean isDiamondArmor(@NotNull Material material) {
        return this.isDiamondArmor(material.getKey().getKey());
    }

    public boolean isDiamondArmor(@NotNull String id) {
        return this.diamondArmor.contains(id);
    }

    public boolean isChainmailArmor(@NotNull Material material) {
        return this.isChainmailArmor(material.getKey().getKey());
    }

    public boolean isChainmailArmor(@NotNull String id) {
        return this.chainmailArmor.contains(id);
    }

    public boolean isNetheriteArmor(@NotNull Material material) {
        return this.isNetheriteArmor(material.getKey().getKey());
    }

    public boolean isNetheriteArmor(@NotNull String id) {
        return this.netheriteArmor.contains(id);
    }

    public boolean isWoodTool(@NotNull Material material) {
        return this.isWoodTool(material.getKey().getKey());
    }

    public boolean isWoodTool(@NotNull String id) {
        return this.woodTools.contains(id);
    }

    public boolean isStoneTool(@NotNull Material material) {
        return this.isStoneTool(material.getKey().getKey());
    }

    public boolean isStoneTool(@NotNull String id) {
        return this.stoneTools.contains(id);
    }

    public boolean isCopperTool(@NotNull Material material) {
        return this.isCopperTool(material.getKey().getKey());
    }

    public boolean isCopperTool(@NotNull String id) {
        return this.copperTools.contains(id);
    }

    public boolean isIronTool(@NotNull Material material) {
        return this.isIronTool(material.getKey().getKey());
    }

    public boolean isIronTool(@NotNull String id) {
        return this.ironTools.contains(id);
    }

    public boolean isGoldTool(@NotNull Material material) {
        return this.isGoldTool(material.getKey().getKey());
    }

    public boolean isGoldTool(@NotNull String id) {
        return this.goldTools.contains(id);
    }

    public boolean isDiamondTool(@NotNull Material material) {
        return this.isDiamondTool(material.getKey().getKey());
    }

    public boolean isDiamondTool(@NotNull String id) {
        return this.diamondTools.contains(id);
    }

    public boolean isSword(@NotNull Material material) {
        return this.isSword(material.getKey().getKey());
    }

    public boolean isSword(@NotNull String id) {
        return this.swords.contains(id);
    }

    public boolean isAxe(@NotNull Material material) {
        return this.isAxe(material.getKey().getKey());
    }

    public boolean isAxe(@NotNull String id) {
        return this.axes.contains(id);
    }

    public boolean isPickAxe(@NotNull Material material) {
        return this.isPickAxe(material.getKey().getKey());
    }

    public boolean isPickAxe(@NotNull String id) {
        return this.pickAxes.contains(id);
    }

    public boolean isShovel(@NotNull Material material) {
        return this.isShovel(material.getKey().getKey());
    }

    public boolean isShovel(@NotNull String id) {
        return this.shovels.contains(id);
    }

    public boolean isHoe(@NotNull Material material) {
        return this.isHoe(material.getKey().getKey());
    }

    public boolean isHoe(@NotNull String id) {
        return this.hoes.contains(id);
    }

    public boolean isNetheriteTool(@NotNull Material material) {
        return this.isNetheriteTool(material.getKey().getKey());
    }

    public boolean isNetheriteTool(@NotNull String id) {
        return this.netheriteTools.contains(id);
    }

    public boolean isStringTool(@NotNull Material material) {
        return this.isStringTool(material.getKey().getKey());
    }

    public boolean isStringTool(@NotNull String id) {
        return this.stringTools.contains(id);
    }

    public boolean isPrismarineTool(@NotNull Material material) {
        return this.isPrismarineTool(material.getKey().getKey());
    }

    public boolean isPrismarineTool(@NotNull String id) {
        return this.prismarineTools.contains(id);
    }

    public boolean isGlass(@NotNull Material material) {
        return this.glassBlocks.contains(material.getKey().getKey());
    }

    public boolean isFood(@NotNull Material material) {
        return this.foodItemWhiteList.contains(material.getKey().getKey());
    }

    private void fillMultiBlockPlantSet() {
        this.multiBlockPlant.add("cactus");
        this.multiBlockPlant.add("cactus_flower");
        this.multiBlockPlant.add("chorus_plant");
        this.multiBlockPlant.add("chorus_flower");
        this.multiBlockPlant.add("sugar_cane");
        this.multiBlockPlant.add("kelp_plant");
        this.multiBlockPlant.add("kelp");
        this.multiBlockPlant.add("tall_seagrass");
        this.multiBlockPlant.add("large_fern");
        this.multiBlockPlant.add("tall_grass");
        this.multiBlockPlant.add("bamboo");
    }

    private void fillMultiBlockHangingPlantSet() {
        this.multiBlockHangingPlant.add("weeping_vines_plant");
        this.multiBlockHangingPlant.add("twisted_vines_plant");
        this.multiBlockHangingPlant.add("cave_vines_plant");
        this.multiBlockHangingPlant.add("pale_hanging_moss");
    }

    private void fillShroomyWhiteList() {
        this.canMakeShroomyWhiteList.add("dirt");
        this.canMakeShroomyWhiteList.add("grass_block");
        this.canMakeShroomyWhiteList.add("dirt_path");
    }

    private void fillBlockCrackerWhiteList() {
        this.blockCrackerWhiteList.add("stone_bricks");
        this.blockCrackerWhiteList.add("infested_stone_bricks");
    }

    private void fillHerbalismAbilityBlackList() {
        this.herbalismAbilityBlackList.add("dirt");
        this.herbalismAbilityBlackList.add("grass_block");
        this.herbalismAbilityBlackList.add("dirt_path");
        this.herbalismAbilityBlackList.add("farmland");
    }

    private void fillTreeFellerDestructibleWhiteList() {
        this.treeFellerDestructibleWhiteList.add("pale_hanging_moss");
        this.treeFellerDestructibleWhiteList.add("oak_leaves");
        this.treeFellerDestructibleWhiteList.add("cherry_leaves");
        this.treeFellerDestructibleWhiteList.add("acacia_leaves");
        this.treeFellerDestructibleWhiteList.add("birch_leaves");
        this.treeFellerDestructibleWhiteList.add("dark_oak_leaves");
        this.treeFellerDestructibleWhiteList.add("pale_oak_leaves");
        this.treeFellerDestructibleWhiteList.add("jungle_leaves");
        this.treeFellerDestructibleWhiteList.add("spruce_leaves");
        this.treeFellerDestructibleWhiteList.add("azalea_leaves");
        this.treeFellerDestructibleWhiteList.add("flowering_azalea_leaves");
        this.treeFellerDestructibleWhiteList.add("mangrove_leaves");
        this.treeFellerDestructibleWhiteList.add("mangrove_roots");
        this.treeFellerDestructibleWhiteList.add("nether_wart_block");
        this.treeFellerDestructibleWhiteList.add("warped_wart_block");
        this.treeFellerDestructibleWhiteList.add("brown_mushroom_block");
        this.treeFellerDestructibleWhiteList.add("red_mushroom_block");
    }

    private void fillMossyWhiteList() {
        this.mossyWhiteList.add("cobblestone");
        this.mossyWhiteList.add("dirt");
        this.mossyWhiteList.add("grass_path");
        this.mossyWhiteList.add("stone_bricks");
        this.mossyWhiteList.add("cobblestone_wall");
    }

    private void addCommonToBlackList(Set<String> blackList) {
        this.addButtonsToBlackList(blackList);
        this.addTrapdoorsToBlackList(blackList);
        this.addFenceGatesToBlackList(blackList);
        this.addBedsToBlacklist(blackList);
        this.addPressurePlatesToBlackList(blackList);
        this.addChestsToBlackList(blackList);
        this.addGolemStatuesToBlackList(blackList);
        this.addShelvesToBlackList(blackList);
        this.addDoorsToBlackList(blackList);
        this.addFencesToBlackList(blackList);
        this.addSignsToBlackList(blackList);
        this.addHangingSignsToBlackList(blackList);
        this.addShulkerBoxesToBlackList(blackList);
        this.addMiscInteractableToBlackList(blackList);
    }

    private void addButtonsToBlackList(Set<String> blackList) {
        blackList.add("oak_button");
        blackList.add("spruce_button");
        blackList.add("birch_button");
        blackList.add("jungle_button");
        blackList.add("acacia_button");
        blackList.add("dark_oak_button");
        blackList.add("mangrove_button");
        blackList.add("cherry_button");
        blackList.add("pale_oak_button");
        blackList.add("bamboo_button");
        blackList.add("crimson_button");
        blackList.add("warped_button");
        blackList.add("stone_button");
        blackList.add("polished_blackstone_button");
    }

    private void addTrapdoorsToBlackList(Set<String> blackList) {
        blackList.add("oak_trapdoor");
        blackList.add("spruce_trapdoor");
        blackList.add("birch_trapdoor");
        blackList.add("jungle_trapdoor");
        blackList.add("acacia_trapdoor");
        blackList.add("dark_oak_trapdoor");
        blackList.add("mangrove_trapdoor");
        blackList.add("cherry_trapdoor");
        blackList.add("pale_oak_trapdoor");
        blackList.add("bamboo_trapdoor");
        blackList.add("crimson_trapdoor");
        blackList.add("warped_trapdoor");
        blackList.add("waxed_copper_trapdoor");
        blackList.add("waxed_exposed_copper_trapdoor");
        blackList.add("waxed_weathered_copper_trapdoor");
        blackList.add("waxed_oxidized_copper_trapdoor");
        blackList.add("copper_trapdoor");
        blackList.add("exposed_copper_trapdoor");
        blackList.add("weathered_copper_trapdoor");
        blackList.add("oxidized_copper_trapdoor");
        blackList.add("iron_trapdoor");
    }

    private void addFenceGatesToBlackList(Set<String> blackList) {
        blackList.add("oak_fence_gate");
        blackList.add("spruce_fence_gate");
        blackList.add("birch_fence_gate");
        blackList.add("jungle_fence_gate");
        blackList.add("acacia_fence_gate");
        blackList.add("dark_oak_fence_gate");
        blackList.add("mangrove_fence_gate");
        blackList.add("cherry_fence_gate");
        blackList.add("pale_oak_fence_gate");
        blackList.add("bamboo_fence_gate");
        blackList.add("crimson_fence_gate");
        blackList.add("warped_fence_gate");
    }

    private void addBedsToBlacklist(Set<String> blackList) {
        blackList.add("black_bed");
        blackList.add("blue_bed");
        blackList.add("brown_bed");
        blackList.add("cyan_bed");
        blackList.add("gray_bed");
        blackList.add("green_bed");
        blackList.add("light_blue_bed");
        blackList.add("light_gray_bed");
        blackList.add("lime_bed");
        blackList.add("magenta_bed");
        blackList.add("orange_bed");
        blackList.add("pink_bed");
        blackList.add("purple_bed");
        blackList.add("red_bed");
        blackList.add("white_bed");
        blackList.add("yellow_bed");
    }

    private void addPressurePlatesToBlackList(Set<String> blackList) {
        blackList.add("oak_pressure_plate");
        blackList.add("spruce_pressure_plate");
        blackList.add("birch_pressure_plate");
        blackList.add("jungle_pressure_plate");
        blackList.add("acacia_pressure_plate");
        blackList.add("dark_oak_pressure_plate");
        blackList.add("mangrove_pressure_plate");
        blackList.add("cherry_pressure_plate");
        blackList.add("pale_oak_pressure_plate");
        blackList.add("bamboo_pressure_plate");
        blackList.add("crimson_pressure_plate");
        blackList.add("warped_pressure_plate");
        blackList.add("stone_pressure_plate");
        blackList.add("light_weighted_pressure_plate");
        blackList.add("heavy_weighted_pressure_plate");
        blackList.add("polished_blackstone_pressure_plate");
    }

    private void addChestsToBlackList(Set<String> blackList) {
        blackList.add("chest");
        blackList.add("copper_chest");
        blackList.add("waxed_copper_chest");
        blackList.add("exposed_copper_chest");
        blackList.add("weathered_copper_chest");
        blackList.add("oxidized_copper_chest");
        blackList.add("trapped_chest");
        blackList.add("ender_chest");
    }

    private void addShelvesToBlackList(Set<String> blackList) {
        blackList.add("oak_shelf");
        blackList.add("spruce_shelf");
        blackList.add("birch_shelf");
        blackList.add("jungle_shelf");
        blackList.add("acacia_shelf");
        blackList.add("dark_oak_shelf");
        blackList.add("mangrove_shelf");
        blackList.add("cherry_shelf");
        blackList.add("pale_oak_shelf");
        blackList.add("bamboo_shelf");
        blackList.add("crimson_shelf");
        blackList.add("warped_shelf");
    }

    private void addGolemStatuesToBlackList(Set<String> blackList) {
        blackList.add("copper_golem_statue");
        blackList.add("waxed_copper_golem_statue");
        blackList.add("exposed_copper_golem_statue");
        blackList.add("weathered_copper_golem_statue");
        blackList.add("oxidized_copper_golem_statue");
    }

    private void addDoorsToBlackList(Set<String> blackList) {
        blackList.add("oak_door");
        blackList.add("spruce_door");
        blackList.add("birch_door");
        blackList.add("jungle_door");
        blackList.add("acacia_door");
        blackList.add("dark_oak_door");
        blackList.add("mangrove_door");
        blackList.add("cherry_door");
        blackList.add("pale_oak_door");
        blackList.add("bamboo_door");
        blackList.add("crimson_door");
        blackList.add("warped_door");
        blackList.add("iron_door");
        blackList.add("copper_door");
        blackList.add("exposed_copper_door");
        blackList.add("weathered_copper_door");
        blackList.add("oxidized_copper_door");
        blackList.add("waxed_copper_door");
        blackList.add("waxed_exposed_copper_door");
        blackList.add("waxed_weathered_copper_door");
        blackList.add("waxed_oxidized_copper_door");
    }

    private void addFencesToBlackList(Set<String> blackList) {
        blackList.add("oak_fence");
        blackList.add("spruce_fence");
        blackList.add("birch_fence");
        blackList.add("jungle_fence");
        blackList.add("acacia_fence");
        blackList.add("dark_oak_fence");
        blackList.add("mangrove_fence");
        blackList.add("cherry_fence");
        blackList.add("pale_oak_fence");
        blackList.add("bamboo_fence");
        blackList.add("crimson_fence");
        blackList.add("warped_fence");
        blackList.add("dispenser");
        blackList.add("enchanting_table");
        blackList.add("nether_brick_fence");
        blackList.add("iron_bars");
    }

    private void addSignsToBlackList(Set<String> blackList) {
        blackList.add("oak_sign");
        blackList.add("spruce_sign");
        blackList.add("birch_sign");
        blackList.add("jungle_sign");
        blackList.add("acacia_sign");
        blackList.add("dark_oak_sign");
        blackList.add("mangrove_sign");
        blackList.add("cherry_sign");
        blackList.add("pale_oak_sign");
        blackList.add("bamboo_sign");
        blackList.add("crimson_sign");
        blackList.add("warped_sign");
    }

    private void addHangingSignsToBlackList(Set<String> blackList) {
        blackList.add("oak_hanging_sign");
        blackList.add("spruce_hanging_sign");
        blackList.add("birch_hanging_sign");
        blackList.add("jungle_hanging_sign");
        blackList.add("acacia_hanging_sign");
        blackList.add("dark_oak_hanging_sign");
        blackList.add("mangrove_hanging_sign");
        blackList.add("cherry_hanging_sign");
        blackList.add("pale_oak_hanging_sign");
        blackList.add("bamboo_hanging_sign");
        blackList.add("crimson_hanging_sign");
        blackList.add("warped_hanging_sign");
    }

    private void addShulkerBoxesToBlackList(Set<String> blackList) {
        blackList.add("black_shulker_box");
        blackList.add("blue_shulker_box");
        blackList.add("brown_shulker_box");
        blackList.add("cyan_shulker_box");
        blackList.add("gray_shulker_box");
        blackList.add("green_shulker_box");
        blackList.add("light_blue_shulker_box");
        blackList.add("lime_shulker_box");
        blackList.add("magenta_shulker_box");
        blackList.add("orange_shulker_box");
        blackList.add("pink_shulker_box");
        blackList.add("purple_shulker_box");
        blackList.add("red_shulker_box");
        blackList.add("light_gray_shulker_box");
        blackList.add("white_shulker_box");
        blackList.add("yellow_shulker_box");
        blackList.add("shulker_box");
    }

    private void addMiscInteractableToBlackList(Set<String> blackList) {
        blackList.add("bell");
        blackList.add("barrel");
        blackList.add("blast_furnace");
        blackList.add("campfire");
        blackList.add("soul_campfire");
        blackList.add("cartography_table");
        blackList.add("composter");
        blackList.add("grindstone");
        blackList.add("lectern");
        blackList.add("loom");
        blackList.add("scaffolding");
        blackList.add("smoker");
        blackList.add("stonecutter");
        blackList.add("sweet_berry_bush");
        blackList.add("smithing_table");
        blackList.add("lodestone");
        blackList.add("respawn_anchor");
        blackList.add("chiseled_bookshelf");
        blackList.add("brewing_stand");
        blackList.add("bookshelf");
        blackList.add("cake");
        blackList.add("dispenser");
        blackList.add("enchanting_table");
        blackList.add("furnace");
        blackList.add("jukebox");
        blackList.add("lever");
        blackList.add("note_block");
        blackList.add("crafting_table");
        blackList.add("beacon");
        blackList.add("anvil");
        blackList.add("dropper");
        blackList.add("hopper");
        blackList.add("armor_stand");
    }

    private void fillAbilityBlackList() {
        this.addCommonToBlackList(this.abilityBlackList);
    }

    private void fillToolBlackList() {
        this.addCommonToBlackList(this.toolBlackList);
        this.toolBlackList.add("stripped_cherry_log");
        this.toolBlackList.add("stripped_cherry_wood");
        this.toolBlackList.add("stripped_acacia_log");
        this.toolBlackList.add("stripped_acacia_wood");
        this.toolBlackList.add("stripped_birch_log");
        this.toolBlackList.add("stripped_birch_wood");
        this.toolBlackList.add("stripped_dark_oak_log");
        this.toolBlackList.add("stripped_pale_oak_log");
        this.toolBlackList.add("stripped_dark_oak_wood");
        this.toolBlackList.add("stripped_pale_oak_wood");
        this.toolBlackList.add("stripped_jungle_log");
        this.toolBlackList.add("stripped_jungle_wood");
        this.toolBlackList.add("stripped_oak_log");
        this.toolBlackList.add("stripped_oak_wood");
        this.toolBlackList.add("stripped_spruce_log");
        this.toolBlackList.add("stripped_spruce_wood");
        this.toolBlackList.add("mangrove_wood");
        this.toolBlackList.add("mangrove_log");
        this.toolBlackList.add("stripped_mangrove_log");
        this.toolBlackList.add("acacia_log");
        this.toolBlackList.add("acacia_wood");
        this.toolBlackList.add("birch_log");
        this.toolBlackList.add("birch_wood");
        this.toolBlackList.add("dark_oak_log");
        this.toolBlackList.add("pale_oak_log");
        this.toolBlackList.add("dark_oak_wood");
        this.toolBlackList.add("pale_oak_wood");
        this.toolBlackList.add("jungle_log");
        this.toolBlackList.add("jungle_wood");
        this.toolBlackList.add("oak_log");
        this.toolBlackList.add("oak_wood");
        this.toolBlackList.add("spruce_log");
    }

    public boolean isIntendedToolPickaxe(@NotNull Material material) {
        return this.intendedToolPickAxe.contains(material.getKey().getKey());
    }

    public boolean isIntendedToolPickaxe(@NotNull String string) {
        return this.intendedToolPickAxe.contains(string);
    }

    @NotNull
    public HashSet<String> getNetheriteArmor() {
        return this.netheriteArmor;
    }

    @NotNull
    public HashSet<String> getNetheriteTools() {
        return this.netheriteTools;
    }

    public int getTier(@NotNull Material material) {
        return this.getTier(material.getKey().getKey());
    }

    public int getTier(@NotNull String id) {
        return this.tierValue.getOrDefault(id, 1);
    }

    private void addToHashSet(@NotNull String string, @NotNull HashSet<String> stringHashSet) {
        stringHashSet.add(string.toLowerCase(Locale.ENGLISH));
    }
}

