/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.skills.alchemy;

import com.gmail.nossr50.config.LegacyConfigLoader;
import com.gmail.nossr50.datatypes.skills.alchemy.AlchemyPotion;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.LogUtils;
import com.gmail.nossr50.util.PotionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class PotionConfig
extends LegacyConfigLoader {
    private static final String BREEZE_ROD_STR = "BREEZE_ROD";
    private static final String INFESTED_EFFECT_STR = "INFESTED";
    private static final String WEAVING_EFFECT_STR = "WEAVING";
    private static final String OOZING_EFFECT_STR = "OOZING";
    private static final String WIND_CHARGED_EFFECT_STR = "WIND_CHARGED";
    private static final String SLIME_BLOCK_STR = "SLIME_BLOCK";
    private static final String COBWEB_STR = "COBWEB";
    private static final String STONE_STR = "STONE";
    private final List<ItemStack> concoctionsIngredientsTierOne = new ArrayList<ItemStack>();
    private final List<ItemStack> concoctionsIngredientsTierTwo = new ArrayList<ItemStack>();
    private final List<ItemStack> concoctionsIngredientsTierThree = new ArrayList<ItemStack>();
    private final List<ItemStack> concoctionsIngredientsTierFour = new ArrayList<ItemStack>();
    private final List<ItemStack> concoctionsIngredientsTierFive = new ArrayList<ItemStack>();
    private final List<ItemStack> concoctionsIngredientsTierSix = new ArrayList<ItemStack>();
    private final List<ItemStack> concoctionsIngredientsTierSeven = new ArrayList<ItemStack>();
    private final List<ItemStack> concoctionsIngredientsTierEight = new ArrayList<ItemStack>();
    private final AlchemyPotionConfigResult INCOMPATIBLE_POTION_RESULT = new AlchemyPotionConfigResult(null, AlchemyPotionConfigResultType.INCOMPATIBLE);
    private final AlchemyPotionConfigResult ERROR_POTION_RESULT = new AlchemyPotionConfigResult(null, AlchemyPotionConfigResultType.ERROR);
    private final Map<String, AlchemyPotion> alchemyPotions = new HashMap<String, AlchemyPotion>();

    public PotionConfig() {
        super("potions.yml");
    }

    @VisibleForTesting
    PotionConfig(File file) {
        super(file);
    }

    @Override
    protected void loadKeys() {
    }

    public void loadPotions() {
        this.loadConcoctions();
        this.loadPotionMap();
    }

    @VisibleForTesting
    void loadConcoctions() {
        ConfigurationSection concoctionSection = this.config.getConfigurationSection("Concoctions");
        this.loadConcoctionsTier(this.concoctionsIngredientsTierOne, concoctionSection.getStringList("Tier_One_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierTwo, concoctionSection.getStringList("Tier_Two_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierThree, concoctionSection.getStringList("Tier_Three_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierFour, concoctionSection.getStringList("Tier_Four_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierFive, concoctionSection.getStringList("Tier_Five_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierSix, concoctionSection.getStringList("Tier_Six_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierSeven, concoctionSection.getStringList("Tier_Seven_Ingredients"));
        this.loadConcoctionsTier(this.concoctionsIngredientsTierEight, concoctionSection.getStringList("Tier_Eight_Ingredients"));
        this.concoctionsIngredientsTierTwo.addAll(this.concoctionsIngredientsTierOne);
        this.concoctionsIngredientsTierThree.addAll(this.concoctionsIngredientsTierTwo);
        this.concoctionsIngredientsTierFour.addAll(this.concoctionsIngredientsTierThree);
        this.concoctionsIngredientsTierFive.addAll(this.concoctionsIngredientsTierFour);
        this.concoctionsIngredientsTierSix.addAll(this.concoctionsIngredientsTierFive);
        this.concoctionsIngredientsTierSeven.addAll(this.concoctionsIngredientsTierSix);
        this.concoctionsIngredientsTierEight.addAll(this.concoctionsIngredientsTierSeven);
    }

    private void loadConcoctionsTier(List<ItemStack> ingredientList, List<String> ingredientStrings) {
        if (ingredientStrings != null && !ingredientStrings.isEmpty()) {
            for (String ingredientString : ingredientStrings) {
                ItemStack ingredient = this.loadIngredient(ingredientString);
                if (ingredient == null) continue;
                ingredientList.add(ingredient);
            }
        }
    }

    int loadPotionMap() {
        ConfigurationSection potionSection = this.config.getConfigurationSection("Potions");
        int potionsLoaded = 0;
        int incompatible = 0;
        int failures = 0;
        for (String potionName : potionSection.getKeys(false)) {
            AlchemyPotionConfigResult alchemyPotionConfigResult = this.loadPotion(potionSection.getConfigurationSection(potionName));
            AlchemyPotion potion = alchemyPotionConfigResult.alchemyPotion;
            if (potion != null) {
                this.alchemyPotions.put(potionName, potion);
                ++potionsLoaded;
                continue;
            }
            if (alchemyPotionConfigResult.resultType == AlchemyPotionConfigResultType.INCOMPATIBLE) {
                ++incompatible;
                continue;
            }
            ++failures;
        }
        int totalPotions = potionsLoaded + incompatible + failures;
        mcMMO.p.getLogger().info("Loaded " + potionsLoaded + " of " + totalPotions + " Alchemy potions.");
        if (incompatible > 0) {
            mcMMO.p.getLogger().info("Skipped " + incompatible + " Alchemy potions that require a newer Minecraft game version.");
        }
        if (failures > 0) {
            mcMMO.p.getLogger().info("Failed to load " + failures + " Alchemy potions that encountered errors while loading.");
        }
        return potionsLoaded;
    }

    @NotNull
    private AlchemyPotionConfigResult loadPotion(ConfigurationSection potion_section) {
        try {
            String potionTypeStr;
            ItemStack itemStack;
            PotionMeta potionMeta;
            Material material;
            String materialString;
            String key = potion_section.getName();
            ConfigurationSection potionData = potion_section.getConfigurationSection("PotionData");
            boolean extended = false;
            boolean upgraded = false;
            if (potionData != null) {
                extended = potionData.getBoolean("Extended", false);
                upgraded = potionData.getBoolean("Upgraded", false);
            }
            if ((materialString = potion_section.getString("Material", null)) != null) {
                material = ItemUtils.exhaustiveMaterialLookup(materialString);
                if (material == null) {
                    mcMMO.p.getLogger().warning("PotionConfig: Failed to parse material for potion " + key + ": " + materialString);
                    mcMMO.p.getLogger().warning("PotionConfig: Defaulting to POTION");
                    material = Material.POTION;
                }
            } else {
                mcMMO.p.getLogger().warning("PotionConfig: Missing Material config entry for potion " + key + ", from configuration section: " + String.valueOf(potion_section) + ", defaulting to POTION");
                material = Material.POTION;
            }
            if ((potionMeta = (PotionMeta)(itemStack = new ItemStack(material, 1)).getItemMeta()) == null) {
                mcMMO.p.getLogger().severe("PotionConfig: Failed to get PotionMeta for " + key + ", from configuration section: " + String.valueOf(potion_section));
                return this.ERROR_POTION_RESULT;
            }
            if (extended && upgraded) {
                mcMMO.p.getLogger().warning("Potion " + key + " has both Extended and Upgraded set to true, defaulting to Extended.");
                upgraded = false;
            }
            if ((potionTypeStr = potionData.getString("PotionType", null)) == null) {
                mcMMO.p.getLogger().severe("PotionConfig: Missing PotionType for " + key + ", from configuration section: " + String.valueOf(potion_section));
                return this.ERROR_POTION_RESULT;
            }
            if (!this.setPotionType(potionMeta, potionTypeStr, upgraded, extended)) {
                mcMMO.p.getLogger().severe("PotionConfig: Failed to set parameters of potion for " + key + ": " + potionTypeStr);
                return this.ERROR_POTION_RESULT;
            }
            ArrayList<String> lore = new ArrayList<String>();
            if (potion_section.contains("Lore")) {
                for (String line : potion_section.getStringList("Lore")) {
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                }
            }
            potionMeta.setLore(lore);
            if (potion_section.contains("Effects")) {
                for (String effect : potion_section.getStringList("Effects")) {
                    int duration;
                    String[] parts = effect.split(" ");
                    if (PotionConfig.isTrickyTrialsPotionEffect(parts[0]) && !mcMMO.getCompatibilityManager().getMinecraftGameVersion().isAtLeast(1, 21, 0)) {
                        LogUtils.debug(mcMMO.p.getLogger(), "Skipping potion effect " + effect + " because it is not compatible with the current Minecraft game version.");
                        return this.INCOMPATIBLE_POTION_RESULT;
                    }
                    PotionEffectType type = parts.length > 0 ? PotionEffectType.getByName((String)parts[0]) : null;
                    int amplifier = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
                    int n = duration = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
                    if (type != null) {
                        potionMeta.addCustomEffect(new PotionEffect(type, duration, amplifier), true);
                        continue;
                    }
                    mcMMO.p.getLogger().severe("PotionConfig: Failed to parse effect for potion " + key + ": " + effect);
                }
            }
            Color color = potion_section.contains("Color") ? Color.fromRGB((int)potion_section.getInt("Color")) : this.generateColor(potionMeta.getCustomEffects());
            potionMeta.setColor(color);
            HashMap<ItemStack, String> children = new HashMap<ItemStack, String>();
            if (potion_section.contains("Children")) {
                for (String childIngredient : potion_section.getConfigurationSection("Children").getKeys(false)) {
                    if (PotionConfig.isTrickyTrialsIngredient(childIngredient) && !mcMMO.getCompatibilityManager().getMinecraftGameVersion().isAtLeast(1, 21, 0)) continue;
                    ItemStack ingredient = this.loadIngredient(childIngredient);
                    if (ingredient != null) {
                        children.put(ingredient, potion_section.getConfigurationSection("Children").getString(childIngredient));
                        continue;
                    }
                    mcMMO.p.getLogger().severe("PotionConfig: Failed to parse child for potion " + key + ": " + childIngredient);
                }
            }
            this.setPotionDisplayName(potion_section, potionMeta);
            itemStack.setItemMeta((ItemMeta)potionMeta);
            return new AlchemyPotionConfigResult(new AlchemyPotion(potion_section.getName(), itemStack, children), AlchemyPotionConfigResultType.LOADED);
        }
        catch (Exception e) {
            mcMMO.p.getLogger().warning("PotionConfig: Failed to load Alchemy potion: " + potion_section.getName());
            e.printStackTrace();
            return this.ERROR_POTION_RESULT;
        }
    }

    private static boolean isTrickyTrialsIngredient(String ingredientStr) {
        return ingredientStr.equalsIgnoreCase(BREEZE_ROD_STR) || ingredientStr.equalsIgnoreCase(SLIME_BLOCK_STR) || ingredientStr.equalsIgnoreCase(COBWEB_STR) || ingredientStr.equalsIgnoreCase(STONE_STR);
    }

    private static boolean isTrickyTrialsPotionEffect(String effectStr) {
        return effectStr.equalsIgnoreCase(INFESTED_EFFECT_STR) || effectStr.equalsIgnoreCase(WEAVING_EFFECT_STR) || effectStr.equalsIgnoreCase(OOZING_EFFECT_STR) || effectStr.equalsIgnoreCase(WIND_CHARGED_EFFECT_STR);
    }

    private boolean setPotionType(PotionMeta potionMeta, String potionTypeStr, boolean upgraded, boolean extended) {
        PotionType potionType = PotionUtil.matchPotionType(potionTypeStr, upgraded, extended);
        if (potionType == null) {
            mcMMO.p.getLogger().severe("PotionConfig: Failed to parse potion type for: " + potionTypeStr);
            return false;
        }
        PotionUtil.setBasePotionType(potionMeta, potionType, extended, upgraded);
        PotionUtil.setUpgradedAndExtendedProperties(potionType, potionMeta, upgraded, extended);
        return true;
    }

    private void setPotionDisplayName(ConfigurationSection section, PotionMeta potionMeta) {
        if (potionMeta.getCustomEffects().isEmpty()) {
            return;
        }
        String configuredName = section.getString("Name", null);
        if (configuredName != null) {
            TextComponent textComponent = (TextComponent)Component.text((String)configuredName).decoration(TextDecoration.ITALIC, false);
            ItemUtils.customName((ItemMeta)potionMeta, (Component)textComponent, configuredName);
        }
    }

    private ItemStack loadIngredient(String ingredient) {
        if (ingredient == null || ingredient.isEmpty()) {
            return null;
        }
        Material material = Material.getMaterial((String)ingredient);
        if (material != null) {
            return new ItemStack(material, 1);
        }
        return null;
    }

    public List<ItemStack> getIngredients(int tier) {
        return switch (tier) {
            case 8 -> this.concoctionsIngredientsTierEight;
            case 7 -> this.concoctionsIngredientsTierSeven;
            case 6 -> this.concoctionsIngredientsTierSix;
            case 5 -> this.concoctionsIngredientsTierFive;
            case 4 -> this.concoctionsIngredientsTierFour;
            case 3 -> this.concoctionsIngredientsTierThree;
            case 2 -> this.concoctionsIngredientsTierTwo;
            default -> this.concoctionsIngredientsTierOne;
        };
    }

    public boolean isValidPotion(ItemStack item) {
        return this.getPotion(item) != null;
    }

    public AlchemyPotion getPotion(String name) {
        return this.alchemyPotions.get(name);
    }

    public AlchemyPotion getPotion(ItemStack item) {
        if (!item.hasItemMeta()) {
            return null;
        }
        ItemMeta itemMeta = item.getItemMeta();
        List<AlchemyPotion> potionList = this.alchemyPotions.values().stream().filter(potion -> potion.isSimilarPotion(item, itemMeta)).toList();
        return potionList.isEmpty() ? null : potionList.get(0);
    }

    public Color generateColor(List<PotionEffect> effects) {
        if (effects != null && !effects.isEmpty()) {
            ArrayList<Color> colors = new ArrayList<Color>();
            for (PotionEffect effect : effects) {
                if (effect.getType().getColor() == null) continue;
                colors.add(effect.getType().getColor());
            }
            if (!colors.isEmpty()) {
                if (colors.size() > 1) {
                    return this.calculateAverageColor(colors);
                }
                return (Color)colors.get(0);
            }
        }
        return null;
    }

    public Color calculateAverageColor(List<Color> colors) {
        int red = 0;
        int green = 0;
        int blue = 0;
        for (Color color : colors) {
            red += color.getRed();
            green += color.getGreen();
            blue += color.getBlue();
        }
        return Color.fromRGB((int)(red / colors.size()), (int)(green / colors.size()), (int)(blue / colors.size()));
    }

    record AlchemyPotionConfigResult(AlchemyPotion alchemyPotion, AlchemyPotionConfigResultType resultType) {
    }

    static enum AlchemyPotionConfigResultType {
        LOADED,
        INCOMPATIBLE,
        ERROR;

    }
}

