/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import org.bukkit.potion.PotionEffectType;

public final class PotionEffectUtil {
    private static final PotionEffectType haste = PotionEffectUtil.findHastePotionEffectType();
    private static final PotionEffectType nausea = PotionEffectUtil.findNauseaPotionEffectType();

    private PotionEffectUtil() {
    }

    private static PotionEffectType findNauseaPotionEffectType() {
        if (PotionEffectUtil.getNauseaLegacy() != null) {
            return PotionEffectUtil.getNauseaLegacy();
        }
        return PotionEffectUtil.getNauseaModern();
    }

    private static PotionEffectType getNauseaModern() {
        try {
            return (PotionEffectType)PotionEffectType.class.getField("NAUSEA").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }

    private static PotionEffectType getNauseaLegacy() {
        try {
            Object potionEffectTypeWrapper = PotionEffectType.class.getField("CONFUSION").get(null);
            return (PotionEffectType)potionEffectTypeWrapper;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }

    private static PotionEffectType findHastePotionEffectType() {
        if (PotionEffectUtil.getHasteLegacy() != null) {
            return PotionEffectUtil.getHasteLegacy();
        }
        if (PotionEffectUtil.getHasteModern() != null) {
            return PotionEffectUtil.getHasteModern();
        }
        throw new IllegalStateException("Unable to find the Haste PotionEffectType");
    }

    private static PotionEffectType getHasteLegacy() {
        try {
            Object potionEffectTypeWrapper = PotionEffectType.class.getField("FAST_DIGGING").get(null);
            return (PotionEffectType)potionEffectTypeWrapper;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }

    private static PotionEffectType getHasteModern() {
        try {
            return (PotionEffectType)PotionEffectType.class.getField("HASTE").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }

    public static PotionEffectType getHastePotionEffectType() {
        return haste;
    }

    public static PotionEffectType getNauseaPotionEffectType() {
        return nausea;
    }
}

