/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.Component;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class HerbalismCommand
extends SkillCommand {
    private String greenTerraLength;
    private String greenTerraLengthEndurance;
    private String greenThumbChance;
    private String greenThumbChanceLucky;
    private int greenThumbStage;
    private int farmersDietRank;
    private String doubleDropChance;
    private String doubleDropChanceLucky;
    private String tripleDropChance;
    private String tripleDropChanceLucky;
    private String hylianLuckChance;
    private String hylianLuckChanceLucky;
    private String shroomThumbChance;
    private String shroomThumbChanceLucky;
    private boolean hasHylianLuck;
    private boolean canGreenTerra;
    private boolean canGreenThumbPlants;
    private boolean canGreenThumbBlocks;
    private boolean canFarmersDiet;
    private boolean canDoubleDrop;
    private boolean canTripleDrop;
    private boolean canShroomThumb;

    public HerbalismCommand() {
        super(PrimarySkillType.HERBALISM);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue) {
        if (this.canDoubleDrop) {
            String[] doubleDropStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.HERBALISM_DOUBLE_DROPS);
            this.doubleDropChance = doubleDropStrings[0];
            this.doubleDropChanceLucky = doubleDropStrings[1];
        }
        if (this.canTripleDrop) {
            String[] tripleDropStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.HERBALISM_VERDANT_BOUNTY);
            this.tripleDropChance = tripleDropStrings[0];
            this.tripleDropChanceLucky = tripleDropStrings[1];
        }
        if (this.canFarmersDiet) {
            this.farmersDietRank = RankUtils.getRank(player, SubSkillType.HERBALISM_FARMERS_DIET);
        }
        if (this.canGreenTerra) {
            String[] greenTerraStrings = this.calculateLengthDisplayValues(player, skillValue);
            this.greenTerraLength = greenTerraStrings[0];
            this.greenTerraLengthEndurance = greenTerraStrings[1];
        }
        if (this.canGreenThumbBlocks || this.canGreenThumbPlants) {
            this.greenThumbStage = RankUtils.getRank(player, SubSkillType.HERBALISM_GREEN_THUMB);
            String[] greenThumbStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.HERBALISM_GREEN_THUMB);
            this.greenThumbChance = greenThumbStrings[0];
            this.greenThumbChanceLucky = greenThumbStrings[1];
        }
        if (this.hasHylianLuck) {
            String[] hylianLuckStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.HERBALISM_HYLIAN_LUCK);
            this.hylianLuckChance = hylianLuckStrings[0];
            this.hylianLuckChanceLucky = hylianLuckStrings[1];
        }
        if (this.canShroomThumb) {
            String[] shroomThumbStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.HERBALISM_SHROOM_THUMB);
            this.shroomThumbChance = shroomThumbStrings[0];
            this.shroomThumbChanceLucky = shroomThumbStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.hasHylianLuck = Permissions.canUseSubSkill(player, SubSkillType.HERBALISM_HYLIAN_LUCK);
        this.canGreenTerra = Permissions.greenTerra((Permissible)player);
        this.canGreenThumbPlants = RankUtils.hasUnlockedSubskill(player, SubSkillType.HERBALISM_GREEN_THUMB) && (Permissions.greenThumbPlant((Permissible)player, Material.WHEAT) || Permissions.greenThumbPlant((Permissible)player, Material.CARROT) || Permissions.greenThumbPlant((Permissible)player, Material.POTATO) || Permissions.greenThumbPlant((Permissible)player, Material.BEETROOTS) || Permissions.greenThumbPlant((Permissible)player, Material.NETHER_WART) || Permissions.greenThumbPlant((Permissible)player, Material.COCOA));
        this.canGreenThumbBlocks = RankUtils.hasUnlockedSubskill(player, SubSkillType.HERBALISM_GREEN_THUMB) && (Permissions.greenThumbBlock((Permissible)player, Material.DIRT) || Permissions.greenThumbBlock((Permissible)player, Material.COBBLESTONE) || Permissions.greenThumbBlock((Permissible)player, Material.COBBLESTONE_WALL) || Permissions.greenThumbBlock((Permissible)player, Material.STONE_BRICKS));
        this.canFarmersDiet = Permissions.canUseSubSkill(player, SubSkillType.HERBALISM_FARMERS_DIET);
        this.canDoubleDrop = Permissions.canUseSubSkill(player, SubSkillType.HERBALISM_DOUBLE_DROPS) && !mcMMO.p.getGeneralConfig().getDoubleDropsDisabled(this.skill);
        this.canTripleDrop = Permissions.canUseSubSkill(player, SubSkillType.HERBALISM_VERDANT_BOUNTY) && !mcMMO.p.getGeneralConfig().getDoubleDropsDisabled(this.skill);
        this.canShroomThumb = Permissions.canUseSubSkill(player, SubSkillType.HERBALISM_SHROOM_THUMB);
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canDoubleDrop) {
            messages.add(this.getStatMessage(SubSkillType.HERBALISM_DOUBLE_DROPS, this.doubleDropChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.doubleDropChanceLucky) : ""));
        }
        if (this.canTripleDrop) {
            messages.add(this.getStatMessage(SubSkillType.HERBALISM_VERDANT_BOUNTY, this.tripleDropChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.tripleDropChanceLucky) : ""));
        }
        if (this.canFarmersDiet) {
            messages.add(this.getStatMessage(false, true, SubSkillType.HERBALISM_FARMERS_DIET, String.valueOf(this.farmersDietRank)));
        }
        if (this.canGreenTerra) {
            messages.add(this.getStatMessage(SubSkillType.HERBALISM_GREEN_TERRA, this.greenTerraLength) + (hasEndurance ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.greenTerraLengthEndurance) : ""));
        }
        if (this.canGreenThumbBlocks || this.canGreenThumbPlants) {
            messages.add(this.getStatMessage(SubSkillType.HERBALISM_GREEN_THUMB, this.greenThumbChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.greenThumbChanceLucky) : ""));
        }
        if (this.canGreenThumbPlants) {
            messages.add(this.getStatMessage(true, true, SubSkillType.HERBALISM_GREEN_THUMB, String.valueOf(this.greenThumbStage)));
        }
        if (this.hasHylianLuck) {
            messages.add(this.getStatMessage(SubSkillType.HERBALISM_HYLIAN_LUCK, this.hylianLuckChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.hylianLuckChanceLucky) : ""));
        }
        if (this.canShroomThumb) {
            messages.add(this.getStatMessage(SubSkillType.HERBALISM_SHROOM_THUMB, this.shroomThumbChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.shroomThumbChanceLucky) : ""));
        }
        return messages;
    }

    @Override
    protected List<Component> getTextComponents(Player player) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        TextComponentFactory.getSubSkillTextComponents(player, textComponents, PrimarySkillType.HERBALISM);
        return textComponents;
    }
}

