/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.chat.message;

import com.gmail.nossr50.chat.author.Author;
import com.gmail.nossr50.chat.message.AbstractChatMessage;
import com.gmail.nossr50.config.ChatConfig;
import com.gmail.nossr50.datatypes.chat.ChatChannel;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.mcmmo.kyori.adventure.audience.Audience;
import com.gmail.nossr50.mcmmo.kyori.adventure.identity.Identity;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.Component;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.TextComponent;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.base.Objects;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PartyChatMessage
extends AbstractChatMessage {
    @NotNull
    private final Party party;

    public PartyChatMessage(@NotNull Plugin pluginRef, @NotNull Author author, @NotNull Audience audience, @NotNull String rawMessage, @NotNull TextComponent componentMessage, @NotNull Party party) {
        super(pluginRef, author, audience, rawMessage, componentMessage);
        this.party = party;
    }

    @NotNull
    public Party getParty() {
        return this.party;
    }

    @Override
    @NotNull
    public String getAuthorDisplayName() {
        return this.author.getAuthoredName(ChatChannel.PARTY);
    }

    @Override
    public void sendMessage() {
        this.audience.sendMessage((Identity)this.author, (Component)this.componentMessage);
        TextComponent spyMessage = LocaleLoader.getTextComponent("Chat.Spy.Party", this.author.getAuthoredName(ChatChannel.PARTY), this.rawMessage, this.party.getName());
        this.messagePartyChatSpies(spyMessage);
        if (ChatConfig.getInstance().isConsoleIncludedInAudience(ChatChannel.PARTY)) {
            mcMMO.p.getChatManager().sendConsoleMessage(this.author, spyMessage);
        }
    }

    private void messagePartyChatSpies(@NotNull TextComponent spyMessage) {
        for (McMMOPlayer mmoPlayer : UserManager.getPlayers()) {
            Party adminParty;
            Player player = mmoPlayer.getPlayer();
            if (!mmoPlayer.isPartyChatSpying() || (adminParty = mmoPlayer.getParty()) != null && adminParty == this.getParty()) continue;
            Audience audience = mcMMO.getAudiences().player(player);
            audience.sendMessage(spyMessage);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PartyChatMessage that = (PartyChatMessage)o;
        return Objects.equal((Object)this.party, (Object)that.party);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.party});
    }
}

