/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.MaterialType;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.Component;
import com.gmail.nossr50.skills.repair.ArcaneForging;
import com.gmail.nossr50.skills.repair.Repair;
import com.gmail.nossr50.skills.repair.RepairManager;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class RepairCommand
extends SkillCommand {
    private String repairMasteryBonus;
    private String superRepairChance;
    private String superRepairChanceLucky;
    private boolean canSuperRepair;
    private boolean canMasterRepair;
    private boolean canArcaneForge;
    private boolean canRepairStone;
    private boolean canRepairIron;
    private boolean canRepairGold;
    private boolean canRepairDiamond;
    private boolean canRepairString;
    private boolean canRepairLeather;
    private boolean canRepairWood;
    private boolean arcaneBypass;
    private int diamondLevel;
    private int goldLevel;
    private int ironLevel;
    private int stoneLevel;

    public RepairCommand() {
        super(PrimarySkillType.REPAIR);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue) {
        Repairable diamondRepairable = mcMMO.getRepairableManager().getRepairable(Material.DIAMOND_PICKAXE);
        Repairable goldRepairable = mcMMO.getRepairableManager().getRepairable(Material.GOLDEN_PICKAXE);
        Repairable ironRepairable = mcMMO.getRepairableManager().getRepairable(Material.IRON_PICKAXE);
        Repairable stoneRepairable = mcMMO.getRepairableManager().getRepairable(Material.STONE_PICKAXE);
        this.diamondLevel = diamondRepairable == null ? 0 : diamondRepairable.getMinimumLevel();
        this.goldLevel = goldRepairable == null ? 0 : goldRepairable.getMinimumLevel();
        this.ironLevel = ironRepairable == null ? 0 : ironRepairable.getMinimumLevel();
        int n = this.stoneLevel = stoneRepairable == null ? 0 : stoneRepairable.getMinimumLevel();
        if (this.canMasterRepair) {
            this.repairMasteryBonus = this.percent.format(Math.min(Repair.repairMasteryMaxBonus / (double)Repair.repairMasteryMaxBonusLevel * (double)skillValue, Repair.repairMasteryMaxBonus) / 100.0);
        }
        if (this.canSuperRepair) {
            String[] superRepairStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.REPAIR_SUPER_REPAIR);
            this.superRepairChance = superRepairStrings[0];
            this.superRepairChanceLucky = superRepairStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canSuperRepair = Permissions.canUseSubSkill(player, SubSkillType.REPAIR_SUPER_REPAIR);
        this.canMasterRepair = Permissions.canUseSubSkill(player, SubSkillType.REPAIR_REPAIR_MASTERY);
        this.canArcaneForge = Permissions.canUseSubSkill(player, SubSkillType.REPAIR_ARCANE_FORGING);
        this.canRepairDiamond = Permissions.repairMaterialType((Permissible)player, MaterialType.DIAMOND);
        this.canRepairGold = Permissions.repairMaterialType((Permissible)player, MaterialType.GOLD);
        this.canRepairIron = Permissions.repairMaterialType((Permissible)player, MaterialType.IRON);
        this.canRepairStone = Permissions.repairMaterialType((Permissible)player, MaterialType.STONE);
        this.canRepairString = Permissions.repairMaterialType((Permissible)player, MaterialType.STRING);
        this.canRepairLeather = Permissions.repairMaterialType((Permissible)player, MaterialType.LEATHER);
        this.canRepairWood = Permissions.repairMaterialType((Permissible)player, MaterialType.WOOD);
        this.arcaneBypass = Permissions.arcaneBypass((Permissible)player) || Permissions.hasRepairEnchantBypassPerk((Permissible)player);
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canArcaneForge) {
            RepairManager repairManager = this.mmoPlayer.getRepairManager();
            messages.add(this.getStatMessage(false, true, SubSkillType.REPAIR_ARCANE_FORGING, String.valueOf(RankUtils.getRank(player, SubSkillType.REPAIR_ARCANE_FORGING)), RankUtils.getHighestRankStr(SubSkillType.REPAIR_ARCANE_FORGING)));
            if (ArcaneForging.arcaneForgingEnchantLoss || ArcaneForging.arcaneForgingDowngrades) {
                messages.add(this.getStatMessage(true, true, SubSkillType.REPAIR_ARCANE_FORGING, String.valueOf(this.arcaneBypass ? 100.0 : repairManager.getKeepEnchantChance()), String.valueOf(this.arcaneBypass ? 0.0 : repairManager.getDowngradeEnchantChance())));
            }
        }
        if (this.canMasterRepair) {
            messages.add(this.getStatMessage(false, true, SubSkillType.REPAIR_REPAIR_MASTERY, this.repairMasteryBonus));
        }
        if (this.canSuperRepair) {
            messages.add(this.getStatMessage(SubSkillType.REPAIR_SUPER_REPAIR, this.superRepairChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.superRepairChanceLucky) : ""));
        }
        return messages;
    }

    @Override
    protected List<Component> getTextComponents(Player player) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        TextComponentFactory.getSubSkillTextComponents(player, textComponents, PrimarySkillType.REPAIR);
        return textComponents;
    }
}

