/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.backups;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.CancellableRunnable;
import com.gmail.nossr50.util.LogUtils;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class CleanBackupsTask
extends CancellableRunnable {
    private static final String BACKUP_DIRECTORY = mcMMO.getMainDirectory() + "backup" + File.separator;
    private static final File BACKUP_DIR = new File(BACKUP_DIRECTORY);

    @Override
    public void run() {
        ArrayList<Integer> savedDays = new ArrayList<Integer>();
        HashMap<Integer, List> savedYearsWeeks = new HashMap<Integer, List>();
        ArrayList<File> toDelete = new ArrayList<File>();
        int amountTotal = 0;
        int amountDeleted = 0;
        if (BACKUP_DIR.listFiles() == null) {
            return;
        }
        for (File file : BACKUP_DIR.listFiles()) {
            if (!file.isFile() || file.isDirectory()) continue;
            ++amountTotal;
            String fileName = file.getName();
            Date date = this.getDate(fileName.split("[.]")[0]);
            if (!fileName.contains(".zip") || date == null) {
                LogUtils.debug(mcMMO.p.getLogger(), "Could not determine date for file: " + fileName);
                continue;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int dayOfWeek = cal.get(7);
            int weekOfYear = cal.get(3);
            int year = cal.get(1);
            if (this.isPast24Hours(date) && mcMMO.p.getGeneralConfig().getKeepLast24Hours()) continue;
            if (this.isLastWeek(date) && !savedDays.contains(dayOfWeek) && mcMMO.p.getGeneralConfig().getKeepDailyLastWeek()) {
                savedDays.add(dayOfWeek);
                continue;
            }
            List savedWeeks = savedYearsWeeks.computeIfAbsent(year, k -> new ArrayList());
            if (!savedWeeks.contains(weekOfYear) && mcMMO.p.getGeneralConfig().getKeepWeeklyPastMonth()) {
                savedWeeks.add(weekOfYear);
                continue;
            }
            ++amountDeleted;
            toDelete.add(file);
        }
        if (toDelete.isEmpty()) {
            return;
        }
        LogUtils.debug(mcMMO.p.getLogger(), "Cleaned backup files. Deleted " + amountDeleted + " of " + amountTotal + " files.");
        for (File file : toDelete) {
            if (!file.delete()) continue;
            LogUtils.debug(mcMMO.p.getLogger(), "Deleted: " + file.getName());
        }
    }

    private boolean isPast24Hours(Date date) {
        Date modifiedDate = new Date(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS));
        return date.after(modifiedDate);
    }

    private boolean isLastWeek(Date date) {
        Date modifiedDate = new Date(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS));
        return date.after(modifiedDate);
    }

    private Date getDate(String fileName) {
        Date date;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss", Locale.US);
        try {
            date = dateFormat.parse(fileName);
        }
        catch (ParseException e) {
            return null;
        }
        return date;
    }
}

