/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.events.items;

import java.util.Objects;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockDropItemEvent;
import org.jetbrains.annotations.NotNull;

public class McMMOModifyBlockDropItemEvent
extends Event
implements Cancellable {
    @NotNull
    private final BlockDropItemEvent blockDropItemEvent;
    private final int originalBonusAmountToAdd;
    private int modifiedItemStackQuantity;
    @NotNull
    private final Item itemThatHasBonusDrops;
    private boolean isCancelled = false;
    private final int originalItemStackQuantity;
    @NotNull
    private static final HandlerList handlers = new HandlerList();

    public McMMOModifyBlockDropItemEvent(@NotNull BlockDropItemEvent blockDropItemEvent, @NotNull Item itemThatHasBonusDrops, int bonusDropsToAdd) {
        super(false);
        Objects.requireNonNull(blockDropItemEvent, "blockDropItemEvent cannot be null");
        Objects.requireNonNull(itemThatHasBonusDrops, "itemThatHasBonusDrops cannot be null");
        if (bonusDropsToAdd <= 0) {
            throw new IllegalArgumentException("cannot instantiate a new McMMOModifyBlockDropItemEvent with a bonusDropsToAdd that is <= 0");
        }
        this.blockDropItemEvent = blockDropItemEvent;
        this.itemThatHasBonusDrops = itemThatHasBonusDrops;
        this.originalItemStackQuantity = itemThatHasBonusDrops.getItemStack().getAmount();
        this.originalBonusAmountToAdd = bonusDropsToAdd;
        this.modifiedItemStackQuantity = itemThatHasBonusDrops.getItemStack().getAmount() + bonusDropsToAdd;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancel) {
        this.isCancelled = cancel;
    }

    @NotNull
    public BlockDropItemEvent getBlockDropItemEvent() {
        return this.blockDropItemEvent;
    }

    public int getOriginalBonusAmountToAdd() {
        return this.originalBonusAmountToAdd;
    }

    @NotNull
    public Item getItem() {
        return this.itemThatHasBonusDrops;
    }

    public int getModifiedItemStackQuantity() {
        return this.modifiedItemStackQuantity;
    }

    public int getOriginalItemStackQuantity() {
        return this.originalItemStackQuantity;
    }

    public int getBonusAmountToAdd() {
        return Math.max(0, this.modifiedItemStackQuantity - this.originalItemStackQuantity);
    }

    public void setBonusAmountToAdd(int bonus) {
        if (bonus < 0) {
            throw new IllegalArgumentException("bonus must be >= 0");
        }
        this.modifiedItemStackQuantity = this.originalItemStackQuantity + bonus;
    }

    public void setModifiedItemStackQuantity(int modifiedItemStackQuantity) {
        if (modifiedItemStackQuantity < this.originalItemStackQuantity) {
            throw new IllegalArgumentException("modifiedItemStackQuantity cannot be less than the originalItemStackQuantity");
        }
        this.modifiedItemStackQuantity = modifiedItemStackQuantity;
    }

    public boolean isEffectivelyNoBonus() {
        return this.modifiedItemStackQuantity == this.originalItemStackQuantity;
    }

    @NotNull
    public Player getPlayer() {
        return this.blockDropItemEvent.getPlayer();
    }

    @NotNull
    public Block getBlock() {
        return this.blockDropItemEvent.getBlock();
    }

    @NotNull
    public BlockState getBlockState() {
        return this.blockDropItemEvent.getBlockState();
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public String toString() {
        return "McMMOModifyBlockDropItemEvent{blockDropItemEvent=" + String.valueOf(this.blockDropItemEvent) + ", originalBonusAmountToAdd=" + this.originalBonusAmountToAdd + ", modifiedItemStackQuantity=" + this.modifiedItemStackQuantity + ", itemThatHasBonusDrops=" + String.valueOf(this.itemThatHasBonusDrops) + ", isCancelled=" + this.isCancelled + ", originalItemStackQuantity=" + this.originalItemStackQuantity + "}";
    }

    public final boolean equals(Object o) {
        if (!(o instanceof McMMOModifyBlockDropItemEvent)) {
            return false;
        }
        McMMOModifyBlockDropItemEvent that = (McMMOModifyBlockDropItemEvent)((Object)o);
        return this.originalBonusAmountToAdd == that.originalBonusAmountToAdd && this.modifiedItemStackQuantity == that.modifiedItemStackQuantity && this.isCancelled == that.isCancelled && this.originalItemStackQuantity == that.originalItemStackQuantity && this.blockDropItemEvent.equals(that.blockDropItemEvent) && this.itemThatHasBonusDrops.equals((Object)that.itemThatHasBonusDrops);
    }

    public int hashCode() {
        int result = this.blockDropItemEvent.hashCode();
        result = 31 * result + this.originalBonusAmountToAdd;
        result = 31 * result + this.modifiedItemStackQuantity;
        result = 31 * result + this.itemThatHasBonusDrops.hashCode();
        result = 31 * result + Boolean.hashCode(this.isCancelled);
        result = 31 * result + this.originalItemStackQuantity;
        return result;
    }
}

