/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.fishing;

import com.gmail.nossr50.api.ItemSpawnReason;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.config.treasure.FishingTreasureConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.treasure.EnchantmentTreasure;
import com.gmail.nossr50.datatypes.treasure.FishingTreasure;
import com.gmail.nossr50.datatypes.treasure.FishingTreasureBook;
import com.gmail.nossr50.datatypes.treasure.Rarity;
import com.gmail.nossr50.datatypes.treasure.ShakeTreasure;
import com.gmail.nossr50.datatypes.treasure.Treasure;
import com.gmail.nossr50.events.skills.fishing.McMMOPlayerFishingTreasureEvent;
import com.gmail.nossr50.events.skills.fishing.McMMOPlayerMasterAnglerEvent;
import com.gmail.nossr50.events.skills.fishing.McMMOPlayerShakeEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.MasterAnglerTask;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.fishing.Fishing;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.MetadataConstants;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.adapter.BiomeAdapter;
import com.gmail.nossr50.util.compat.layers.skills.MasterAnglerCompatibilityLayer;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishingManager
extends SkillManager {
    public static final int FISHING_ROD_CAST_CD_MILLISECONDS = 100;
    private final long FISHING_COOLDOWN_SECONDS = 1000L;
    private long fishingRodCastTimestamp = 0L;
    private long fishHookSpawnTimestamp = 0L;
    private long lastWarned = 0L;
    private final long lastWarnedExhaust = 0L;
    private FishHook fishHookReference;
    private BoundingBox lastFishingBoundingBox;
    private boolean sameTarget;
    private Item fishingCatch;
    private Location hookLocation;
    private int fishCaughtCounter = 1;
    private final int masterAnglerMinWaitLowerBound;
    private final int masterAnglerMaxWaitLowerBound;

    public FishingManager(McMMOPlayer mmoPlayer) {
        super(mmoPlayer, PrimarySkillType.FISHING);
        int bonusCapMin = mcMMO.p.getAdvancedConfig().getFishingReductionMinWaitCap();
        int bonusCapMax = mcMMO.p.getAdvancedConfig().getFishingReductionMaxWaitCap();
        this.masterAnglerMinWaitLowerBound = Math.max(bonusCapMin, 0);
        this.masterAnglerMaxWaitLowerBound = Math.max(bonusCapMax, this.masterAnglerMinWaitLowerBound + 40);
    }

    public boolean canShake(Entity target) {
        return target instanceof LivingEntity && RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.FISHING_SHAKE) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.FISHING_SHAKE);
    }

    public boolean canMasterAngler() {
        return mcMMO.getCompatibilityManager().getMasterAnglerCompatibilityLayer() != null && this.getSkillLevel() >= RankUtils.getUnlockLevel(SubSkillType.FISHING_MASTER_ANGLER) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.FISHING_MASTER_ANGLER);
    }

    public void setFishHookReference(FishHook fishHook) {
        if (fishHook.getMetadata("mcMMO: Fish Hook Tracker").size() > 0) {
            return;
        }
        fishHook.setMetadata("mcMMO: Fish Hook Tracker", (MetadataValue)MetadataConstants.MCMMO_METADATA_VALUE);
        this.fishHookReference = fishHook;
        this.fishHookSpawnTimestamp = System.currentTimeMillis();
        this.fishingRodCastTimestamp = System.currentTimeMillis();
    }

    public boolean isFishingTooOften() {
        long fishHookSpawnCD;
        boolean hasFished;
        long currentTime = System.currentTimeMillis();
        boolean bl = hasFished = currentTime < (fishHookSpawnCD = this.fishHookSpawnTimestamp + 1000L);
        if (hasFished && this.lastWarned + 1000L < currentTime) {
            this.getPlayer().sendMessage(LocaleLoader.getString("Fishing.Scared"));
            this.lastWarned = System.currentTimeMillis();
        }
        return hasFished;
    }

    public void processExploiting(Vector centerOfCastVector) {
        BoundingBox newCastBoundingBox = FishingManager.makeBoundingBox(centerOfCastVector);
        boolean bl = this.sameTarget = this.lastFishingBoundingBox != null && this.lastFishingBoundingBox.overlaps(newCastBoundingBox);
        this.fishCaughtCounter = this.sameTarget ? ++this.fishCaughtCounter : 1;
        if (!this.sameTarget) {
            this.lastFishingBoundingBox = newCastBoundingBox;
        }
        if (this.fishCaughtCounter + 1 == ExperienceConfig.getInstance().getFishingExploitingOptionOverFishLimit()) {
            this.getPlayer().sendMessage(LocaleLoader.getString("Fishing.LowResourcesTip", ExperienceConfig.getInstance().getFishingExploitingOptionMoveRange()));
        }
    }

    public boolean isExploitingFishing(Vector centerOfCastVector) {
        return this.sameTarget && this.fishCaughtCounter >= ExperienceConfig.getInstance().getFishingExploitingOptionOverFishLimit();
    }

    public static BoundingBox makeBoundingBox(Vector centerOfCastVector) {
        int exploitingRange = ExperienceConfig.getInstance().getFishingExploitingOptionMoveRange();
        return BoundingBox.of((Vector)centerOfCastVector, (double)(exploitingRange / 2), (double)1.0, (double)(exploitingRange / 2));
    }

    public void setFishingTarget() {
        this.getPlayer().getTargetBlock(BlockUtils.getTransparentBlocks(), 100);
    }

    public boolean canIceFish(Block block) {
        if (this.getSkillLevel() < RankUtils.getUnlockLevel(SubSkillType.FISHING_ICE_FISHING)) {
            return false;
        }
        if (block.getType() != Material.ICE) {
            return false;
        }
        if (!BiomeAdapter.ICE_BIOMES.contains(block.getBiome()) && block.getRelative(BlockFace.DOWN, 3).getType() != Material.WATER) {
            return false;
        }
        Player player = this.getPlayer();
        if (!Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.FISHING_ICE_FISHING)) {
            return false;
        }
        return EventUtils.simulateBlockBreak(block, player);
    }

    public int getLootTier() {
        return RankUtils.getRank(this.getPlayer(), SubSkillType.FISHING_TREASURE_HUNTER);
    }

    public double getShakeChance() {
        return mcMMO.p.getAdvancedConfig().getShakeChance(RankUtils.getRank(this.mmoPlayer.getPlayer(), SubSkillType.FISHING_SHAKE));
    }

    protected int getVanillaXPBoostModifier() {
        return mcMMO.p.getAdvancedConfig().getFishingVanillaXPModifier(this.getLootTier());
    }

    public double getShakeProbability() {
        return this.getShakeChance();
    }

    public int handleFishermanDiet(int eventFoodLevel) {
        return SkillUtils.handleFoodSkills(this.getPlayer(), eventFoodLevel, SubSkillType.FISHING_FISHERMANS_DIET);
    }

    public void iceFishing(FishHook hook, Block block) {
        block.setType(Material.WATER);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                Block relative = block.getRelative(x, 0, z);
                if (relative.getType() != Material.ICE) continue;
                relative.setType(Material.WATER);
            }
        }
        EventUtils.callFakeFishEvent(this.getPlayer(), hook);
    }

    public void masterAngler(@NotNull FishHook hook, int lureLevel) {
        mcMMO.p.getFoliaLib().getScheduler().runAtEntityLater((Entity)hook, (Consumer)new MasterAnglerTask(hook, this, lureLevel), 1L);
    }

    public void processMasterAngler(@NotNull FishHook fishHook, int lureLevel) {
        MasterAnglerCompatibilityLayer masterAnglerCompatibilityLayer = (MasterAnglerCompatibilityLayer)mcMMO.getCompatibilityManager().getMasterAnglerCompatibilityLayer();
        if (masterAnglerCompatibilityLayer != null) {
            int maxWaitTicks = masterAnglerCompatibilityLayer.getMaxWaitTime(fishHook);
            int minWaitTicks = masterAnglerCompatibilityLayer.getMinWaitTime(fishHook);
            int masterAnglerRank = RankUtils.getRank(this.mmoPlayer, SubSkillType.FISHING_MASTER_ANGLER);
            int convertedLureBonus = 0;
            if (lureLevel > 0) {
                masterAnglerCompatibilityLayer.setApplyLure(fishHook, false);
                convertedLureBonus = lureLevel * 100;
            }
            boolean boatBonus = this.isInBoat();
            int minWaitReduction = this.getMasterAnglerTickMinWaitReduction(masterAnglerRank, boatBonus);
            int maxWaitReduction = this.getMasterAnglerTickMaxWaitReduction(masterAnglerRank, boatBonus, convertedLureBonus);
            int reducedMinWaitTime = this.getReducedTicks(minWaitTicks, minWaitReduction, this.masterAnglerMinWaitLowerBound);
            int reducedMaxWaitTime = this.getReducedTicks(maxWaitTicks, maxWaitReduction, this.masterAnglerMaxWaitLowerBound);
            boolean badValuesFix = false;
            if (reducedMaxWaitTime < reducedMinWaitTime) {
                reducedMaxWaitTime = reducedMinWaitTime + 100;
                badValuesFix = true;
            }
            McMMOPlayerMasterAnglerEvent event = new McMMOPlayerMasterAnglerEvent(this.mmoPlayer, reducedMinWaitTime, reducedMaxWaitTime, this);
            mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            reducedMaxWaitTime = event.getReducedMaxWaitTime();
            reducedMinWaitTime = event.getReducedMinWaitTime();
            if (this.mmoPlayer.isDebugMode()) {
                this.mmoPlayer.getPlayer().sendMessage(String.valueOf(ChatColor.GOLD) + "Master Angler Debug");
                if (badValuesFix) {
                    this.mmoPlayer.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "Bad values were applied and corrected, check your configs, minWaitLowerBound wait should never be lower than min wait.");
                }
                this.mmoPlayer.getPlayer().sendMessage("ALLOW STACK WITH LURE: " + masterAnglerCompatibilityLayer.getApplyLure(fishHook));
                this.mmoPlayer.getPlayer().sendMessage("MIN TICK REDUCTION: " + minWaitReduction);
                this.mmoPlayer.getPlayer().sendMessage("MAX TICK REDUCTION: " + maxWaitReduction);
                this.mmoPlayer.getPlayer().sendMessage("BOAT BONUS: " + boatBonus);
                if (boatBonus) {
                    this.mmoPlayer.getPlayer().sendMessage("BOAT MAX TICK REDUCTION: " + maxWaitReduction);
                    this.mmoPlayer.getPlayer().sendMessage("BOAT MIN TICK REDUCTION: " + maxWaitReduction);
                }
                this.mmoPlayer.getPlayer().sendMessage("");
                this.mmoPlayer.getPlayer().sendMessage(String.valueOf(ChatColor.DARK_AQUA) + "BEFORE MASTER ANGLER WAS APPLIED");
                this.mmoPlayer.getPlayer().sendMessage("Original Max Wait Ticks: " + maxWaitTicks);
                this.mmoPlayer.getPlayer().sendMessage("Original Min Wait Ticks: " + minWaitTicks);
                this.mmoPlayer.getPlayer().sendMessage("");
                this.mmoPlayer.getPlayer().sendMessage(String.valueOf(ChatColor.DARK_AQUA) + "AFTER MASTER ANGLER WAS APPLIED");
                this.mmoPlayer.getPlayer().sendMessage("Current Max Wait Ticks: " + reducedMaxWaitTime);
                this.mmoPlayer.getPlayer().sendMessage("Current Min Wait Ticks: " + reducedMinWaitTime);
                this.mmoPlayer.getPlayer().sendMessage("");
                this.mmoPlayer.getPlayer().sendMessage(String.valueOf(ChatColor.DARK_AQUA) + "Caps / Limits (edit in advanced.yml)");
                this.mmoPlayer.getPlayer().sendMessage("Lowest possible minWaitLowerBound wait ticks " + this.masterAnglerMinWaitLowerBound);
                this.mmoPlayer.getPlayer().sendMessage("Lowest possible min wait ticks " + this.masterAnglerMaxWaitLowerBound);
            }
            masterAnglerCompatibilityLayer.setMaxWaitTime(fishHook, reducedMaxWaitTime);
            masterAnglerCompatibilityLayer.setMinWaitTime(fishHook, reducedMinWaitTime);
        }
    }

    public int getReducedTicks(int ticks, int totalBonus, int tickBounds) {
        return Math.max(tickBounds, ticks - totalBonus);
    }

    public boolean isInBoat() {
        return this.mmoPlayer.getPlayer().isInsideVehicle() && this.mmoPlayer.getPlayer().getVehicle() instanceof Boat;
    }

    public int getMasterAnglerTickMaxWaitReduction(int masterAnglerRank, boolean boatBonus, int emulatedLureBonus) {
        int totalBonus = mcMMO.p.getAdvancedConfig().getFishingReductionMaxWaitTicks() * masterAnglerRank;
        if (boatBonus) {
            totalBonus += this.getFishingBoatMaxWaitReduction();
        }
        return totalBonus += emulatedLureBonus;
    }

    public int getMasterAnglerTickMinWaitReduction(int masterAnglerRank, boolean boatBonus) {
        int totalBonus = mcMMO.p.getAdvancedConfig().getFishingReductionMinWaitTicks() * masterAnglerRank;
        if (boatBonus) {
            totalBonus += this.getFishingBoatMinWaitReduction();
        }
        return totalBonus;
    }

    public int getFishingBoatMinWaitReduction() {
        return mcMMO.p.getAdvancedConfig().getFishingBoatReductionMinWaitTicks();
    }

    public int getFishingBoatMaxWaitReduction() {
        return mcMMO.p.getAdvancedConfig().getFishingBoatReductionMaxWaitTicks();
    }

    public boolean isMagicHunterEnabled() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.FISHING_MAGIC_HUNTER) && RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.FISHING_TREASURE_HUNTER) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.FISHING_MAGIC_HUNTER) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.FISHING_TREASURE_HUNTER);
    }

    public void processFishing(@NotNull Item fishingCatch) {
        this.fishingCatch = fishingCatch;
        int fishXp = ExperienceConfig.getInstance().getXp(PrimarySkillType.FISHING, fishingCatch.getItemStack().getType());
        int treasureXp = 0;
        ItemStack treasureDrop = null;
        Player player = this.getPlayer();
        FishingTreasure treasure = null;
        boolean fishingSucceeds = false;
        if (mcMMO.p.getGeneralConfig().getFishingDropsEnabled() && Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.FISHING_TREASURE_HUNTER)) {
            treasure = this.getFishingTreasure();
            this.fishingCatch = null;
        }
        if (treasure != null) {
            McMMOPlayerFishingTreasureEvent event;
            treasureDrop = treasure instanceof FishingTreasureBook ? ItemUtils.createEnchantBook((FishingTreasureBook)treasure) : treasure.getDrop().clone();
            Map<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
            if (treasure instanceof FishingTreasureBook) {
                if (treasureDrop.getItemMeta() != null) {
                    enchants.putAll(treasureDrop.getItemMeta().getEnchants());
                }
                event = EventUtils.callFishingTreasureEvent(this.mmoPlayer, treasureDrop, treasure.getXp(), enchants);
            } else {
                if (this.isMagicHunterEnabled() && ItemUtils.isEnchantable(treasureDrop)) {
                    enchants = this.processMagicHunter(treasureDrop);
                }
                event = EventUtils.callFishingTreasureEvent(this.mmoPlayer, treasureDrop, treasure.getXp(), enchants);
            }
            if (!event.isCancelled()) {
                treasureDrop = event.getTreasure();
                treasureXp = event.getXp();
                if (treasureDrop != null) {
                    fishingSucceeds = true;
                    boolean enchanted = false;
                    if (treasure instanceof FishingTreasureBook) {
                        enchanted = true;
                    } else if (!enchants.isEmpty()) {
                        treasureDrop.addUnsafeEnchantments(enchants);
                        enchanted = true;
                    }
                    if (enchanted) {
                        NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Fishing.Ability.TH.MagicFound");
                    }
                }
            } else {
                treasureDrop = null;
                treasureXp = 0;
            }
        }
        if (fishingSucceeds) {
            if (mcMMO.p.getGeneralConfig().getFishingExtraFish()) {
                ItemUtils.spawnItem(this.getPlayer(), player.getEyeLocation(), fishingCatch.getItemStack(), ItemSpawnReason.FISHING_EXTRA_FISH);
            }
            fishingCatch.setItemStack(treasureDrop);
        }
        this.applyXpGain(fishXp + treasureXp, XPGainReason.PVE);
    }

    public int handleVanillaXpBoost(int experience) {
        return experience * this.getVanillaXpMultiplier();
    }

    public Location getHookLocation() {
        return this.hookLocation;
    }

    public void shakeCheck(@NotNull LivingEntity target) {
        if (ProbabilityUtil.isStaticSkillRNGSuccessful(PrimarySkillType.FISHING, this.mmoPlayer, this.getShakeChance())) {
            List<ShakeTreasure> possibleDrops = Fishing.findPossibleDrops(target);
            if (possibleDrops == null || possibleDrops.isEmpty()) {
                return;
            }
            ItemStack drop = Fishing.chooseDrop(possibleDrops);
            if (drop == null) {
                return;
            }
            switch (target.getType()) {
                case PLAYER: {
                    Player targetPlayer = (Player)target;
                    switch (drop.getType()) {
                        case PLAYER_HEAD: {
                            drop.setDurability((short)3);
                            SkullMeta skullMeta = (SkullMeta)drop.getItemMeta();
                            skullMeta.setOwningPlayer((OfflinePlayer)targetPlayer);
                            drop.setItemMeta((ItemMeta)skullMeta);
                            break;
                        }
                        case BEDROCK: {
                            if (!FishingTreasureConfig.getInstance().getInventoryStealEnabled()) break;
                            PlayerInventory inventory = targetPlayer.getInventory();
                            int length = inventory.getContents().length;
                            int slot = Misc.getRandom().nextInt(length);
                            drop = inventory.getItem(slot);
                            if (drop == null) break;
                            if (FishingTreasureConfig.getInstance().getInventoryStealStacks()) {
                                inventory.setItem(slot, null);
                                break;
                            }
                            inventory.setItem(slot, drop.getAmount() > 1 ? new ItemStack(drop.getType(), drop.getAmount() - 1) : null);
                            drop.setAmount(1);
                            break;
                        }
                    }
                    break;
                }
                case SHEEP: {
                    Sheep sheep = (Sheep)target;
                    if (!drop.getType().name().endsWith("WOOL")) break;
                    if (sheep.isSheared()) {
                        return;
                    }
                    sheep.setSheared(true);
                    break;
                }
            }
            McMMOPlayerShakeEvent shakeEvent = new McMMOPlayerShakeEvent(this.getPlayer(), drop);
            drop = shakeEvent.getDrop();
            if (shakeEvent.isCancelled() || drop == null) {
                return;
            }
            ItemUtils.spawnItem(this.getPlayer(), target.getLocation(), drop, ItemSpawnReason.FISHING_SHAKE_TREASURE);
            double dmg = Math.min(Math.max(target.getMaxHealth() / 4.0, 1.0), 10.0);
            CombatUtils.safeDealDamage(target, dmg, (Entity)this.getPlayer());
            this.applyXpGain(ExperienceConfig.getInstance().getFishingShakeXP(), XPGainReason.PVE);
        }
    }

    @Nullable
    private FishingTreasure getFishingTreasure() {
        double diceRoll = Misc.getRandom().nextDouble() * 100.0;
        int luck = this.getPlayer().getInventory().getItemInMainHand().getType() == Material.FISHING_ROD ? this.getPlayer().getInventory().getItemInMainHand().getEnchantmentLevel(mcMMO.p.getEnchantmentMapper().getLuckOfTheSea()) : this.getPlayer().getInventory().getItemInOffHand().getEnchantmentLevel(mcMMO.p.getEnchantmentMapper().getLuckOfTheSea());
        diceRoll *= 1.0 - (double)luck * mcMMO.p.getGeneralConfig().getFishingLureModifier() / 100.0;
        Treasure treasure = null;
        for (Rarity rarity : Rarity.values()) {
            double dropRate = FishingTreasureConfig.getInstance().getItemDropRate(this.getLootTier(), rarity);
            if (diceRoll <= dropRate) {
                List<FishingTreasure> fishingTreasures = FishingTreasureConfig.getInstance().fishingRewards.get((Object)rarity);
                if (fishingTreasures.isEmpty()) {
                    return null;
                }
                treasure = fishingTreasures.get(Misc.getRandom().nextInt(fishingTreasures.size()));
                break;
            }
            diceRoll -= dropRate;
        }
        if (treasure == null) {
            return null;
        }
        ItemStack treasureDrop = treasure.getDrop().clone();
        short maxDurability = treasureDrop.getType().getMaxDurability();
        if (maxDurability > 0) {
            treasureDrop.setDurability((short)Misc.getRandom().nextInt(maxDurability));
        }
        treasure.setDrop(treasureDrop);
        return treasure;
    }

    private Map<Enchantment, Integer> processMagicHunter(@NotNull ItemStack treasureDrop) {
        HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
        List<EnchantmentTreasure> fishingEnchantments = null;
        double diceRoll = Misc.getRandom().nextDouble() * 100.0;
        for (Rarity rarity : Rarity.values()) {
            double dropRate = FishingTreasureConfig.getInstance().getEnchantmentDropRate(this.getLootTier(), rarity);
            if (diceRoll <= dropRate) {
                if (treasureDrop.getType() == Material.ENCHANTED_BOOK) {
                    diceRoll = dropRate + 1.0;
                    continue;
                }
                fishingEnchantments = FishingTreasureConfig.getInstance().fishingEnchantments.get((Object)rarity);
                break;
            }
            diceRoll -= dropRate;
        }
        if (fishingEnchantments == null) {
            return enchants;
        }
        List<Enchantment> validEnchantments = this.getPossibleEnchantments(treasureDrop);
        ArrayList<EnchantmentTreasure> possibleEnchants = new ArrayList<EnchantmentTreasure>();
        for (EnchantmentTreasure enchantmentTreasure : fishingEnchantments) {
            if (!validEnchantments.contains(enchantmentTreasure.getEnchantment())) continue;
            possibleEnchants.add(enchantmentTreasure);
        }
        if (possibleEnchants.isEmpty()) {
            return enchants;
        }
        Collections.shuffle(possibleEnchants, Misc.getRandom());
        int specificChance = 1;
        for (EnchantmentTreasure enchantmentTreasure : possibleEnchants) {
            Enchantment possibleEnchantment = enchantmentTreasure.getEnchantment();
            if (treasureDrop.getItemMeta().hasConflictingEnchant(possibleEnchantment) || Misc.getRandom().nextInt(specificChance) != 0) continue;
            enchants.put(possibleEnchantment, enchantmentTreasure.getLevel());
            specificChance *= 2;
        }
        return enchants;
    }

    private List<Enchantment> getPossibleEnchantments(ItemStack treasureDrop) {
        Material dropType = treasureDrop.getType();
        if (Fishing.ENCHANTABLE_CACHE.containsKey(dropType)) {
            return Fishing.ENCHANTABLE_CACHE.get(dropType);
        }
        ArrayList<Enchantment> possibleEnchantments = new ArrayList<Enchantment>();
        for (Enchantment enchantment : Enchantment.values()) {
            if (!enchantment.canEnchantItem(treasureDrop)) continue;
            possibleEnchantments.add(enchantment);
        }
        Fishing.ENCHANTABLE_CACHE.put(dropType, possibleEnchantments);
        return possibleEnchantments;
    }

    private int getVanillaXpMultiplier() {
        return this.getVanillaXPBoostModifier();
    }

    public int getMasterAnglerMinWaitLowerBound() {
        return this.masterAnglerMinWaitLowerBound;
    }

    public int getMasterAnglerMaxWaitLowerBound() {
        return this.masterAnglerMaxWaitLowerBound;
    }
}

