/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.platform;

import com.gmail.nossr50.util.platform.BukkitPlatform;
import com.gmail.nossr50.util.platform.MinecraftGameVersion;
import com.gmail.nossr50.util.platform.Platform;
import com.gmail.nossr50.util.platform.ServerSoftwareType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformBuilder {
    private MinecraftGameVersion minecraftGameVersion;
    private ServerSoftwareType serverSoftwareType;

    public PlatformBuilder setMinecraftGameVersion(@NotNull MinecraftGameVersion minecraftGameVersion) {
        this.minecraftGameVersion = minecraftGameVersion;
        return this;
    }

    public PlatformBuilder setSoftwareType(@NotNull ServerSoftwareType softwareType) {
        this.serverSoftwareType = softwareType;
        return this;
    }

    @Nullable
    public Platform build() {
        return switch (this.serverSoftwareType) {
            case ServerSoftwareType.PAPER, ServerSoftwareType.SPIGOT, ServerSoftwareType.CRAFT_BUKKIT -> this.createBukkitPlatform();
            default -> null;
        };
    }

    private BukkitPlatform createBukkitPlatform() {
        return new BukkitPlatform(this.minecraftGameVersion);
    }
}

