/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50;

import com.gmail.nossr50.chat.ChatManager;
import com.gmail.nossr50.commands.CommandManager;
import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.CoreSkillsConfig;
import com.gmail.nossr50.config.CustomItemSupportConfig;
import com.gmail.nossr50.config.GeneralConfig;
import com.gmail.nossr50.config.HiddenConfig;
import com.gmail.nossr50.config.RankConfig;
import com.gmail.nossr50.config.SoundConfig;
import com.gmail.nossr50.config.WorldBlacklist;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.config.party.PartyConfig;
import com.gmail.nossr50.config.skills.alchemy.PotionConfig;
import com.gmail.nossr50.config.skills.repair.RepairConfigManager;
import com.gmail.nossr50.config.skills.salvage.SalvageConfigManager;
import com.gmail.nossr50.config.treasure.FishingTreasureConfig;
import com.gmail.nossr50.config.treasure.TreasureConfig;
import com.gmail.nossr50.database.DatabaseManager;
import com.gmail.nossr50.database.DatabaseManagerFactory;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.subskills.acrobatics.Roll;
import com.gmail.nossr50.listeners.BlockListener;
import com.gmail.nossr50.listeners.ChunkListener;
import com.gmail.nossr50.listeners.EntityListener;
import com.gmail.nossr50.listeners.InteractionManager;
import com.gmail.nossr50.listeners.InventoryListener;
import com.gmail.nossr50.listeners.PlayerListener;
import com.gmail.nossr50.listeners.SelfListener;
import com.gmail.nossr50.listeners.WorldListener;
import com.gmail.nossr50.mcmmo.folialib.FoliaLib;
import com.gmail.nossr50.mcmmo.kyori.adventure.platform.bukkit.BukkitAudiences;
import com.gmail.nossr50.mcmmo.metrics.bstats.bukkit.Metrics;
import com.gmail.nossr50.mcmmo.metrics.bstats.charts.SimplePie;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.placeholders.PapiExpansion;
import com.gmail.nossr50.runnables.SaveTimerTask;
import com.gmail.nossr50.runnables.backups.CleanBackupsTask;
import com.gmail.nossr50.runnables.commands.NotifySquelchReminderTask;
import com.gmail.nossr50.runnables.database.UserPurgeTask;
import com.gmail.nossr50.runnables.party.PartyAutoKickTask;
import com.gmail.nossr50.runnables.player.ClearRegisteredXPGainTask;
import com.gmail.nossr50.runnables.player.PlayerProfileLoadingTask;
import com.gmail.nossr50.runnables.player.PowerLevelUpdatingTask;
import com.gmail.nossr50.skills.alchemy.Alchemy;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import com.gmail.nossr50.skills.repair.repairables.RepairableManager;
import com.gmail.nossr50.skills.repair.repairables.SimpleRepairableManager;
import com.gmail.nossr50.skills.salvage.salvageables.Salvageable;
import com.gmail.nossr50.skills.salvage.salvageables.SalvageableManager;
import com.gmail.nossr50.skills.salvage.salvageables.SimpleSalvageableManager;
import com.gmail.nossr50.util.ChimaeraWing;
import com.gmail.nossr50.util.EnchantmentMapper;
import com.gmail.nossr50.util.LogFilter;
import com.gmail.nossr50.util.LogUtils;
import com.gmail.nossr50.util.MaterialMapStore;
import com.gmail.nossr50.util.MetadataConstants;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.TransientEntityTracker;
import com.gmail.nossr50.util.TransientMetadataTools;
import com.gmail.nossr50.util.blockmeta.ChunkManager;
import com.gmail.nossr50.util.blockmeta.ChunkManagerFactory;
import com.gmail.nossr50.util.blockmeta.UserBlockTracker;
import com.gmail.nossr50.util.commands.CommandRegistrationManager;
import com.gmail.nossr50.util.compat.CompatibilityManager;
import com.gmail.nossr50.util.experience.FormulaManager;
import com.gmail.nossr50.util.platform.PlatformManager;
import com.gmail.nossr50.util.platform.ServerSoftwareType;
import com.gmail.nossr50.util.player.PlayerLevelUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillTools;
import com.gmail.nossr50.util.upgrade.UpgradeManager;
import com.gmail.nossr50.worldguard.WorldGuardManager;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.shatteredlands.shatt.backup.ZipLibrary;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Recipe;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class mcMMO
extends JavaPlugin {
    private static PlatformManager platformManager;
    private static ChunkManager chunkManager;
    private static RepairableManager repairableManager;
    private static SalvageableManager salvageableManager;
    private static DatabaseManager databaseManager;
    private static FormulaManager formulaManager;
    private static UpgradeManager upgradeManager;
    private static MaterialMapStore materialMapStore;
    private static PlayerLevelUtils playerLevelUtils;
    private static TransientMetadataTools transientMetadataTools;
    private static ChatManager chatManager;
    private static CommandManager commandManager;
    private static TransientEntityTracker transientEntityTracker;
    private SkillTools skillTools;
    private static boolean serverShutdownExecuted;
    private static BukkitAudiences audiences;
    private static WorldBlacklist worldBlacklist;
    private static String mainDirectory;
    private static String localesDirectory;
    private static String flatFileDirectory;
    private static String usersFile;
    private static String modDirectory;
    public static mcMMO p;
    public static File mcmmo;
    private static boolean healthBarPluginEnabled;
    private static boolean projectKorraEnabled;
    private static boolean serverAPIOutdated;
    public boolean noErrorsInConfigFiles = true;
    private boolean xpEventEnabled;
    private static boolean isRetroModeEnabled;
    private long purgeTime = 2630000000L;
    private GeneralConfig generalConfig;
    private AdvancedConfig advancedConfig;
    private PartyConfig partyConfig;
    private PotionConfig potionConfig;
    private CustomItemSupportConfig customItemSupportConfig;
    private EnchantmentMapper enchantmentMapper;
    private FoliaLib foliaLib;
    private PartyManager partyManager;

    public mcMMO() {
        p = this;
    }

    public void onEnable() {
        try {
            this.getLogger().setFilter(new LogFilter(this));
            platformManager = new PlatformManager();
            this.foliaLib = new FoliaLib((Plugin)this);
            this.foliaLib.getOptions().disableNotifications();
            this.foliaLib.getOptions().disableIsValidOnNonFolia();
            this.setupFilePaths();
            this.generalConfig = new GeneralConfig(this.getDataFolder());
            this.skillTools = new SkillTools(this);
            this.advancedConfig = new AdvancedConfig(this.getDataFolder());
            this.partyConfig = new PartyConfig(this.getDataFolder());
            this.customItemSupportConfig = new CustomItemSupportConfig(this.getDataFolder());
            isRetroModeEnabled = this.generalConfig.getIsRetroMode();
            MetadataConstants.MCMMO_METADATA_VALUE = new FixedMetadataValue((Plugin)this, (Object)true);
            PluginManager pluginManager = this.getServer().getPluginManager();
            healthBarPluginEnabled = pluginManager.getPlugin("HealthBar") != null;
            projectKorraEnabled = pluginManager.getPlugin("ProjectKorra") != null;
            upgradeManager = new UpgradeManager();
            materialMapStore = new MaterialMapStore();
            this.enchantmentMapper = new EnchantmentMapper(this);
            this.loadConfigFiles();
            if (!this.noErrorsInConfigFiles) {
                return;
            }
            if (this.getServer().getName().equals("Cauldron") || this.getServer().getName().equals("MCPC+")) {
                this.checkModConfigs();
            }
            if (projectKorraEnabled) {
                this.getLogger().info("ProjectKorra was detected, this can cause some issues with weakness potions and combat skills for mcMMO");
            }
            if (healthBarPluginEnabled) {
                this.getLogger().info("HealthBar plugin found, mcMMO's healthbars are automatically disabled.");
            }
            if (pluginManager.getPlugin("NoCheatPlus") != null && pluginManager.getPlugin("CompatNoCheatPlus") == null) {
                this.getLogger().warning("NoCheatPlus plugin found, but CompatNoCheatPlus was not found!");
                this.getLogger().warning("mcMMO will not work properly alongside NoCheatPlus without CompatNoCheatPlus");
            }
            this.purgeTime = 2630000000L * (long)this.generalConfig.getOldUsersCutoff();
            databaseManager = DatabaseManagerFactory.getDatabaseManager(mcMMO.getUsersFilePath(), this.getLogger(), this.purgeTime, p.getAdvancedConfig().getStartingLevel());
            this.checkForOutdatedAPI();
            if (serverAPIOutdated) {
                this.foliaLib.getScheduler().runTimer(() -> this.getLogger().severe("You are running an outdated version of " + String.valueOf((Object)platformManager.getServerSoftware()) + ", mcMMO will not work unless you update to a newer version!"), 20L, 36000L);
                if (platformManager.getServerSoftware() == ServerSoftwareType.CRAFT_BUKKIT) {
                    this.foliaLib.getScheduler().runTimer(() -> this.getLogger().severe("We have detected you are using incompatible server software, our best guess is that you are using CraftBukkit. mcMMO requires Spigot or Paper, if you are not using CraftBukkit, you will still need to update your custom server software before mcMMO will work."), 20L, 36000L);
                }
            } else {
                this.registerEvents();
                this.registerCoreSkills();
                this.registerCustomRecipes();
                if (this.partyConfig.isPartyEnabled()) {
                    this.partyManager = new PartyManager(this);
                    this.partyManager.loadParties();
                }
                formulaManager = new FormulaManager();
                for (Player player : this.getServer().getOnlinePlayers()) {
                    this.getFoliaLib().getScheduler().runLaterAsync(new PlayerProfileLoadingTask(player), 1L);
                }
                LogUtils.debug(p.getLogger(), "Version " + this.getDescription().getVersion() + " is enabled!");
                this.scheduleTasks();
                CommandRegistrationManager.registerCommands();
                chunkManager = ChunkManagerFactory.getChunkManager();
                if (this.generalConfig.getPTPCommandWorldPermissions()) {
                    Permissions.generateWorldTeleportPermissions();
                }
                RankUtils.populateRanks();
            }
            if (this.generalConfig.getIsMetricsEnabled()) {
                Metrics metrics = new Metrics(this, 3894);
                metrics.addCustomChart(new SimplePie("version", () -> this.getDescription().getVersion()));
                if (this.generalConfig.getIsRetroMode()) {
                    metrics.addCustomChart(new SimplePie("leveling_system", () -> "Retro"));
                } else {
                    metrics.addCustomChart(new SimplePie("leveling_system", () -> "Standard"));
                }
            }
        }
        catch (Throwable t) {
            this.getLogger().log(Level.SEVERE, "There was an error while enabling mcMMO!", t);
            if (t instanceof ExceptionInInitializerError) {
                this.getLogger().info("Please do not replace the mcMMO jar while the server is running.");
            }
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        playerLevelUtils = new PlayerLevelUtils();
        worldBlacklist = new WorldBlacklist(this);
        audiences = BukkitAudiences.create((Plugin)this);
        transientMetadataTools = new TransientMetadataTools(this);
        chatManager = new ChatManager(this);
        commandManager = new CommandManager(this);
        transientEntityTracker = new TransientEntityTracker();
        mcMMO.setServerShutdown(false);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PapiExpansion().register();
        }
    }

    public static PlayerLevelUtils getPlayerLevelUtils() {
        return playerLevelUtils;
    }

    public static MaterialMapStore getMaterialMapStore() {
        return materialMapStore;
    }

    private void checkForOutdatedAPI() {
        try {
            Class<?> checkForClass = Class.forName("org.bukkit.event.block.BlockDropItemEvent");
            checkForClass.getMethod("getItems", new Class[0]);
            Class.forName("net.md_5.bungee.api.chat.BaseComponent");
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            serverAPIOutdated = true;
            String software = platformManager.getServerSoftwareStr();
            this.getLogger().severe("You are running an older version of " + software + " that is not compatible with mcMMO, update your server software!");
        }
    }

    public void onLoad() {
        if (this.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
            WorldGuardManager.getInstance().registerFlags();
        }
    }

    public void onDisable() {
        mcMMO.setServerShutdown(true);
        p.getLogger().info("Server shutdown has been executed, saving and cleaning up data...");
        try {
            UserManager.saveAll();
            UserManager.clearAll();
            Alchemy.finishAllBrews();
            if (this.partyConfig.isPartyEnabled()) {
                this.getPartyManager().saveParties();
            }
            if (this.generalConfig.getScoreboardsEnabled()) {
                ScoreboardManager.teardownAll();
            }
            formulaManager.saveFormula();
            chunkManager.closeAll();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "An error occurred while disabling mcMMO!", e);
        }
        if (this.generalConfig.getBackupsEnabled()) {
            try {
                ZipLibrary.mcMMOBackup();
            }
            catch (NoClassDefFoundError e) {
                this.getLogger().severe("Backup class not found!");
                this.getLogger().info("Please do not replace the mcMMO jar while the server is running.");
            }
            catch (Throwable e) {
                this.getLogger().severe(e.toString());
            }
        }
        LogUtils.debug(p.getLogger(), "Canceling all tasks...");
        this.getFoliaLib().getScheduler().cancelAllTasks();
        LogUtils.debug(p.getLogger(), "Unregister all events...");
        HandlerList.unregisterAll((Plugin)this);
        databaseManager.onDisable();
        LogUtils.debug(p.getLogger(), "Was disabled.");
    }

    public static String getMainDirectory() {
        return mainDirectory;
    }

    public static String getLocalesDirectory() {
        return localesDirectory;
    }

    public static String getFlatFileDirectory() {
        return flatFileDirectory;
    }

    public static String getUsersFilePath() {
        return usersFile;
    }

    public static String getModDirectory() {
        return modDirectory;
    }

    public boolean isXPEventEnabled() {
        return this.xpEventEnabled;
    }

    public void setXPEventEnabled(boolean enabled) {
        this.xpEventEnabled = enabled;
    }

    public void toggleXpEventEnabled() {
        this.xpEventEnabled = !this.xpEventEnabled;
    }

    public static FormulaManager getFormulaManager() {
        return formulaManager;
    }

    public static UserBlockTracker getUserBlockTracker() {
        return chunkManager;
    }

    public static ChunkManager getChunkManager() {
        return chunkManager;
    }

    @Deprecated(since="2.2.013", forRemoval=true)
    public static ChunkManager getPlaceStore() {
        return chunkManager;
    }

    public static RepairableManager getRepairableManager() {
        return repairableManager;
    }

    public static SalvageableManager getSalvageableManager() {
        return salvageableManager;
    }

    public static DatabaseManager getDatabaseManager() {
        return databaseManager;
    }

    public static UpgradeManager getUpgradeManager() {
        return upgradeManager;
    }

    @Nullable
    public static CompatibilityManager getCompatibilityManager() {
        return platformManager.getCompatibilityManager();
    }

    @Deprecated
    public static void setDatabaseManager(DatabaseManager databaseManager) {
        mcMMO.databaseManager = databaseManager;
    }

    public static boolean isHealthBarPluginEnabled() {
        return healthBarPluginEnabled;
    }

    private void setupFilePaths() {
        mcmmo = this.getFile();
        mainDirectory = this.getDataFolder().getPath() + File.separator;
        localesDirectory = mainDirectory + "locales" + File.separator;
        flatFileDirectory = mainDirectory + "flatfile" + File.separator;
        usersFile = flatFileDirectory + "mcmmo.users";
        modDirectory = mainDirectory + "mods" + File.separator;
        this.fixFilePaths();
    }

    private void fixFilePaths() {
        File oldFlatfilePath = new File(mainDirectory + "FlatFileStuff" + File.separator);
        File oldModPath = new File(mainDirectory + "ModConfigs" + File.separator);
        if (oldFlatfilePath.exists() && !oldFlatfilePath.renameTo(new File(flatFileDirectory))) {
            this.getLogger().warning("Failed to rename FlatFileStuff to flatfile!");
        }
        if (oldModPath.exists() && !oldModPath.renameTo(new File(modDirectory))) {
            this.getLogger().warning("Failed to rename ModConfigs to mods!");
        }
        File oldArmorFile = new File(modDirectory + "armor.yml");
        File oldBlocksFile = new File(modDirectory + "blocks.yml");
        File oldEntitiesFile = new File(modDirectory + "entities.yml");
        File oldToolsFile = new File(modDirectory + "tools.yml");
        if (oldArmorFile.exists() && !oldArmorFile.renameTo(new File(modDirectory + "armor.default.yml"))) {
            this.getLogger().warning("Failed to rename armor.yml to armor.default.yml!");
        }
        if (oldBlocksFile.exists() && !oldBlocksFile.renameTo(new File(modDirectory + "blocks.default.yml"))) {
            this.getLogger().warning("Failed to rename blocks.yml to blocks.default.yml!");
        }
        if (oldEntitiesFile.exists() && !oldEntitiesFile.renameTo(new File(modDirectory + "entities.default.yml"))) {
            this.getLogger().warning("Failed to rename entities.yml to entities.default.yml!");
        }
        if (oldToolsFile.exists() && !oldToolsFile.renameTo(new File(modDirectory + "tools.default.yml"))) {
            this.getLogger().warning("Failed to rename tools.yml to tools.default.yml!");
        }
        File currentFlatfilePath = new File(flatFileDirectory);
        currentFlatfilePath.mkdirs();
        File localesDirectoryPath = new File(localesDirectory);
        localesDirectoryPath.mkdirs();
    }

    private void loadConfigFiles() {
        TreasureConfig.getInstance();
        FishingTreasureConfig.getInstance();
        HiddenConfig.getInstance();
        this.potionConfig = new PotionConfig();
        this.potionConfig.loadPotions();
        CoreSkillsConfig.getInstance();
        SoundConfig.getInstance();
        RankConfig.getInstance();
        ArrayList<Repairable> repairables = new ArrayList<Repairable>(new RepairConfigManager(this).getLoadedRepairables());
        repairableManager = new SimpleRepairableManager(repairables.size());
        repairableManager.registerRepairables(repairables);
        SalvageConfigManager sManager = new SalvageConfigManager(this);
        List<Salvageable> salvageables = sManager.getLoadedSalvageables();
        salvageableManager = new SimpleSalvageableManager(salvageables.size());
        salvageableManager.registerSalvageables(salvageables);
    }

    private void registerEvents() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new BlockListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new EntityListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new InventoryListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new SelfListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new WorldListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new ChunkListener(), (Plugin)this);
    }

    private void registerCoreSkills() {
        InteractionManager.initMaps();
        if (CoreSkillsConfig.getInstance().isPrimarySkillEnabled(PrimarySkillType.ACROBATICS)) {
            LogUtils.debug(p.getLogger(), "Enabling Acrobatics Skills");
            Roll roll = new Roll();
            CoreSkillsConfig.getInstance().isSkillEnabled(roll);
            InteractionManager.registerSubSkill(new Roll());
        }
    }

    private void registerCustomRecipes() {
        this.getFoliaLib().getScheduler().runLater(() -> {
            if (this.generalConfig.getChimaeraEnabled()) {
                this.getServer().addRecipe((Recipe)ChimaeraWing.getChimaeraWingRecipe());
            }
        }, 40L);
    }

    private void scheduleTasks() {
        long second = 20L;
        long minute = second * 60L;
        long saveIntervalTicks = Math.max(minute, (long)this.generalConfig.getSaveInterval() * minute);
        this.getFoliaLib().getScheduler().runTimer(new SaveTimerTask(), saveIntervalTicks, saveIntervalTicks);
        this.getFoliaLib().getScheduler().runAsync(new CleanBackupsTask());
        long purgeIntervalTicks = (long)this.generalConfig.getPurgeInterval() * 60L * 60L * 20L;
        if (purgeIntervalTicks == 0L) {
            this.getFoliaLib().getScheduler().runLaterAsync(new UserPurgeTask(), 40L);
        } else if (purgeIntervalTicks > 0L) {
            this.getFoliaLib().getScheduler().runTimerAsync(new UserPurgeTask(), purgeIntervalTicks, purgeIntervalTicks);
        }
        if (this.partyConfig.isPartyEnabled()) {
            long kickIntervalTicks = (long)this.generalConfig.getAutoPartyKickInterval() * 60L * 60L * 20L;
            if (kickIntervalTicks == 0L) {
                this.getFoliaLib().getScheduler().runLater(new PartyAutoKickTask(), 40L);
            } else if (kickIntervalTicks > 0L) {
                this.getFoliaLib().getScheduler().runTimer(new PartyAutoKickTask(), kickIntervalTicks, kickIntervalTicks);
            }
        }
        this.getFoliaLib().getScheduler().runTimer(new PowerLevelUpdatingTask(), 40L, 40L);
        if (ExperienceConfig.getInstance().getDiminishedReturnsEnabled()) {
            this.getFoliaLib().getScheduler().runTimer(new ClearRegisteredXPGainTask(), 60L, 60L);
        }
        if (p.getAdvancedConfig().allowPlayerTips()) {
            this.getFoliaLib().getScheduler().runTimer(new NotifySquelchReminderTask(), 60L, 72000L);
        }
    }

    private void checkModConfigs() {
        if (!this.generalConfig.getToolModsEnabled()) {
            this.getLogger().warning("Cauldron implementation found, but the custom tool config for mcMMO is disabled!");
            this.getLogger().info("To enable, set Mods.Tool_Mods_Enabled to TRUE in config.yml.");
        }
        if (!this.generalConfig.getArmorModsEnabled()) {
            this.getLogger().warning("Cauldron implementation found, but the custom armor config for mcMMO is disabled!");
            this.getLogger().info("To enable, set Mods.Armor_Mods_Enabled to TRUE in config.yml.");
        }
        if (!this.generalConfig.getBlockModsEnabled()) {
            this.getLogger().warning("Cauldron implementation found, but the custom block config for mcMMO is disabled!");
            this.getLogger().info("To enable, set Mods.Block_Mods_Enabled to TRUE in config.yml.");
        }
        if (!this.generalConfig.getEntityModsEnabled()) {
            this.getLogger().warning("Cauldron implementation found, but the custom entity config for mcMMO is disabled!");
            this.getLogger().info("To enable, set Mods.Entity_Mods_Enabled to TRUE in config.yml.");
        }
    }

    @Nullable
    public InputStreamReader getResourceAsReader(@NotNull String fileName) {
        InputStream in = this.getResource(fileName);
        return in == null ? null : new InputStreamReader(in, StandardCharsets.UTF_8);
    }

    public static boolean isRetroModeEnabled() {
        return isRetroModeEnabled;
    }

    public static WorldBlacklist getWorldBlacklist() {
        return worldBlacklist;
    }

    public static PlatformManager getPlatformManager() {
        return platformManager;
    }

    public static BukkitAudiences getAudiences() {
        return audiences;
    }

    public static boolean isProjectKorraEnabled() {
        return projectKorraEnabled;
    }

    public static TransientMetadataTools getTransientMetadataTools() {
        return transientMetadataTools;
    }

    public ChatManager getChatManager() {
        return chatManager;
    }

    public CommandManager getCommandManager() {
        return commandManager;
    }

    public static TransientEntityTracker getTransientEntityTracker() {
        return transientEntityTracker;
    }

    public static synchronized boolean isServerShutdownExecuted() {
        return serverShutdownExecuted;
    }

    private static synchronized void setServerShutdown(boolean bool) {
        serverShutdownExecuted = bool;
    }

    public long getPurgeTime() {
        return this.purgeTime;
    }

    @NotNull
    public SkillTools getSkillTools() {
        return this.skillTools;
    }

    @NotNull
    public GeneralConfig getGeneralConfig() {
        return this.generalConfig;
    }

    @NotNull
    public AdvancedConfig getAdvancedConfig() {
        return this.advancedConfig;
    }

    @NotNull
    public PartyConfig getPartyConfig() {
        return this.partyConfig;
    }

    public boolean isPartySystemEnabled() {
        return this.partyConfig.isPartyEnabled();
    }

    public PartyManager getPartyManager() {
        return this.partyManager;
    }

    public CustomItemSupportConfig getCustomItemSupportConfig() {
        return this.customItemSupportConfig;
    }

    public PotionConfig getPotionConfig() {
        return this.potionConfig;
    }

    public EnchantmentMapper getEnchantmentMapper() {
        return this.enchantmentMapper;
    }

    @NotNull
    public FoliaLib getFoliaLib() {
        return this.foliaLib;
    }

    static {
        serverShutdownExecuted = false;
        serverAPIOutdated = false;
    }
}

