/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.blockmeta;

import com.gmail.nossr50.util.blockmeta.BitSetChunkStore;
import com.gmail.nossr50.util.blockmeta.ChunkManager;
import com.gmail.nossr50.util.blockmeta.ChunkStore;
import com.gmail.nossr50.util.blockmeta.McMMOSimpleRegionFile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HashChunkManager
implements ChunkManager {
    private final HashMap<CoordinateKey, McMMOSimpleRegionFile> regionMap = new HashMap();
    private final HashMap<CoordinateKey, HashSet<CoordinateKey>> chunkUsageMap = new HashMap();
    private final HashMap<CoordinateKey, ChunkStore> chunkMap = new HashMap();

    @Override
    public synchronized void closeAll() {
        for (ChunkStore chunkStore : this.chunkMap.values()) {
            World world;
            if (!chunkStore.isDirty() || (world = Bukkit.getWorld((UUID)chunkStore.getWorldId())) == null) continue;
            this.writeChunkStore(world, chunkStore);
        }
        this.chunkMap.clear();
        this.chunkUsageMap.clear();
        for (McMMOSimpleRegionFile rf : this.regionMap.values()) {
            rf.close();
        }
        this.regionMap.clear();
    }

    @Nullable
    private synchronized ChunkStore readChunkStore(@NotNull World world, int cx, int cz) throws IOException {
        McMMOSimpleRegionFile rf = this.getWriteableSimpleRegionFile(world, cx, cz);
        try (DataInputStream in = rf.getInputStream(cx, cz);){
            if (in == null) {
                ChunkStore chunkStore = null;
                return chunkStore;
            }
            ChunkStore chunkStore = BitSetChunkStore.Serialization.readChunkStore(in);
            return chunkStore;
        }
    }

    private synchronized void writeChunkStore(@NotNull World world, @NotNull ChunkStore data) {
        if (!data.isDirty()) {
            return;
        }
        try {
            McMMOSimpleRegionFile rf = this.getWriteableSimpleRegionFile(world, data.getChunkX(), data.getChunkZ());
            try (DataOutputStream out = rf.getOutputStream(data.getChunkX(), data.getChunkZ());){
                BitSetChunkStore.Serialization.writeChunkStore(out, data);
            }
            data.setDirty(false);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write chunk meta data for " + data.getChunkX() + ", " + data.getChunkZ(), e);
        }
    }

    @NotNull
    private synchronized McMMOSimpleRegionFile getWriteableSimpleRegionFile(@NotNull World world, int cx, int cz) {
        CoordinateKey regionKey = this.toRegionKey(world.getUID(), cx, cz);
        return this.regionMap.computeIfAbsent(regionKey, k -> {
            File regionFile = this.getRegionFile(world, regionKey);
            regionFile.getParentFile().mkdirs();
            return new McMMOSimpleRegionFile(regionFile, regionKey.x, regionKey.z);
        });
    }

    @NotNull
    private File getRegionFile(@NotNull World world, @NotNull CoordinateKey regionKey) {
        if (world.getUID() != regionKey.worldID) {
            throw new IllegalArgumentException();
        }
        return new File(new File(world.getWorldFolder(), "mcmmo_regions"), "mcmmo_" + regionKey.x + "_" + regionKey.z + "_.mcm");
    }

    @Nullable
    private ChunkStore loadChunk(int cx, int cz, @NotNull World world) {
        try {
            return this.readChunkStore(world, cx, cz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void unloadChunk(int cx, int cz, @NotNull World world) {
        CoordinateKey chunkKey = this.toChunkKey(world.getUID(), cx, cz);
        ChunkStore chunkStore = this.chunkMap.remove(chunkKey);
        if (chunkStore == null) {
            return;
        }
        if (chunkStore.isDirty()) {
            this.writeChunkStore(world, chunkStore);
        }
        CoordinateKey regionKey = this.toRegionKey(world.getUID(), cx, cz);
        HashSet<CoordinateKey> chunkKeys = this.chunkUsageMap.get(regionKey);
        chunkKeys.remove(chunkKey);
        if (chunkKeys.isEmpty()) {
            this.chunkUsageMap.remove(regionKey);
            this.regionMap.remove(regionKey).close();
        }
    }

    @Override
    public synchronized void chunkUnloaded(int cx, int cz, @NotNull World world) {
        this.unloadChunk(cx, cz, world);
    }

    @Override
    public synchronized void unloadWorld(@NotNull World world) {
        UUID wID = world.getUID();
        ArrayList<CoordinateKey> chunkKeys = new ArrayList<CoordinateKey>(this.chunkMap.keySet());
        for (CoordinateKey chunkKey : chunkKeys) {
            ChunkStore chunkStore;
            if (!wID.equals(chunkKey.worldID) || !(chunkStore = this.chunkMap.remove(chunkKey)).isDirty()) continue;
            try {
                this.writeChunkStore(world, chunkStore);
            }
            catch (Exception exception) {}
        }
        ArrayList<CoordinateKey> regionKeys = new ArrayList<CoordinateKey>(this.regionMap.keySet());
        for (CoordinateKey regionKey : regionKeys) {
            if (!wID.equals(regionKey.worldID)) continue;
            this.regionMap.remove(regionKey).close();
            this.chunkUsageMap.remove(regionKey);
        }
    }

    private synchronized boolean isIneligible(int x, int y, int z, @NotNull World world) {
        CoordinateKey chunkKey = this.blockCoordinateToChunkKey(world.getUID(), x, y, z);
        ChunkStore check = this.chunkMap.computeIfAbsent(chunkKey, k -> {
            ChunkStore loaded = this.loadChunk(chunkKey.x, chunkKey.z, world);
            if (loaded != null) {
                this.chunkUsageMap.computeIfAbsent(this.toRegionKey(chunkKey.worldID, chunkKey.x, chunkKey.z), j -> new HashSet()).add(chunkKey);
                return loaded;
            }
            this.chunkUsageMap.computeIfAbsent(this.toRegionKey(chunkKey.worldID, chunkKey.x, chunkKey.z), j -> new HashSet()).add(chunkKey);
            return new BitSetChunkStore(world, chunkKey.x, chunkKey.z);
        });
        int ix = Math.abs(x) % 16;
        int iz = Math.abs(z) % 16;
        return check.isTrue(ix, y, iz);
    }

    @Override
    public synchronized boolean isIneligible(@NotNull Block block) {
        return this.isIneligible(block.getX(), block.getY(), block.getZ(), block.getWorld());
    }

    @Override
    public synchronized boolean isIneligible(@NotNull BlockState blockState) {
        return this.isIneligible(blockState.getX(), blockState.getY(), blockState.getZ(), blockState.getWorld());
    }

    @Override
    public synchronized boolean isEligible(@NotNull Block block) {
        return !this.isIneligible(block);
    }

    @Override
    public synchronized boolean isEligible(@NotNull BlockState blockState) {
        return !this.isIneligible(blockState);
    }

    @Override
    public synchronized void setIneligible(@NotNull Block block) {
        this.set(block.getX(), block.getY(), block.getZ(), block.getWorld(), true);
    }

    @Override
    public synchronized void setIneligible(@NotNull BlockState blockState) {
        this.set(blockState.getX(), blockState.getY(), blockState.getZ(), blockState.getWorld(), true);
    }

    @Override
    public synchronized void setEligible(@NotNull Block block) {
        this.set(block.getX(), block.getY(), block.getZ(), block.getWorld(), false);
    }

    @Override
    public synchronized void setEligible(@NotNull BlockState blockState) {
        this.set(blockState.getX(), blockState.getY(), blockState.getZ(), blockState.getWorld(), false);
    }

    private synchronized void set(int x, int y, int z, @NotNull World world, boolean value) {
        CoordinateKey chunkKey = this.blockCoordinateToChunkKey(world.getUID(), x, y, z);
        ChunkStore cStore = this.chunkMap.computeIfAbsent(chunkKey, k -> {
            ChunkStore loaded = this.loadChunk(chunkKey.x, chunkKey.z, world);
            if (loaded != null) {
                this.chunkUsageMap.computeIfAbsent(this.toRegionKey(chunkKey.worldID, chunkKey.x, chunkKey.z), j -> new HashSet()).add(chunkKey);
                return loaded;
            }
            this.chunkUsageMap.computeIfAbsent(this.toRegionKey(chunkKey.worldID, chunkKey.x, chunkKey.z), j -> new HashSet()).add(chunkKey);
            return new BitSetChunkStore(world, chunkKey.x, chunkKey.z);
        });
        int ix = Math.abs(x) % 16;
        int iz = Math.abs(z) % 16;
        cStore.set(ix, y, iz, value);
    }

    @NotNull
    private CoordinateKey blockCoordinateToChunkKey(@NotNull UUID worldUid, int x, int y, int z) {
        return this.toChunkKey(worldUid, x >> 4, z >> 4);
    }

    @NotNull
    private CoordinateKey toChunkKey(@NotNull UUID worldUid, int cx, int cz) {
        return new CoordinateKey(worldUid, cx, cz);
    }

    @NotNull
    private CoordinateKey toRegionKey(@NotNull UUID worldUid, int cx, int cz) {
        int rx = cx >> 5;
        int rz = cz >> 5;
        return new CoordinateKey(worldUid, rx, rz);
    }

    private static final class CoordinateKey {
        @NotNull
        public final UUID worldID;
        public final int x;
        public final int z;

        private CoordinateKey(@NotNull UUID worldID, int x, int z) {
            this.worldID = worldID;
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CoordinateKey coordinateKey = (CoordinateKey)o;
            return this.x == coordinateKey.x && this.z == coordinateKey.z && this.worldID.equals(coordinateKey.worldID);
        }

        public int hashCode() {
            return Objects.hash(this.worldID, this.x, this.z);
        }
    }
}

