/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.player;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.commands.McTopCommandAsyncTask;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.text.StringUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class McTopCommand
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        PrimarySkillType skill = null;
        switch (args.length) {
            case 0: {
                this.display(1, skill, sender, command);
                return true;
            }
            case 1: {
                if (StringUtils.isInt(args[0])) {
                    this.display(Math.abs(Integer.parseInt(args[0])), skill, sender, command);
                    return true;
                }
                skill = this.extractSkill(sender, args[0]);
                if (skill == null) {
                    return true;
                }
                if (skill == PrimarySkillType.MACES && !mcMMO.getCompatibilityManager().getMinecraftGameVersion().isAtLeast(1, 21, 0)) {
                    return true;
                }
                this.display(1, skill, sender, command);
                return true;
            }
            case 2: {
                if (CommandUtils.isInvalidInteger(sender, args[1])) {
                    return true;
                }
                skill = this.extractSkill(sender, args[0]);
                if (skill == null) {
                    return true;
                }
                if (skill == PrimarySkillType.MACES && !mcMMO.getCompatibilityManager().getMinecraftGameVersion().isAtLeast(1, 21, 0)) {
                    return true;
                }
                this.display(Math.abs(Integer.parseInt(args[1])), skill, sender, command);
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], mcMMO.p.getSkillTools().LOCALIZED_SKILL_NAMES, new ArrayList(mcMMO.p.getSkillTools().LOCALIZED_SKILL_NAMES.size()));
        }
        return ImmutableList.of();
    }

    private void display(int page, PrimarySkillType skill, CommandSender sender, Command command) {
        if (skill != null && !Permissions.mctop((Permissible)sender, skill)) {
            sender.sendMessage(command.getPermissionMessage());
            return;
        }
        if (sender instanceof Player) {
            if (!CommandUtils.hasPlayerDataKey(sender)) {
                return;
            }
            McMMOPlayer mmoPlayer = UserManager.getPlayer(sender.getName());
            long cooldownMillis = Math.max(mcMMO.p.getGeneralConfig().getDatabasePlayerCooldown(), 1750L);
            if (mmoPlayer.getDatabaseATS() + cooldownMillis > System.currentTimeMillis()) {
                double seconds = (double)(mmoPlayer.getDatabaseATS() + cooldownMillis - System.currentTimeMillis()) / 1000.0;
                if (seconds < 1.0) {
                    seconds = 1.0;
                }
                sender.sendMessage(LocaleLoader.formatString(LocaleLoader.getString("Commands.Database.Cooldown"), seconds));
                return;
            }
            if (((Player)sender).hasMetadata("mcMMO: Processing Database Command")) {
                sender.sendMessage(LocaleLoader.getString("Commands.Database.Processing"));
                return;
            }
            ((Player)sender).setMetadata("mcMMO: Processing Database Command", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, null));
            mmoPlayer.actualizeDatabaseATS();
        }
        this.display(page, skill, sender);
    }

    private void display(int page, PrimarySkillType skill, CommandSender sender) {
        boolean useBoard = sender instanceof Player && mcMMO.p.getGeneralConfig().getTopUseBoard();
        boolean useChat = !useBoard || mcMMO.p.getGeneralConfig().getTopUseChat();
        mcMMO.p.getFoliaLib().getScheduler().runAsync(new McTopCommandAsyncTask(page, skill, sender, useBoard, useChat));
    }

    private PrimarySkillType extractSkill(CommandSender sender, String skillName) {
        if (CommandUtils.isInvalidSkill(sender, skillName)) {
            return null;
        }
        PrimarySkillType skill = mcMMO.p.getSkillTools().matchSkill(skillName);
        if (CommandUtils.isChildSkill(sender, skill)) {
            return null;
        }
        return skill;
    }
}

