/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.blockmeta;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.BitSet;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class McMMOSimpleRegionFile {
    private static final int DEFAULT_SEGMENT_EXPONENT = 10;
    private static final int DEFAULT_SEGMENT_SIZE = (int)Math.pow(2.0, 10.0);
    private static final int RESERVED_HEADER_BYTES = 12288;
    private static final int NUM_CHUNKS = 1024;
    private static final int SEEK_CHUNK_SEGMENT_INDICES = 0;
    private static final int SEEK_CHUNK_BYTE_LENGTHS = 4096;
    private static final int SEEK_FILE_INFO = 8192;
    private final int[] chunkSegmentIndex = new int[1024];
    private final int[] chunkNumBytes = new int[1024];
    private final int[] chunkNumSegments = new int[1024];
    private final BitSet segments = new BitSet();
    private final int segmentExponent;
    private final int segmentMask;
    @NotNull
    private final File parent;
    private final RandomAccessFile file;
    private final int rx;
    private final int rz;

    public McMMOSimpleRegionFile(@NotNull File f, int rx, int rz) {
        this.rx = rx;
        this.rz = rz;
        this.parent = f;
        try {
            int i;
            this.file = new RandomAccessFile(this.parent, "rw");
            if (this.file.length() < 12288L) {
                this.file.write(new byte[12288]);
                this.file.seek(8192L);
                this.file.writeInt(10);
            }
            this.file.seek(8192L);
            this.segmentExponent = this.file.readInt();
            this.segmentMask = (1 << this.segmentExponent) - 1;
            int reservedSegments = this.bytesToSegments(12288);
            this.segments.set(0, reservedSegments, true);
            this.file.seek(0L);
            for (i = 0; i < 1024; ++i) {
                this.chunkSegmentIndex[i] = this.file.readInt();
            }
            this.file.seek(4096L);
            for (i = 0; i < 1024; ++i) {
                this.chunkNumBytes[i] = this.file.readInt();
                this.chunkNumSegments[i] = this.bytesToSegments(this.chunkNumBytes[i]);
                this.markChunkSegments(i, true);
            }
            this.fixFileLength();
        }
        catch (IOException fnfe) {
            throw new RuntimeException(fnfe);
        }
    }

    @NotNull
    public synchronized DataOutputStream getOutputStream(int x, int z) {
        int index = this.getChunkIndex(x, z);
        return new DataOutputStream(new DeflaterOutputStream(new McMMOSimpleChunkBuffer(this, index)));
    }

    private synchronized void write(int index, byte[] buffer, int size) throws IOException {
        int oldSegmentIndex = this.chunkSegmentIndex[index];
        this.markChunkSegments(index, false);
        int newSegmentIndex = this.findContiguousSegments(oldSegmentIndex, size);
        this.file.seek((long)newSegmentIndex << this.segmentExponent);
        this.file.write(buffer, 0, size);
        this.chunkSegmentIndex[index] = newSegmentIndex;
        this.chunkNumBytes[index] = size;
        this.chunkNumSegments[index] = this.bytesToSegments(size);
        this.markChunkSegments(index, true);
        this.file.seek(0L + 4L * (long)index);
        this.file.writeInt(this.chunkSegmentIndex[index]);
        this.file.seek(4096L + 4L * (long)index);
        this.file.writeInt(this.chunkNumBytes[index]);
    }

    @Nullable
    public synchronized DataInputStream getInputStream(int x, int z) throws IOException {
        int index = this.getChunkIndex(x, z);
        int byteLength = this.chunkNumBytes[index];
        if (byteLength == 0) {
            return null;
        }
        byte[] data = new byte[byteLength];
        this.file.seek((long)this.chunkSegmentIndex[index] << this.segmentExponent);
        this.file.readFully(data);
        return new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(data)));
    }

    public synchronized void close() {
        try {
            this.file.close();
            this.segments.clear();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to close file", ioe);
        }
    }

    private synchronized void markChunkSegments(int index, boolean inUse) {
        int nextSetBit;
        if (this.chunkNumBytes[index] == 0) {
            return;
        }
        int start = this.chunkSegmentIndex[index];
        int end = start + this.chunkNumSegments[index];
        if (inUse && (nextSetBit = this.segments.nextSetBit(start)) != -1 && nextSetBit < end) {
            throw new IllegalStateException("Attempting to overwrite an in-use segment");
        }
        this.segments.set(start, end, inUse);
    }

    private synchronized void fixFileLength() throws IOException {
        int fileLength = (int)this.file.length();
        int extend = -fileLength & this.segmentMask;
        this.file.seek(fileLength);
        this.file.write(new byte[extend], 0, extend);
    }

    private synchronized int findContiguousSegments(int hint, int size) {
        if (size == 0) {
            return 0;
        }
        int segments = this.bytesToSegments(size);
        boolean oldFree = true;
        for (int i = hint; i < this.segments.size() && i < hint + segments; ++i) {
            if (!this.segments.get(i)) continue;
            oldFree = false;
            break;
        }
        if (oldFree) {
            return hint;
        }
        int start = 0;
        int current = 0;
        while (current < this.segments.size()) {
            boolean segmentInUse = this.segments.get(current);
            ++current;
            if (segmentInUse) {
                start = current;
            }
            if (current - start < segments) continue;
            return start;
        }
        return start;
    }

    private synchronized int bytesToSegments(int bytes) {
        if (bytes <= 0) {
            return 1;
        }
        return (bytes - 1 >> this.segmentExponent) + 1;
    }

    private synchronized int getChunkIndex(int x, int z) {
        if (this.rx != x >> 5 || this.rz != z >> 5) {
            throw new IndexOutOfBoundsException();
        }
        return ((x &= 0x1F) << 5) + (z &= 0x1F);
    }

    private static class McMMOSimpleChunkBuffer
    extends ByteArrayOutputStream {
        final McMMOSimpleRegionFile rf;
        final int index;

        McMMOSimpleChunkBuffer(McMMOSimpleRegionFile rf, int index) {
            super(DEFAULT_SEGMENT_SIZE);
            this.rf = rf;
            this.index = index;
        }

        @Override
        public void close() throws IOException {
            this.rf.write(this.index, this.buf, this.count);
        }
    }
}

