/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.commands;

import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.CancellableRunnable;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import com.gmail.nossr50.util.skills.SkillTools;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class McRankCommandDisplayTask
extends CancellableRunnable {
    private final Map<PrimarySkillType, Integer> skills;
    private final CommandSender sender;
    private final String playerName;
    private final boolean useBoard;
    private final boolean useChat;

    McRankCommandDisplayTask(Map<PrimarySkillType, Integer> skills, CommandSender sender, String playerName, boolean useBoard, boolean useChat) {
        this.skills = skills;
        this.sender = sender;
        this.playerName = playerName;
        this.useBoard = useBoard;
        this.useChat = useChat;
    }

    @Override
    public void run() {
        if (this.useBoard && mcMMO.p.getGeneralConfig().getScoreboardsEnabled()) {
            this.displayBoard();
        }
        if (this.useChat) {
            this.displayChat();
        }
        ((Player)this.sender).removeMetadata("mcMMO: Processing Database Command", (Plugin)mcMMO.p);
    }

    private void displayChat() {
        Integer rank;
        this.sender.sendMessage(LocaleLoader.getString("Commands.mcrank.Heading"));
        this.sender.sendMessage(LocaleLoader.getString("Commands.mcrank.Player", this.playerName));
        for (PrimarySkillType skill : SkillTools.NON_CHILD_SKILLS) {
            if (skill == PrimarySkillType.MACES && !mcMMO.getCompatibilityManager().getMinecraftGameVersion().isAtLeast(1, 21, 0)) continue;
            rank = this.skills.get((Object)skill);
            this.sender.sendMessage(LocaleLoader.getString("Commands.mcrank.Skill", mcMMO.p.getSkillTools().getLocalizedSkillName(skill), rank == null ? LocaleLoader.getString("Commands.mcrank.Unranked") : rank));
        }
        rank = this.skills.get(null);
        this.sender.sendMessage(LocaleLoader.getString("Commands.mcrank.Overall", rank == null ? LocaleLoader.getString("Commands.mcrank.Unranked") : rank));
    }

    public void displayBoard() {
        if (this.sender.getName().equalsIgnoreCase(this.playerName)) {
            ScoreboardManager.showPlayerRankScoreboard((Player)this.sender, this.skills);
        } else {
            ScoreboardManager.showPlayerRankScoreboardOthers((Player)this.sender, this.playerName, this.skills);
        }
    }
}

