/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.commands;

import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.commands.McRankCommandDisplayTask;
import com.gmail.nossr50.util.CancellableRunnable;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class McRankCommandAsyncTask
extends CancellableRunnable {
    private final String playerName;
    private final CommandSender sender;
    private final boolean useBoard;
    private final boolean useChat;

    public McRankCommandAsyncTask(String playerName, CommandSender sender, boolean useBoard, boolean useChat) {
        Validate.isTrue((useBoard || useChat ? 1 : 0) != 0, (String)"Attempted to start a rank retrieval with both board and chat off", (Object[])new Object[0]);
        Validate.notNull((Object)sender, (String)"Attempted to start a rank retrieval with no recipient", (Object[])new Object[0]);
        if (useBoard) {
            Validate.isTrue((boolean)(sender instanceof Player), (String)"Attempted to start a rank retrieval displaying scoreboard to a non-player", (Object[])new Object[0]);
        }
        this.playerName = playerName;
        this.sender = sender;
        this.useBoard = useBoard;
        this.useChat = useChat;
    }

    @Override
    public void run() {
        Map<PrimarySkillType, Integer> skills = mcMMO.getDatabaseManager().readRank(this.playerName);
        mcMMO.p.getFoliaLib().getScheduler().runNextTick(new McRankCommandDisplayTask(skills, this.sender, this.playerName, this.useBoard, this.useChat));
    }
}

