/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.Component;
import com.gmail.nossr50.skills.axes.Axes;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class AxesCommand
extends SkillCommand {
    private String critChance;
    private String critChanceLucky;
    private double axeMasteryDamage;
    private double impactDamage;
    private String skullSplitterLength;
    private String skullSplitterLengthEndurance;
    private boolean canSkullSplitter;
    private boolean canCritical;
    private boolean canAxeMastery;
    private boolean canImpact;
    private boolean canGreaterImpact;

    public AxesCommand() {
        super(PrimarySkillType.AXES);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue) {
        if (this.canImpact) {
            this.impactDamage = this.mmoPlayer.getAxesManager().getImpactDurabilityDamage();
        }
        if (this.canAxeMastery) {
            this.axeMasteryDamage = Axes.getAxeMasteryBonusDamage(player);
        }
        if (this.canCritical) {
            String[] criticalHitStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.AXES_CRITICAL_STRIKES);
            this.critChance = criticalHitStrings[0];
            this.critChanceLucky = criticalHitStrings[1];
        }
        if (this.canSkullSplitter) {
            String[] skullSplitterStrings = this.calculateLengthDisplayValues(player, skillValue);
            this.skullSplitterLength = skullSplitterStrings[0];
            this.skullSplitterLengthEndurance = skullSplitterStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canSkullSplitter = Permissions.skullSplitter((Permissible)player) && RankUtils.hasUnlockedSubskill(player, SubSkillType.AXES_SKULL_SPLITTER);
        this.canCritical = Permissions.canUseSubSkill(player, SubSkillType.AXES_CRITICAL_STRIKES);
        this.canAxeMastery = Permissions.canUseSubSkill(player, SubSkillType.AXES_AXE_MASTERY);
        this.canImpact = Permissions.canUseSubSkill(player, SubSkillType.AXES_ARMOR_IMPACT);
        this.canGreaterImpact = Permissions.canUseSubSkill(player, SubSkillType.AXES_GREATER_IMPACT);
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canImpact) {
            messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Axes.Ability.Bonus.2"), LocaleLoader.getString("Axes.Ability.Bonus.3", this.impactDamage)));
        }
        if (this.canAxeMastery) {
            messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Axes.Ability.Bonus.0"), LocaleLoader.getString("Axes.Ability.Bonus.1", this.axeMasteryDamage)));
        }
        if (this.canCritical) {
            messages.add(this.getStatMessage(SubSkillType.AXES_CRITICAL_STRIKES, this.critChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.critChanceLucky) : ""));
        }
        if (this.canGreaterImpact) {
            messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Axes.Ability.Bonus.4"), LocaleLoader.getString("Axes.Ability.Bonus.5", Axes.greaterImpactBonusDamage)));
        }
        if (this.canSkullSplitter) {
            messages.add(this.getStatMessage(SubSkillType.AXES_SKULL_SPLITTER, this.skullSplitterLength) + (hasEndurance ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.skullSplitterLengthEndurance) : ""));
        }
        if (Permissions.canUseSubSkill(player, SubSkillType.AXES_AXES_LIMIT_BREAK)) {
            messages.add(this.getStatMessage(SubSkillType.AXES_AXES_LIMIT_BREAK, String.valueOf(CombatUtils.getLimitBreakDamageAgainstQuality(player, SubSkillType.AXES_AXES_LIMIT_BREAK, 1000))));
        }
        return messages;
    }

    @Override
    protected List<Component> getTextComponents(Player player) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        TextComponentFactory.getSubSkillTextComponents(player, textComponents, PrimarySkillType.AXES);
        return textComponents;
    }
}

