/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.api.ItemSpawnReason;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.config.party.ItemWeightConfig;
import com.gmail.nossr50.datatypes.treasure.EnchantmentWrapper;
import com.gmail.nossr50.datatypes.treasure.FishingTreasureBook;
import com.gmail.nossr50.events.items.McMMOItemSpawnEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.smelting.Smelting;
import com.gmail.nossr50.util.MaterialUtils;
import com.gmail.nossr50.util.Misc;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemUtils {
    private static final Method customName = ItemUtils.getCustomNameMethod();

    private ItemUtils() {
    }

    private static Method getCustomNameMethod() {
        try {
            return ItemMeta.class.getMethod("customName", Component.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static void customName(ItemMeta itemMeta, Component name, String fallbackName) {
        if (customName != null) {
            ItemUtils.setItemNameModern(itemMeta, name);
        } else {
            itemMeta.setDisplayName(String.valueOf(ChatColor.RESET) + fallbackName);
        }
    }

    private static void setItemNameModern(ItemMeta itemMeta, Component name) {
        try {
            customName.invoke((Object)itemMeta, name);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            mcMMO.p.getLogger().severe("Failed to set item name: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static boolean isBow(@NotNull ItemStack item) {
        return mcMMO.getMaterialMapStore().isBow(item.getType().getKey().getKey());
    }

    @Nullable
    public static Material exhaustiveMaterialLookup(@NotNull String materialName) {
        Objects.requireNonNull(materialName, "materialName cannot be null");
        Material material = Material.matchMaterial((String)materialName);
        if (material == null) {
            material = Material.matchMaterial((String)materialName, (boolean)true);
        }
        if (material == null) {
            material = Material.getMaterial((String)materialName.toUpperCase(Locale.ENGLISH));
        }
        if (material == null) {
            material = Material.getMaterial((String)materialName.toUpperCase(Locale.ENGLISH), (boolean)true);
        }
        return material;
    }

    public static boolean hasItemIncludingOffHand(Player player, Material material) {
        boolean containsInMain = player.getInventory().contains(material);
        if (containsInMain) {
            return true;
        }
        return player.getInventory().getItemInOffHand().getType() == material;
    }

    public static void removeItemIncludingOffHand(@NotNull Player player, @NotNull Material material, int amount) {
        if (player.getInventory().contains(material)) {
            player.getInventory().removeItem(new ItemStack[]{new ItemStack(material, amount)});
            return;
        }
        ItemStack offHandItem = player.getInventory().getItemInOffHand();
        if (offHandItem.getType() == material) {
            int newAmount = offHandItem.getAmount() - amount;
            if (newAmount > 0) {
                offHandItem.setAmount(newAmount);
            } else {
                player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
            }
        }
    }

    public static boolean isCrossbow(@NotNull ItemStack item) {
        return mcMMO.getMaterialMapStore().isCrossbow(item.getType().getKey().getKey());
    }

    public static boolean isTrident(@NotNull ItemStack item) {
        return mcMMO.getMaterialMapStore().isTrident(item.getType().getKey().getKey());
    }

    public static boolean isMace(@NotNull ItemStack item) {
        return mcMMO.getMaterialMapStore().isMace(item.getType().getKey().getKey());
    }

    public static boolean hasItemInEitherHand(@NotNull Player player, Material material) {
        return player.getInventory().getItemInMainHand().getType() == material || player.getInventory().getItemInOffHand().getType() == material;
    }

    public static boolean doesPlayerHaveEnchantmentOnArmor(@NotNull Player player, @NotNull String enchantmentByName) {
        Enchantment enchantment = ItemUtils.getEnchantment(enchantmentByName);
        if (enchantment == null) {
            return false;
        }
        return ItemUtils.doesPlayerHaveEnchantmentOnArmor(player, enchantment);
    }

    public static boolean doesPlayerHaveEnchantmentOnArmor(@NotNull Player player, @NotNull Enchantment enchantment) {
        for (ItemStack itemStack : player.getInventory().getArmorContents()) {
            if (itemStack == null || !ItemUtils.hasEnchantment(itemStack, enchantment)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesPlayerHaveEnchantmentOnArmorOrHands(@NotNull Player player, @NotNull String enchantmentName) {
        Enchantment enchantment = ItemUtils.getEnchantment(enchantmentName);
        if (enchantment == null) {
            return false;
        }
        return ItemUtils.doesPlayerHaveEnchantmentOnArmorOrHands(player, enchantment);
    }

    public static boolean doesPlayerHaveEnchantmentOnArmorOrHands(@NotNull Player player, @NotNull Enchantment enchantment) {
        if (ItemUtils.doesPlayerHaveEnchantmentOnArmor(player, enchantment)) {
            return true;
        }
        return ItemUtils.doesPlayerHaveEnchantmentInHands(player, enchantment);
    }

    public static boolean doesPlayerHaveEnchantmentInHands(@NotNull Player player, @NotNull NamespacedKey enchantmentNameKey) {
        Enchantment enchantment = Enchantment.getByKey((NamespacedKey)enchantmentNameKey);
        if (enchantment == null) {
            return false;
        }
        return ItemUtils.doesPlayerHaveEnchantmentInHands(player, enchantment);
    }

    public static boolean doesPlayerHaveEnchantmentInHands(@NotNull Player player, @NotNull String enchantmentName) {
        Enchantment enchantment = ItemUtils.getEnchantment(enchantmentName);
        if (enchantment == null) {
            return false;
        }
        return ItemUtils.doesPlayerHaveEnchantmentInHands(player, enchantment);
    }

    public static boolean doesPlayerHaveEnchantmentInHands(@NotNull Player player, @NotNull Enchantment enchantment) {
        return ItemUtils.hasEnchantment(player.getInventory().getItemInMainHand(), enchantment) || ItemUtils.hasEnchantment(player.getInventory().getItemInOffHand(), enchantment);
    }

    public static boolean hasEnchantment(@NotNull ItemStack itemStack, @NotNull Enchantment enchantment) {
        if (itemStack.getItemMeta() != null) {
            return itemStack.getItemMeta().hasEnchant(enchantment);
        }
        return false;
    }

    @Nullable
    public static Enchantment getEnchantment(@NotNull String enchantmentName) {
        for (Enchantment enchantment : Enchantment.values()) {
            if (!enchantment.getKey().getKey().equalsIgnoreCase(enchantmentName)) continue;
            return enchantment;
        }
        return null;
    }

    public static boolean isSword(@NotNull ItemStack item) {
        return mcMMO.getMaterialMapStore().isSword(item.getType().getKey().getKey());
    }

    public static boolean isHoe(@NotNull ItemStack item) {
        return mcMMO.getMaterialMapStore().isHoe(item.getType().getKey().getKey());
    }

    public static boolean isShovel(@NotNull ItemStack item) {
        return mcMMO.getMaterialMapStore().isShovel(item.getType().getKey().getKey());
    }

    public static boolean isAxe(@NotNull ItemStack item) {
        return mcMMO.getMaterialMapStore().isAxe(item.getType().getKey().getKey());
    }

    public static boolean isPickaxe(@NotNull ItemStack item) {
        return mcMMO.getMaterialMapStore().isPickAxe(item.getType().getKey().getKey());
    }

    public static boolean isUnarmed(ItemStack item) {
        if (mcMMO.p.getGeneralConfig().getUnarmedItemsAsUnarmed()) {
            return !ItemUtils.isMinecraftTool(item);
        }
        return item.getType() == Material.AIR;
    }

    public static boolean isArmor(ItemStack item) {
        return mcMMO.getMaterialMapStore().isArmor(item.getType());
    }

    public static boolean isLeatherArmor(ItemStack item) {
        return mcMMO.getMaterialMapStore().isLeatherArmor(item.getType());
    }

    public static boolean isGoldArmor(ItemStack item) {
        return mcMMO.getMaterialMapStore().isGoldArmor(item.getType().getKey().getKey());
    }

    public static boolean isIronArmor(ItemStack item) {
        return mcMMO.getMaterialMapStore().isIronArmor(item.getType().getKey().getKey());
    }

    public static boolean isCopperArmor(ItemStack item) {
        return mcMMO.getMaterialMapStore().isCopperArmor(item.getType().getKey().getKey());
    }

    public static boolean isDiamondArmor(ItemStack item) {
        return mcMMO.getMaterialMapStore().isDiamondArmor(item.getType().getKey().getKey());
    }

    public static boolean isNetheriteArmor(ItemStack itemStack) {
        return mcMMO.getMaterialMapStore().isNetheriteArmor(itemStack.getType().getKey().getKey());
    }

    public static boolean isNetheriteTool(ItemStack itemStack) {
        return mcMMO.getMaterialMapStore().isNetheriteTool(itemStack.getType().getKey().getKey());
    }

    public static boolean isChainmailArmor(ItemStack item) {
        return mcMMO.getMaterialMapStore().isChainmailArmor(item.getType().getKey().getKey());
    }

    public static boolean isMinecraftTool(ItemStack item) {
        return mcMMO.getMaterialMapStore().isTool(item.getType().getKey().getKey());
    }

    public static boolean isStoneTool(ItemStack item) {
        return mcMMO.getMaterialMapStore().isStoneTool(item.getType().getKey().getKey());
    }

    public static boolean isWoodTool(ItemStack item) {
        return mcMMO.getMaterialMapStore().isWoodTool(item.getType().getKey().getKey());
    }

    public static boolean isStringTool(ItemStack item) {
        return mcMMO.getMaterialMapStore().isStringTool(item.getType().getKey().getKey());
    }

    public static boolean isPrismarineTool(ItemStack item) {
        return mcMMO.getMaterialMapStore().isPrismarineTool(item.getType().getKey().getKey());
    }

    public static boolean isCopperTool(ItemStack item) {
        return mcMMO.getMaterialMapStore().isCopperTool(item.getType().getKey().getKey());
    }

    public static boolean isGoldTool(ItemStack item) {
        return mcMMO.getMaterialMapStore().isGoldTool(item.getType().getKey().getKey());
    }

    public static boolean isIronTool(ItemStack item) {
        return mcMMO.getMaterialMapStore().isIronTool(item.getType().getKey().getKey());
    }

    public static boolean isDiamondTool(ItemStack item) {
        return mcMMO.getMaterialMapStore().isDiamondTool(item.getType().getKey().getKey());
    }

    public static boolean isEnchantable(ItemStack item) {
        return mcMMO.getMaterialMapStore().isEnchantable(item.getType().getKey().getKey());
    }

    public static boolean isSmeltable(ItemStack item) {
        return item != null && Smelting.getSmeltXP(item) >= 1;
    }

    public static boolean isSmelted(ItemStack item) {
        if (item == null) {
            return false;
        }
        for (Recipe recipe : mcMMO.p.getServer().getRecipesFor(item)) {
            if (!(recipe instanceof FurnaceRecipe) || !((FurnaceRecipe)recipe).getInput().getType().isBlock() || !MaterialUtils.isOre(((FurnaceRecipe)recipe).getInput().getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSharable(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        return ItemUtils.isMiningDrop(item) || ItemUtils.isWoodcuttingDrop(item) || ItemUtils.isMobDrop(item) || ItemUtils.isHerbalismDrop(item) || ItemUtils.isMiscDrop(item);
    }

    public static boolean isMiningDrop(ItemStack item) {
        return switch (item.getType()) {
            case Material.COAL, Material.COAL_ORE, Material.DIAMOND, Material.DIAMOND_ORE, Material.EMERALD, Material.EMERALD_ORE, Material.GOLD_ORE, Material.IRON_ORE, Material.LAPIS_ORE, Material.REDSTONE_ORE, Material.REDSTONE, Material.GLOWSTONE_DUST, Material.QUARTZ, Material.NETHER_QUARTZ_ORE, Material.LAPIS_LAZULI -> true;
            default -> false;
        };
    }

    public static boolean isHerbalismDrop(ItemStack item) {
        return switch (item.getType().getKey().getKey().toLowerCase()) {
            case "wheat", "wheat_seeds", "carrot", "chorus_fruit", "chorus_flower", "potato", "beetroot", "beetroots", "beetroot_seeds", "nether_wart", "brown_mushroom", "red_mushroom", "rose_bush", "dandelion", "cactus", "sugar_cane", "melon", "melon_seeds", "pumpkin", "pumpkin_seeds", "lily_pad", "vine", "tall_grass", "cocoa_beans" -> true;
            default -> false;
        };
    }

    public static boolean isMobDrop(ItemStack item) {
        return switch (item.getType()) {
            case Material.COAL, Material.STRING, Material.FEATHER, Material.CHICKEN, Material.COOKED_CHICKEN, Material.LEATHER, Material.BEEF, Material.COOKED_BEEF, Material.PORKCHOP, Material.COOKED_PORKCHOP, Material.WHITE_WOOL, Material.BLACK_WOOL, Material.BLUE_WOOL, Material.BROWN_WOOL, Material.CYAN_WOOL, Material.GRAY_WOOL, Material.GREEN_WOOL, Material.LIGHT_BLUE_WOOL, Material.LIGHT_GRAY_WOOL, Material.LIME_WOOL, Material.MAGENTA_WOOL, Material.ORANGE_WOOL, Material.PINK_WOOL, Material.PURPLE_WOOL, Material.RED_WOOL, Material.YELLOW_WOOL, Material.IRON_INGOT, Material.SNOWBALL, Material.BLAZE_ROD, Material.SPIDER_EYE, Material.GUNPOWDER, Material.ENDER_PEARL, Material.GHAST_TEAR, Material.MAGMA_CREAM, Material.BONE, Material.ARROW, Material.SLIME_BALL, Material.NETHER_STAR, Material.ROTTEN_FLESH, Material.GOLD_NUGGET, Material.EGG, Material.ROSE_BUSH -> true;
            default -> false;
        };
    }

    public static boolean isWoodcuttingDrop(ItemStack item) {
        return switch (item.getType().toString()) {
            case "ACACIA_LOG", "BIRCH_LOG", "DARK_OAK_LOG", "PALE_OAK_LOG", "JUNGLE_LOG", "OAK_LOG", "SPRUCE_LOG", "STRIPPED_ACACIA_LOG", "STRIPPED_BIRCH_LOG", "STRIPPED_DARK_OAK_LOG", "STRIPPED_PALE_OAK_LOG", "STRIPPED_JUNGLE_LOG", "STRIPPED_OAK_LOG", "STRIPPED_SPRUCE_LOG", "STRIPPED_MANGROVE_LOG", "ACACIA_SAPLING", "SPRUCE_SAPLING", "BIRCH_SAPLING", "DARK_OAK_SAPLING", "PALE_OAK_SAPLING", "JUNGLE_SAPLING", "OAK_SAPLING", "ACACIA_LEAVES", "BIRCH_LEAVES", "DARK_OAK_LEAVES", "PALE_OAK_LEAVES", "JUNGLE_LEAVES", "OAK_LEAVES", "SPRUCE_LEAVES", "BEE_NEST", "APPLE" -> true;
            default -> false;
        };
    }

    public static boolean isMiscDrop(ItemStack item) {
        return ItemWeightConfig.getInstance().getMiscItems().contains(item.getType());
    }

    public static boolean isMcMMOItem(ItemStack item) {
        if (!item.hasItemMeta()) {
            return false;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        return itemMeta.getLore() != null && itemMeta.getLore().contains("mcMMO Item");
    }

    public static boolean isChimaeraWing(ItemStack item) {
        if (!ItemUtils.isMcMMOItem(item)) {
            return false;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        return itemMeta.hasDisplayName() && itemMeta.getDisplayName().equals(String.valueOf(ChatColor.GOLD) + LocaleLoader.getString("Item.ChimaeraWing.Name"));
    }

    public static void removeAbilityLore(@NotNull ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        if (itemMeta.hasLore()) {
            List itemLore = itemMeta.getLore();
            if (itemLore == null) {
                return;
            }
            if (itemLore.remove("mcMMO Ability Tool")) {
                itemMeta.setLore(itemLore);
                itemStack.setItemMeta(itemMeta);
            }
        }
    }

    public static void addDigSpeedToItem(@NotNull ItemStack itemStack, int existingEnchantLevel) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        itemMeta.addEnchant(mcMMO.p.getEnchantmentMapper().getEfficiency(), existingEnchantLevel + mcMMO.p.getAdvancedConfig().getEnchantBuff(), true);
        itemStack.setItemMeta(itemMeta);
    }

    public static boolean canBeSuperAbilityDigBoosted(@NotNull ItemStack itemStack) {
        return ItemUtils.isShovel(itemStack) || ItemUtils.isPickaxe(itemStack);
    }

    @NotNull
    public static ItemStack createEnchantBook(@NotNull FishingTreasureBook fishingTreasureBook) {
        ItemStack itemStack = fishingTreasureBook.getDrop().clone();
        EnchantmentWrapper enchantmentWrapper = ItemUtils.getRandomEnchantment(fishingTreasureBook.getLegalEnchantments());
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta;
        enchantmentStorageMeta.addStoredEnchant(enchantmentWrapper.getEnchantment(), enchantmentWrapper.getEnchantmentLevel(), ExperienceConfig.getInstance().allowUnsafeEnchantments());
        itemStack.setItemMeta((ItemMeta)enchantmentStorageMeta);
        return itemStack;
    }

    @NotNull
    public static EnchantmentWrapper getRandomEnchantment(@NotNull List<EnchantmentWrapper> enchantmentWrappers) {
        Collections.shuffle(enchantmentWrappers, Misc.getRandom());
        int randomIndex = Misc.getRandom().nextInt(enchantmentWrappers.size());
        return enchantmentWrappers.get(randomIndex);
    }

    public static void spawnItems(@Nullable Player player, @NotNull Location location, @NotNull Collection<ItemStack> itemStacks, @NotNull ItemSpawnReason itemSpawnReason) {
        for (ItemStack is : itemStacks) {
            ItemUtils.spawnItem(player, location, is, itemSpawnReason);
        }
    }

    public static void spawnItems(@Nullable Player player, @NotNull Location location, @NotNull Collection<ItemStack> itemStacks, @NotNull Collection<Material> blackList, @NotNull ItemSpawnReason itemSpawnReason) {
        for (ItemStack is : itemStacks) {
            if (blackList.contains(is.getType())) continue;
            ItemUtils.spawnItem(player, location, is, itemSpawnReason);
        }
    }

    public static void spawnItems(@Nullable Player player, @NotNull Location location, @NotNull ItemStack is, int quantity, @NotNull ItemSpawnReason itemSpawnReason) {
        for (int i = 0; i < quantity; ++i) {
            ItemUtils.spawnItem(player, location, is, itemSpawnReason);
        }
    }

    @Nullable
    public static Item spawnItem(@Nullable Player player, @NotNull Location location, @NotNull ItemStack itemStack, @NotNull ItemSpawnReason itemSpawnReason) {
        if (itemStack.getType() == Material.AIR || location.getWorld() == null) {
            return null;
        }
        McMMOItemSpawnEvent event = new McMMOItemSpawnEvent(location, itemStack, itemSpawnReason, player);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        return location.getWorld().dropItem(location, event.getItemStack());
    }

    @Nullable
    public static Item spawnItemNaturally(@Nullable Player player, @NotNull Location location, @NotNull ItemStack itemStack, @NotNull ItemSpawnReason itemSpawnReason) {
        if (itemStack.getType() == Material.AIR || location.getWorld() == null) {
            return null;
        }
        McMMOItemSpawnEvent event = new McMMOItemSpawnEvent(location, itemStack, itemSpawnReason, player);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        return location.getWorld().dropItemNaturally(location, event.getItemStack());
    }

    public static void spawnItemsTowardsLocation(@Nullable Player player, @NotNull Location fromLocation, @NotNull Location toLocation, @NotNull ItemStack is, int quantity, double speed, @NotNull ItemSpawnReason itemSpawnReason) {
        for (int i = 0; i < quantity; ++i) {
            ItemUtils.spawnItemTowardsLocation(player, fromLocation, toLocation, is, speed, itemSpawnReason);
        }
    }

    @Nullable
    public static Item spawnItemTowardsLocation(@Nullable Player player, @NotNull Location fromLocation, @NotNull Location toLocation, @NotNull ItemStack itemToSpawn, double speed, @NotNull ItemSpawnReason itemSpawnReason) {
        if (itemToSpawn.getType() == Material.AIR) {
            return null;
        }
        ItemStack clonedItem = itemToSpawn.clone();
        Location spawnLocation = fromLocation.clone();
        Location targetLocation = toLocation.clone();
        if (spawnLocation.getWorld() == null) {
            return null;
        }
        McMMOItemSpawnEvent event = new McMMOItemSpawnEvent(spawnLocation, clonedItem, itemSpawnReason, player);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
        clonedItem = event.getItemStack();
        if (event.isCancelled()) {
            return null;
        }
        Item spawnedItem = spawnLocation.getWorld().dropItem(spawnLocation, clonedItem);
        Vector vecFrom = spawnLocation.clone().toVector().clone();
        Vector vecTo = targetLocation.clone().toVector().clone();
        Vector direction = vecTo.subtract(vecFrom).normalize();
        direction = direction.multiply(speed);
        spawnedItem.setVelocity(direction);
        return spawnedItem;
    }

    public static void spawnItemsFromCollection(@NotNull Player player, @NotNull Location location, @NotNull Collection<ItemStack> drops, @NotNull ItemSpawnReason itemSpawnReason) {
        Objects.requireNonNull(drops, "drops cannot be null");
        for (ItemStack drop : drops) {
            ItemUtils.spawnItem(player, location, drop, itemSpawnReason);
        }
    }

    public static void spawnItemsFromCollection(@Nullable Player player, @NotNull Location location, @NotNull Collection<ItemStack> drops, @NotNull ItemSpawnReason itemSpawnReason, int sizeLimit) {
        ItemStack[] arrayDrops = drops.toArray(new ItemStack[0]);
        for (int i = 0; i < sizeLimit - 1; ++i) {
            ItemUtils.spawnItem(player, location, arrayDrops[i], itemSpawnReason);
        }
    }

    public static void spawnItemsConditionally(@NotNull Collection<ItemStack> potentialItemDrops, @NotNull Predicate<ItemStack> predicate, @NotNull ItemSpawnReason itemSpawnReason, @NotNull Location spawnLocation, @NotNull Player player) {
        potentialItemDrops.stream().filter(predicate).forEach(itemStack -> ItemUtils.spawnItem(player, spawnLocation, itemStack, itemSpawnReason));
    }
}

