/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.skills;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.MetadataConstants;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class ProjectileUtils {
    public static Vector getNormal(BlockFace blockFace) {
        return switch (blockFace) {
            case BlockFace.UP -> new Vector(0, 1, 0);
            case BlockFace.DOWN -> new Vector(0, -1, 0);
            case BlockFace.NORTH -> new Vector(0, 0, -1);
            case BlockFace.SOUTH -> new Vector(0, 0, 1);
            case BlockFace.EAST -> new Vector(1, 0, 0);
            case BlockFace.WEST -> new Vector(-1, 0, 0);
            default -> new Vector(0, 0, 0);
        };
    }

    public static void cleanupProjectileMetadata(@NotNull AbstractArrow arrow) {
        MetadataConstants.ARROW_METADATA_KEYS.stream().filter(arg_0 -> ((AbstractArrow)arrow).hasMetadata(arg_0)).forEach(key -> arrow.removeMetadata(key, (Plugin)mcMMO.p));
    }

    public static void copyArrowMetadata(@NotNull Plugin pluginRef, @NotNull Arrow sourceArrow, @NotNull Arrow targetArrow) {
        MetadataConstants.ARROW_METADATA_KEYS.stream().filter(arg_0 -> ((Arrow)sourceArrow).hasMetadata(arg_0)).forEach(key -> {
            MetadataValue metadataValue = (MetadataValue)sourceArrow.getMetadata(key).get(0);
            if (key.equals("mcMMO: Bow Force")) {
                targetArrow.setMetadata(key, (MetadataValue)new FixedMetadataValue(pluginRef, (Object)metadataValue.asDouble()));
            } else if (key.equals("mcMMO: Crossbow Projectile")) {
                targetArrow.setMetadata(key, (MetadataValue)MetadataConstants.MCMMO_METADATA_VALUE);
            } else {
                targetArrow.setMetadata(key, metadataValue);
            }
        });
    }

    public static boolean isCrossbowProjectile(@NotNull AbstractArrow arrow) {
        return arrow.isShotFromCrossbow() || arrow.hasMetadata("mcMMO: Crossbow Projectile");
    }
}

