/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.skills.alchemy;

import com.gmail.nossr50.datatypes.skills.alchemy.AlchemyPotion;
import com.gmail.nossr50.util.PotionUtil;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;

public enum PotionStage {
    FIVE(5),
    FOUR(4),
    THREE(3),
    TWO(2),
    ONE(1);

    int numerical;

    private PotionStage(int numerical) {
        this.numerical = numerical;
    }

    public int toNumerical() {
        return this.numerical;
    }

    private static PotionStage getPotionStageNumerical(int numerical) {
        for (PotionStage potionStage : PotionStage.values()) {
            if (numerical < potionStage.toNumerical()) continue;
            return potionStage;
        }
        return ONE;
    }

    public static PotionStage getPotionStage(AlchemyPotion input, AlchemyPotion output) {
        PotionStage outputPotionStage = PotionStage.getPotionStage(output);
        PotionStage inputPotionStage = PotionStage.getPotionStage(input);
        if (!PotionStage.isWaterBottle(input) && inputPotionStage == outputPotionStage) {
            outputPotionStage = FIVE;
        }
        return outputPotionStage;
    }

    private static boolean isWaterBottle(AlchemyPotion alchemyPotion) {
        return PotionUtil.isPotionTypeWater(alchemyPotion.getAlchemyPotionMeta());
    }

    public static PotionStage getPotionStage(AlchemyPotion alchemyPotion) {
        PotionMeta potionMeta = alchemyPotion.getAlchemyPotionMeta();
        int stage = 1;
        if (!potionMeta.getCustomEffects().isEmpty() || PotionUtil.hasBasePotionEffects(potionMeta)) {
            ++stage;
        }
        if (PotionUtil.isStrong(potionMeta)) {
            ++stage;
        } else if (!potionMeta.getCustomEffects().isEmpty()) {
            for (PotionEffect effect : potionMeta.getCustomEffects()) {
                if (effect.getAmplifier() <= 0) continue;
                ++stage;
                break;
            }
        }
        if (PotionUtil.isLong(potionMeta)) {
            ++stage;
        }
        if (alchemyPotion.isSplash() || alchemyPotion.isLingering()) {
            ++stage;
        }
        return PotionStage.getPotionStageNumerical(stage);
    }
}

