/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.scoreboards;

import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.events.scoreboard.McMMOScoreboardMakeboardEvent;
import com.gmail.nossr50.events.scoreboard.ScoreboardEventReason;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardWrapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoreboardManager {
    static final Map<String, ScoreboardWrapper> PLAYER_SCOREBOARDS = new HashMap<String, ScoreboardWrapper>();
    static final String SIDEBAR_OBJECTIVE = "mcmmo_sidebar";
    static final String POWER_OBJECTIVE = "mcmmo_pwrlvl";
    static final String HEADER_STATS = LocaleLoader.getString("Scoreboard.Header.PlayerStats");
    static final String HEADER_COOLDOWNS = LocaleLoader.getString("Scoreboard.Header.PlayerCooldowns");
    static final String HEADER_RANK = LocaleLoader.getString("Scoreboard.Header.PlayerRank");
    static final String TAG_POWER_LEVEL = LocaleLoader.getString("Scoreboard.Header.PowerLevel");
    static final String POWER_LEVEL;
    static final String LABEL_POWER_LEVEL;
    static final String LABEL_LEVEL;
    static final String LABEL_CURRENT_XP;
    static final String LABEL_REMAINING_XP;
    static final Map<PrimarySkillType, String> skillLabels;
    static final Map<SuperAbilityType, String> abilityLabelsColored;
    static final Map<SuperAbilityType, String> abilityLabelsSkill;
    public static final String DISPLAY_NAME = "powerLevel";
    private static final List<String> dirtyPowerLevels;

    private static String formatAbility(String abilityName) {
        return ScoreboardManager.formatAbility(ChatColor.AQUA, abilityName);
    }

    private static String formatAbility(ChatColor color, String abilityName) {
        if (mcMMO.p.getGeneralConfig().getShowAbilityNames()) {
            return ScoreboardManager.getShortenedName(String.valueOf(color) + abilityName);
        }
        return String.valueOf(color) + LocaleLoader.getString("Scoreboard.Misc.Ability");
    }

    private static String getShortenedName(String name) {
        return ScoreboardManager.getShortenedName(name, true);
    }

    private static String getShortenedName(String name, boolean useDots) {
        if (((String)name).length() > 16) {
            name = useDots ? ((String)name).substring(0, 14) + ".." : ((String)name).substring(0, 16);
        }
        return name;
    }

    public static void setupPlayer(Player player) {
        ScoreboardManager.teardownPlayer(player);
        PLAYER_SCOREBOARDS.put(player.getName(), ScoreboardManager.makeNewScoreboard(player));
        dirtyPowerLevels.add(player.getName());
    }

    public static void teardownPlayer(Player player) {
        if (player == null) {
            return;
        }
        if (player.isOnline() && player.isValid() && Bukkit.getServer().getScoreboardManager() != null) {
            player.setScoreboard(Bukkit.getServer().getScoreboardManager().getMainScoreboard());
        }
        if (ScoreboardManager.getWrapper(player) != null) {
            ScoreboardWrapper wrapper = PLAYER_SCOREBOARDS.remove(player.getName());
            if (wrapper.revertTask != null) {
                wrapper.revertTask.cancel();
            }
        }
    }

    public static void teardownAll() {
        ImmutableList onlinePlayers = ImmutableList.copyOf((Collection)mcMMO.p.getServer().getOnlinePlayers());
        LogUtils.debug(mcMMO.p.getLogger(), "Tearing down scoreboards... (" + onlinePlayers.size() + ")");
        for (Player player : onlinePlayers) {
            ScoreboardManager.teardownPlayer(player);
        }
    }

    public static void cleanup(ScoreboardWrapper wrapper) {
        PLAYER_SCOREBOARDS.remove(wrapper.playerName);
        if (wrapper.revertTask != null) {
            wrapper.revertTask.cancel();
        }
    }

    public static void handleLevelUp(Player player, PrimarySkillType skill) {
        ScoreboardWrapper wrapper = ScoreboardManager.getWrapper(player);
        if (wrapper == null) {
            ScoreboardManager.setupPlayer(player);
            wrapper = ScoreboardManager.getWrapper(player);
        }
        if (wrapper != null) {
            if (wrapper.isSkillScoreboard() && wrapper.targetSkill == skill || wrapper.isStatsScoreboard() && wrapper.isBoardShown()) {
                wrapper.doSidebarUpdateSoon();
            }
            String playerName = player.getName();
            for (ScoreboardWrapper iWrapper : PLAYER_SCOREBOARDS.values()) {
                if (!iWrapper.isStatsScoreboard() || !playerName.equals(iWrapper.targetPlayer) || !wrapper.isBoardShown()) continue;
                wrapper.doSidebarUpdateSoon();
            }
            if (mcMMO.p.getGeneralConfig().getPowerLevelTagsEnabled() && !dirtyPowerLevels.contains(playerName)) {
                dirtyPowerLevels.add(playerName);
            }
            if (mcMMO.p.getGeneralConfig().getSkillLevelUpBoard()) {
                ScoreboardManager.enablePlayerSkillLevelUpScoreboard(player, skill);
            }
        }
    }

    public static void handleXp(Player player, PrimarySkillType skill) {
        ScoreboardWrapper wrapper = ScoreboardManager.getWrapper(player);
        if (wrapper != null && wrapper.isSkillScoreboard() && wrapper.targetSkill == skill && wrapper.isBoardShown()) {
            wrapper.doSidebarUpdateSoon();
        }
    }

    public static void cooldownUpdate(Player player, PrimarySkillType skill) {
        ScoreboardWrapper wrapper = ScoreboardManager.getWrapper(player);
        if (wrapper == null) {
            ScoreboardManager.setupPlayer(player);
            wrapper = ScoreboardManager.getWrapper(player);
        }
        if (wrapper != null && (wrapper.isCooldownScoreboard() || wrapper.isSkillScoreboard() && wrapper.targetSkill == skill) && wrapper.isBoardShown()) {
            wrapper.doSidebarUpdateSoon();
        }
    }

    public static void enablePlayerSkillScoreboard(Player player, PrimarySkillType skill) {
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        mmoPlayer.setLastSkillShownScoreboard(skill);
        ScoreboardWrapper wrapper = ScoreboardManager.getWrapper(player);
        if (wrapper == null) {
            ScoreboardManager.setupPlayer(player);
            wrapper = ScoreboardManager.getWrapper(player);
        }
        if (wrapper != null) {
            wrapper.setOldScoreboard();
            wrapper.setTypeSkill(skill);
            ScoreboardManager.changeScoreboard(wrapper, mcMMO.p.getGeneralConfig().getSkillScoreboardTime());
        }
    }

    public static void retryLastSkillBoard(Player player) {
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        PrimarySkillType primarySkillType = mmoPlayer.getLastSkillShownScoreboard();
        ScoreboardWrapper wrapper = ScoreboardManager.getWrapper(player);
        if (wrapper == null) {
            ScoreboardManager.setupPlayer(player);
            wrapper = ScoreboardManager.getWrapper(player);
        }
        if (wrapper != null) {
            wrapper.setOldScoreboard();
            wrapper.setTypeSkill(primarySkillType);
            ScoreboardManager.changeScoreboard(wrapper, mcMMO.p.getGeneralConfig().getSkillScoreboardTime());
        }
    }

    public static void enablePlayerSkillLevelUpScoreboard(Player player, PrimarySkillType skill) {
        ScoreboardWrapper wrapper = ScoreboardManager.getWrapper(player);
        if (wrapper != null && wrapper.isBoardShown()) {
            if (wrapper.isBoardShown()) {
                return;
            }
            wrapper.setOldScoreboard();
            wrapper.setTypeSkill(skill);
            ScoreboardManager.changeScoreboard(wrapper, mcMMO.p.getGeneralConfig().getSkillLevelUpTime());
        }
    }

    public static void enablePlayerStatsScoreboard(Player player) {
        ScoreboardWrapper wrapper = ScoreboardManager.getWrapper(player);
        if (wrapper == null) {
            return;
        }
        wrapper.setOldScoreboard();
        wrapper.setTypeSelfStats();
        ScoreboardManager.changeScoreboard(wrapper, mcMMO.p.getGeneralConfig().getStatsScoreboardTime());
    }

    public static void enablePlayerInspectScoreboard(@NotNull Player player, @NotNull PlayerProfile targetProfile) {
        ScoreboardWrapper wrapper = ScoreboardManager.getWrapper(player);
        if (wrapper == null) {
            ScoreboardManager.setupPlayer(player);
            wrapper = ScoreboardManager.getWrapper(player);
        }
        if (wrapper != null) {
            wrapper.setOldScoreboard();
            wrapper.setTypeInspectStats(targetProfile);
            ScoreboardManager.changeScoreboard(wrapper, mcMMO.p.getGeneralConfig().getInspectScoreboardTime());
        }
    }

    public static void enablePlayerInspectScoreboard(@NotNull Player player, @NotNull McMMOPlayer targetMcMMOPlayer) {
        ScoreboardWrapper wrapper = ScoreboardManager.getWrapper(player);
        if (wrapper == null) {
            ScoreboardManager.setupPlayer(player);
            wrapper = ScoreboardManager.getWrapper(player);
        }
        if (wrapper != null) {
            wrapper.setOldScoreboard();
            wrapper.setTypeInspectStats(targetMcMMOPlayer);
            ScoreboardManager.changeScoreboard(wrapper, mcMMO.p.getGeneralConfig().getInspectScoreboardTime());
        }
    }

    public static void enablePlayerCooldownScoreboard(Player player) {
        ScoreboardWrapper wrapper = ScoreboardManager.getWrapper(player);
        if (wrapper == null) {
            ScoreboardManager.setupPlayer(player);
            wrapper = ScoreboardManager.getWrapper(player);
        }
        if (wrapper != null) {
            wrapper.setOldScoreboard();
            wrapper.setTypeCooldowns();
            ScoreboardManager.changeScoreboard(wrapper, mcMMO.p.getGeneralConfig().getCooldownScoreboardTime());
        }
    }

    public static void showPlayerRankScoreboard(Player player, Map<PrimarySkillType, Integer> rank) {
        ScoreboardWrapper wrapper = ScoreboardManager.getWrapper(player);
        if (wrapper == null) {
            ScoreboardManager.setupPlayer(player);
            wrapper = ScoreboardManager.getWrapper(player);
        }
        if (wrapper != null) {
            wrapper.setOldScoreboard();
            wrapper.setTypeSelfRank();
            wrapper.acceptRankData(rank);
            ScoreboardManager.changeScoreboard(wrapper, mcMMO.p.getGeneralConfig().getRankScoreboardTime());
        }
    }

    public static void showPlayerRankScoreboardOthers(Player player, String targetName, Map<PrimarySkillType, Integer> rank) {
        ScoreboardWrapper wrapper = ScoreboardManager.getWrapper(player);
        if (wrapper == null) {
            ScoreboardManager.setupPlayer(player);
            wrapper = ScoreboardManager.getWrapper(player);
        }
        if (wrapper != null) {
            wrapper.setOldScoreboard();
            wrapper.setTypeInspectRank(targetName);
            wrapper.acceptRankData(rank);
            ScoreboardManager.changeScoreboard(wrapper, mcMMO.p.getGeneralConfig().getRankScoreboardTime());
        }
    }

    public static void showTopScoreboard(Player player, PrimarySkillType skill, int pageNumber, List<PlayerStat> stats) {
        ScoreboardWrapper wrapper = ScoreboardManager.getWrapper(player);
        if (wrapper == null) {
            ScoreboardManager.setupPlayer(player);
            wrapper = ScoreboardManager.getWrapper(player);
        }
        if (wrapper != null) {
            wrapper.setOldScoreboard();
            wrapper.setTypeTop(skill, pageNumber);
            wrapper.acceptLeaderboardData(stats);
            ScoreboardManager.changeScoreboard(wrapper, mcMMO.p.getGeneralConfig().getTopScoreboardTime());
        }
    }

    public static void showTopPowerScoreboard(Player player, int pageNumber, List<PlayerStat> stats) {
        ScoreboardWrapper wrapper = ScoreboardManager.getWrapper(player);
        if (wrapper == null) {
            ScoreboardManager.setupPlayer(player);
            wrapper = ScoreboardManager.getWrapper(player);
        }
        if (wrapper != null) {
            wrapper.setOldScoreboard();
            wrapper.setTypeTopPower(pageNumber);
            wrapper.acceptLeaderboardData(stats);
            ScoreboardManager.changeScoreboard(wrapper, mcMMO.p.getGeneralConfig().getTopScoreboardTime());
        }
    }

    @Nullable
    public static ScoreboardWrapper getWrapper(Player player) {
        if (PLAYER_SCOREBOARDS.get(player.getName()) == null) {
            ScoreboardManager.makeNewScoreboard(player);
        }
        return PLAYER_SCOREBOARDS.get(player.getName());
    }

    public static boolean powerLevelHeartbeat() {
        Objective mainObjective = ScoreboardManager.getPowerLevelObjective();
        if (mainObjective == null) {
            return false;
        }
        for (String playerName : dirtyPowerLevels) {
            McMMOPlayer mmoPlayer = UserManager.getPlayer(playerName);
            if (mmoPlayer == null) continue;
            Player player = mmoPlayer.getPlayer();
            int power = mmoPlayer.getPowerLevel();
            mainObjective.getScore(playerName).setScore(power);
            for (ScoreboardWrapper wrapper : PLAYER_SCOREBOARDS.values()) {
                wrapper.updatePowerLevel(player, power);
            }
        }
        dirtyPowerLevels.clear();
        return true;
    }

    @Nullable
    public static Objective getPowerLevelObjective() {
        if (!mcMMO.p.getGeneralConfig().getPowerLevelTagsEnabled()) {
            if (ScoreboardManager.getScoreboardManager() == null) {
                return null;
            }
            Objective objective = ScoreboardManager.getScoreboardManager().getMainScoreboard().getObjective(POWER_OBJECTIVE);
            if (objective != null) {
                objective.unregister();
                LogUtils.debug(mcMMO.p.getLogger(), "Removed leftover targetBoard objects from Power Level Tags.");
            }
            return null;
        }
        if (ScoreboardManager.getScoreboardManager() == null) {
            return null;
        }
        Objective powerObjective = ScoreboardManager.getScoreboardManager().getMainScoreboard().getObjective(POWER_OBJECTIVE);
        if (powerObjective == null) {
            powerObjective = ScoreboardManager.getScoreboardManager().getMainScoreboard().registerNewObjective(POWER_OBJECTIVE, "dummy", DISPLAY_NAME);
            powerObjective.setDisplayName(TAG_POWER_LEVEL);
            powerObjective.setDisplaySlot(DisplaySlot.BELOW_NAME);
        }
        return powerObjective;
    }

    @Nullable
    public static org.bukkit.scoreboard.ScoreboardManager getScoreboardManager() {
        return mcMMO.p.getServer().getScoreboardManager();
    }

    public static void changeScoreboard(ScoreboardWrapper wrapper, int displayTime) {
        if (displayTime == -1) {
            wrapper.showBoardWithNoRevert();
        } else {
            wrapper.showBoardAndScheduleRevert(displayTime * 20);
        }
    }

    public static boolean isBoardShown(String playerName) {
        return PLAYER_SCOREBOARDS.get(playerName).isBoardShown();
    }

    public static void clearBoard(String playerName) {
        PLAYER_SCOREBOARDS.get(playerName).tryRevertBoard();
    }

    public static void keepBoard(String playerName) {
        PLAYER_SCOREBOARDS.get(playerName).cancelRevert();
    }

    public static void setRevertTimer(String playerName, int seconds) {
        PLAYER_SCOREBOARDS.get(playerName).showBoardAndScheduleRevert(seconds * 20);
    }

    public static boolean isPlayerBoardSetup(@NotNull String playerName) {
        return PLAYER_SCOREBOARDS.get(playerName) != null;
    }

    @Nullable
    public static ScoreboardWrapper makeNewScoreboard(Player player) {
        if (ScoreboardManager.getScoreboardManager() == null) {
            return null;
        }
        Scoreboard scoreboard = ScoreboardManager.getScoreboardManager().getNewScoreboard();
        McMMOScoreboardMakeboardEvent event = new McMMOScoreboardMakeboardEvent(scoreboard, player.getScoreboard(), player, ScoreboardEventReason.CREATING_NEW_SCOREBOARD);
        player.getServer().getPluginManager().callEvent((Event)event);
        return new ScoreboardWrapper(event.getTargetPlayer(), event.getTargetBoard());
    }

    static {
        LABEL_POWER_LEVEL = POWER_LEVEL = LocaleLoader.getString("Scoreboard.Misc.PowerLevel");
        LABEL_LEVEL = LocaleLoader.getString("Scoreboard.Misc.Level");
        LABEL_CURRENT_XP = LocaleLoader.getString("Scoreboard.Misc.CurrentXP");
        LABEL_REMAINING_XP = LocaleLoader.getString("Scoreboard.Misc.RemainingXP");
        ImmutableMap.Builder skillLabelBuilder = ImmutableMap.builder();
        ImmutableMap.Builder abilityLabelBuilder = ImmutableMap.builder();
        ImmutableMap.Builder abilityLabelSkillBuilder = ImmutableMap.builder();
        if (mcMMO.p.getGeneralConfig().getScoreboardRainbows()) {
            ArrayList colors = Lists.newArrayList((Object[])new ChatColor[]{ChatColor.WHITE, ChatColor.YELLOW, ChatColor.LIGHT_PURPLE, ChatColor.RED, ChatColor.AQUA, ChatColor.GREEN, ChatColor.DARK_GRAY, ChatColor.BLUE, ChatColor.DARK_PURPLE, ChatColor.DARK_RED, ChatColor.DARK_AQUA, ChatColor.DARK_GREEN, ChatColor.DARK_BLUE});
            Collections.shuffle(colors, Misc.getRandom());
            int i = 0;
            for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
                skillLabelBuilder.put((Object)primarySkillType, (Object)ScoreboardManager.getShortenedName(String.valueOf(colors.get(i)) + mcMMO.p.getSkillTools().getLocalizedSkillName(primarySkillType), false));
                if (mcMMO.p.getSkillTools().getSuperAbility(primarySkillType) != null) {
                    abilityLabelBuilder.put((Object)mcMMO.p.getSkillTools().getSuperAbility(primarySkillType), (Object)ScoreboardManager.getShortenedName(String.valueOf(colors.get(i)) + mcMMO.p.getSkillTools().getSuperAbility(primarySkillType).getLocalizedName()));
                    if (primarySkillType == PrimarySkillType.MINING) {
                        abilityLabelBuilder.put((Object)SuperAbilityType.BLAST_MINING, (Object)ScoreboardManager.getShortenedName(String.valueOf(colors.get(i)) + SuperAbilityType.BLAST_MINING.getLocalizedName()));
                    }
                }
                if (++i != colors.size()) continue;
                i = 0;
            }
        } else {
            for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
                skillLabelBuilder.put((Object)primarySkillType, (Object)ScoreboardManager.getShortenedName(String.valueOf(ChatColor.GREEN) + mcMMO.p.getSkillTools().getLocalizedSkillName(primarySkillType)));
                if (mcMMO.p.getSkillTools().getSuperAbility(primarySkillType) == null) continue;
                abilityLabelBuilder.put((Object)mcMMO.p.getSkillTools().getSuperAbility(primarySkillType), (Object)ScoreboardManager.formatAbility(mcMMO.p.getSkillTools().getSuperAbility(primarySkillType).getLocalizedName()));
                if (primarySkillType != PrimarySkillType.MINING) continue;
                abilityLabelBuilder.put((Object)SuperAbilityType.BLAST_MINING, (Object)ScoreboardManager.formatAbility(SuperAbilityType.BLAST_MINING.getLocalizedName()));
            }
        }
        for (Enum enum_ : SuperAbilityType.values()) {
            abilityLabelSkillBuilder.put((Object)enum_, (Object)ScoreboardManager.formatAbility(enum_ == SuperAbilityType.BLAST_MINING ? ChatColor.BLUE : ChatColor.AQUA, ((SuperAbilityType)enum_).getLocalizedName()));
        }
        skillLabels = skillLabelBuilder.build();
        abilityLabelsColored = abilityLabelBuilder.build();
        abilityLabelsSkill = abilityLabelSkillBuilder.build();
        dirtyPowerLevels = new ArrayList<String>();
    }

    public static enum SidebarType {
        NONE,
        SKILL_BOARD,
        STATS_BOARD,
        COOLDOWNS_BOARD,
        RANK_BOARD,
        TOP_BOARD;

    }
}

