/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes;

import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.player.UserManager;
import java.util.function.Predicate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LevelUpBroadcastPredicate<T extends CommandSender>
implements Predicate<T> {
    @NotNull
    private final T broadcaster;

    public LevelUpBroadcastPredicate(@NotNull T broadcaster) {
        this.broadcaster = broadcaster;
    }

    @Override
    public boolean test(@NotNull T t) {
        Player broadcastingPlayer = (Player)this.broadcaster;
        if (!broadcastingPlayer.isOnline()) {
            return false;
        }
        McMMOPlayer mmoBroadcastingPlayer = UserManager.getPlayer(broadcastingPlayer);
        if (mmoBroadcastingPlayer == null) {
            mcMMO.p.getLogger().severe("McMMOPlayer was null for broadcaster in LevelUpBroadcastPredicate when it should never be null!");
            return false;
        }
        if (t instanceof Player) {
            Player listeningPlayer = (Player)t;
            if (mcMMO.p.getGeneralConfig().isLevelUpBroadcastsPartyMembersOnly()) {
                McMMOPlayer mmoListeningPlayer = UserManager.getPlayer(listeningPlayer);
                if (mmoListeningPlayer == null) {
                    return false;
                }
                Party playerWhoLeveledParty = mmoBroadcastingPlayer.getParty();
                Party broadcastRecipientParty = mmoListeningPlayer.getParty();
                if (playerWhoLeveledParty == null || broadcastRecipientParty == null) {
                    return false;
                }
                if (!playerWhoLeveledParty.equals(broadcastRecipientParty)) {
                    return false;
                }
            }
            if (LevelUpBroadcastPredicate.isLevelUpBroadcastsSameWorldOnly()) {
                if (!mmoBroadcastingPlayer.getPlayer().getWorld().equals((Object)listeningPlayer.getWorld())) {
                    return false;
                }
                if (mcMMO.p.getGeneralConfig().shouldLevelUpBroadcastsRestrictDistance() && !Misc.isNear(mmoBroadcastingPlayer.getPlayer().getLocation(), listeningPlayer.getLocation(), mcMMO.p.getGeneralConfig().getLevelUpBroadcastRadius())) {
                    return false;
                }
            }
            return listeningPlayer.canSee(mmoBroadcastingPlayer.getPlayer()) || listeningPlayer == mmoBroadcastingPlayer.getPlayer();
        }
        return mcMMO.p.getGeneralConfig().shouldLevelUpBroadcastToConsole();
    }

    private static boolean isLevelUpBroadcastsSameWorldOnly() {
        return mcMMO.p.getGeneralConfig().isLevelUpBroadcastsSameWorldOnly();
    }

    public String toString() {
        return "LevelUpBroadcastPredicate{broadcaster=" + String.valueOf(this.broadcaster) + "}";
    }
}

