/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.party;

import com.gmail.nossr50.config.party.ItemWeightConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.party.ItemShareType;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.ShareMode;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.player.UserManager;
import java.util.List;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class ShareHandler {
    private ShareHandler() {
    }

    public static boolean handleXpShare(float xp, McMMOPlayer mmoPlayer, PrimarySkillType primarySkillType, XPGainReason xpGainReason) {
        Party party = mmoPlayer.getParty();
        if (party.getXpShareMode() != ShareMode.EQUAL) {
            return false;
        }
        List<Player> nearMembers = mcMMO.p.getPartyManager().getNearVisibleMembers(mmoPlayer);
        if (nearMembers.isEmpty()) {
            return false;
        }
        nearMembers.add(mmoPlayer.getPlayer());
        int partySize = nearMembers.size();
        double shareBonus = Math.min(mcMMO.p.getGeneralConfig().getPartyShareBonusBase() + (double)partySize * mcMMO.p.getGeneralConfig().getPartyShareBonusIncrease(), mcMMO.p.getGeneralConfig().getPartyShareBonusCap());
        float splitXp = (float)((double)(xp / (float)partySize) * shareBonus);
        for (Player member : nearMembers) {
            if (UserManager.getPlayer(member) == null) continue;
            UserManager.getPlayer(member).beginUnsharedXpGain(primarySkillType, splitXp, xpGainReason, XPGainSource.PARTY_MEMBERS);
        }
        return true;
    }

    public static boolean handleItemShare(Item drop, McMMOPlayer mmoPlayer) {
        ItemStack itemStack = drop.getItemStack();
        ItemShareType dropType = ItemShareType.getShareType(itemStack);
        if (dropType == null) {
            return false;
        }
        Party party = mmoPlayer.getParty();
        if (!party.sharingDrops(dropType)) {
            return false;
        }
        ShareMode shareMode = party.getItemShareMode();
        if (shareMode == ShareMode.NONE) {
            return false;
        }
        List<Player> nearMembers = mcMMO.p.getPartyManager().getNearMembers(mmoPlayer);
        if (nearMembers.isEmpty()) {
            return false;
        }
        Player winningPlayer = null;
        ItemStack newStack = itemStack.clone();
        nearMembers.add(mmoPlayer.getPlayer());
        int partySize = nearMembers.size();
        drop.remove();
        newStack.setAmount(1);
        switch (shareMode) {
            case EQUAL: {
                int itemWeight = ItemWeightConfig.getInstance().getItemWeight(itemStack.getType());
                for (int i = 0; i < itemStack.getAmount(); ++i) {
                    int highestRoll = 0;
                    for (Player member : nearMembers) {
                        McMMOPlayer mcMMOMember = UserManager.getPlayer(member);
                        if (UserManager.getPlayer(member) == null) continue;
                        int itemShareModifier = mcMMOMember.getItemShareModifier();
                        int diceRoll = Misc.getRandom().nextInt(itemShareModifier);
                        if (diceRoll <= highestRoll) {
                            mcMMOMember.setItemShareModifier(itemShareModifier + itemWeight);
                            continue;
                        }
                        highestRoll = diceRoll;
                        if (winningPlayer != null) {
                            McMMOPlayer mcMMOWinning = UserManager.getPlayer(winningPlayer);
                            mcMMOWinning.setItemShareModifier(mcMMOWinning.getItemShareModifier() + itemWeight);
                        }
                        winningPlayer = member;
                    }
                    McMMOPlayer mcMMOTarget = UserManager.getPlayer(winningPlayer);
                    mcMMOTarget.setItemShareModifier(mcMMOTarget.getItemShareModifier() - itemWeight);
                    ShareHandler.awardDrop(winningPlayer, newStack);
                }
                return true;
            }
            case RANDOM: {
                for (int i = 0; i < itemStack.getAmount(); ++i) {
                    winningPlayer = nearMembers.get(Misc.getRandom().nextInt(partySize));
                    ShareHandler.awardDrop(winningPlayer, newStack);
                }
                return true;
            }
        }
        return false;
    }

    public static XPGainReason getSharedXpGainReason(XPGainReason xpGainReason) {
        if (xpGainReason == XPGainReason.PVE) {
            return XPGainReason.SHARED_PVE;
        }
        if (xpGainReason == XPGainReason.PVP) {
            return XPGainReason.SHARED_PVP;
        }
        return xpGainReason;
    }

    private static void awardDrop(Player winningPlayer, ItemStack drop) {
        if (!winningPlayer.getInventory().addItem(new ItemStack[]{drop}).isEmpty()) {
            winningPlayer.getWorld().dropItem(winningPlayer.getLocation(), drop);
        }
    }
}

