/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.skills;

import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.AbilityCooldownTask;
import com.gmail.nossr50.util.CancellableRunnable;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.skills.PerksUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class AbilityDisableTask
extends CancellableRunnable {
    private final McMMOPlayer mmoPlayer;
    private final SuperAbilityType ability;

    public AbilityDisableTask(McMMOPlayer mmoPlayer, SuperAbilityType ability) {
        this.mmoPlayer = mmoPlayer;
        this.ability = ability;
    }

    @Override
    public void run() {
        if (!this.mmoPlayer.getAbilityMode(this.ability)) {
            return;
        }
        Player player = this.mmoPlayer.getPlayer();
        switch (this.ability) {
            case SUPER_BREAKER: 
            case GIGA_DRILL_BREAKER: {
                SkillUtils.removeAbilityBoostsFromInventory(player);
            }
            case BERSERK: {
                if (!mcMMO.p.getGeneralConfig().getRefreshChunksEnabled()) break;
                this.resendChunkRadiusAt((Entity)player);
            }
        }
        EventUtils.callAbilityDeactivateEvent(player, this.ability);
        this.mmoPlayer.setAbilityMode(this.ability, false);
        this.mmoPlayer.setAbilityInformed(this.ability, false);
        if (this.mmoPlayer.useChatNotifications()) {
            NotificationManager.sendPlayerInformation(player, NotificationType.ABILITY_OFF, this.ability.getAbilityOff());
        }
        if (mcMMO.p.getAdvancedConfig().sendAbilityNotificationToOtherPlayers()) {
            SkillUtils.sendSkillMessage(player, NotificationType.SUPER_ABILITY_ALERT_OTHERS, this.ability.getAbilityPlayerOff());
        }
        if (!mcMMO.isServerShutdownExecuted()) {
            mcMMO.p.getFoliaLib().getScheduler().runAtEntityLater((Entity)player, new AbilityCooldownTask(this.mmoPlayer, this.ability), (long)PerksUtils.handleCooldownPerks(player, this.ability.getCooldown()) * 20L);
        }
    }

    private void resendChunkRadiusAt(Entity player) {
        Chunk chunk = player.getLocation().getChunk();
        World world = player.getWorld();
        int chunkX = chunk.getX();
        int chunkZ = chunk.getZ();
        int radius = 1;
        for (int x = chunkX - radius; x <= chunkX + radius; ++x) {
            for (int z = chunkZ - radius; z <= chunkZ + radius; ++z) {
                world.refreshChunk(x, z);
            }
        }
    }
}

