/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.upgrade;

import com.gmail.nossr50.config.BukkitConfig;
import com.gmail.nossr50.datatypes.database.UpgradeType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public class UpgradeManager
extends BukkitConfig {
    private final Set<UpgradeType> setNeededUpgrades = EnumSet.allOf(UpgradeType.class);

    public UpgradeManager() {
        super("upgrades_overhaul.yml");
        this.loadKeys();
    }

    public boolean shouldUpgrade(UpgradeType type) {
        return this.setNeededUpgrades.contains((Object)type);
    }

    public void setUpgradeCompleted(UpgradeType type) {
        if (!this.setNeededUpgrades.remove((Object)type)) {
            return;
        }
        LogUtils.debug(mcMMO.p.getLogger(), "Saving upgrade status for type " + type.toString() + "...");
        this.config.set("Upgrades_Finished." + String.valueOf((Object)type), (Object)true);
        try {
            this.config.save(this.getFile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void loadKeys() {
        for (UpgradeType type : UpgradeType.values()) {
            if (!this.config.getBoolean("Upgrades_Finished." + type.toString())) continue;
            this.setNeededUpgrades.remove((Object)type);
        }
        LogUtils.debug(mcMMO.p.getLogger(), "Needed upgrades: " + Arrays.toString((Object[])this.setNeededUpgrades.toArray(new UpgradeType[this.setNeededUpgrades.size()])));
    }
}

