/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.chat;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.BukkitCommandIssuer;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Conditions;
import co.aikar.commands.annotation.Default;
import com.gmail.nossr50.datatypes.chat.ChatChannel;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.text.StringUtils;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@CommandPermission(value="mcmmo.chat.partychat")
@CommandAlias(value="pc|p|partychat|pchat")
public class PartyChatCommand
extends BaseCommand {
    @NotNull
    private final mcMMO pluginRef;

    public PartyChatCommand(@NotNull mcMMO pluginRef) {
        this.pluginRef = pluginRef;
    }

    @Default
    @Conditions(value="partyCondition")
    public void processCommand(String[] args) {
        BukkitCommandIssuer bukkitCommandIssuer = (BukkitCommandIssuer)this.getCurrentCommandIssuer();
        if (args == null || args.length == 0) {
            if (bukkitCommandIssuer.isPlayer()) {
                McMMOPlayer mmoPlayer = UserManager.getPlayer(bukkitCommandIssuer.getPlayer());
                this.pluginRef.getChatManager().setOrToggleChatChannel(mmoPlayer, ChatChannel.PARTY);
            } else {
                mcMMO.p.getLogger().info("You cannot switch chat channels as console, please provide full arguments.");
            }
        } else if (bukkitCommandIssuer.getIssuer() instanceof Player) {
            McMMOPlayer mmoPlayer = UserManager.getPlayer(bukkitCommandIssuer.getPlayer());
            this.processCommandArgsPlayer(mmoPlayer, args);
        } else {
            this.processCommandArgsConsole(args);
        }
    }

    private void processCommandArgsPlayer(@NotNull McMMOPlayer mmoPlayer, @NotNull String[] args) {
        this.pluginRef.getChatManager().processPlayerMessage(mmoPlayer, args, ChatChannel.PARTY);
    }

    private void processCommandArgsConsole(@NotNull String[] args) {
        if (args.length <= 1) {
            mcMMO.p.getLogger().severe("You need to specify a party name and then write a message afterwards.");
        } else {
            Party targetParty = mcMMO.p.getPartyManager().getParty(args[0]);
            if (targetParty != null) {
                this.pluginRef.getChatManager().processConsoleMessage(StringUtils.buildStringAfterNthElement(args, 1), targetParty);
            } else {
                mcMMO.p.getLogger().severe("A party with that name doesn't exist!");
            }
        }
    }
}

